/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local;

import co.codewizards.cloudstore.core.ignore.IgnoreRuleManagerImpl;
import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.local.ContextWithPersistenceManager;
import co.codewizards.cloudstore.local.LocalRepoSync;
import co.codewizards.cloudstore.local.persistence.FileChunk;
import co.codewizards.cloudstore.local.persistence.LocalRepositoryDao;
import co.codewizards.cloudstore.local.persistence.NormalFile;
import co.codewizards.cloudstore.local.persistence.RemoteRepository;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryDao;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import javax.jdo.PersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.Cryptree;
import org.subshare.core.CryptreeFactory;
import org.subshare.core.CryptreeFactoryRegistry;
import org.subshare.core.crypto.KeyFactory;
import org.subshare.core.user.UserRepoKeyRing;
import org.subshare.core.user.UserRepoKeyRingLookup;
import org.subshare.core.user.UserRepoKeyRingLookupContext;
import org.subshare.local.FilePaddingLengthRandom;
import org.subshare.local.persistence.LocalRepositoryType;
import org.subshare.local.persistence.ScheduledReupload;
import org.subshare.local.persistence.ScheduledReuploadDao;
import org.subshare.local.persistence.SsFileChunk;
import org.subshare.local.persistence.SsLocalRepository;
import org.subshare.local.persistence.SsNormalFile;
import org.subshare.local.persistence.SsRemoteRepository;

public class SsLocalRepoSync
extends LocalRepoSync {
    private static final Logger logger = LoggerFactory.getLogger(SsLocalRepoSync.class);
    private SsLocalRepository localRepository;
    private UserRepoKeyRing userRepoKeyRing;
    private CryptreeFactory cryptreeFactory;
    private boolean processScheduledReuploadsDone;
    private Boolean deletedByIgnoreRule;

    protected SsLocalRepoSync(LocalRepoTransaction transaction) {
        super(transaction);
    }

    public void sync(ProgressMonitor monitor) {
        if (this.isMetaOnly()) {
            return;
        }
        this.processScheduledReuploads();
        super.sync(monitor);
    }

    private void processScheduledReuploads() {
        if (this.processScheduledReuploadsDone) {
            return;
        }
        ScheduledReuploadDao srDao = (ScheduledReuploadDao)((Object)this.transaction.getDao(ScheduledReuploadDao.class));
        Collection scheduledReuploads = srDao.getObjects();
        logger.debug("processScheduledReuploads: scheduledReuploads.size={} ", (Object)scheduledReuploads.size());
        long localRevision = this.transaction.getLocalRevision();
        for (ScheduledReupload scheduledReupload : scheduledReuploads) {
            if (logger.isDebugEnabled()) {
                logger.debug("processScheduledReuploads: scheduledReupload.repoFile.path='{}' localRevision={}", (Object)scheduledReupload.getRepoFile().getPath(), (Object)localRevision);
            }
            scheduledReupload.getRepoFile().setLocalRevision(localRevision);
            srDao.deletePersistent(scheduledReupload);
        }
        this.transaction.flush();
        this.processScheduledReuploadsDone = true;
    }

    private SsLocalRepository getLocalRepository() {
        if (this.localRepository == null) {
            this.localRepository = (SsLocalRepository)((LocalRepositoryDao)this.transaction.getDao(LocalRepositoryDao.class)).getLocalRepositoryOrFail();
        }
        return this.localRepository;
    }

    private boolean isMetaOnly() {
        return this.getLocalRepository().getLocalRepositoryType() == LocalRepositoryType.CLIENT_META_ONLY;
    }

    protected RepoFile sync(RepoFile parentRepoFile, File file, ProgressMonitor monitor, boolean resursiveChildren) {
        if (this.isMetaOnly()) {
            RepoFile repoFile = this.repoFileDao.getRepoFile(this.localRoot, file);
            return repoFile;
        }
        this.processScheduledReuploads();
        if (resursiveChildren && this.getLocalRepository().getLocalRepositoryType() == LocalRepositoryType.SERVER) {
            resursiveChildren = false;
        }
        RepoFile repoFile = super.sync(parentRepoFile, file, monitor, resursiveChildren);
        return repoFile;
    }

    protected RepoFile _createRepoFile(RepoFile parentRepoFile, File file, ProgressMonitor monitor) {
        RepoFile repoFile = super._createRepoFile(parentRepoFile, file, monitor);
        return repoFile;
    }

    protected void sha(NormalFile normalFile, File file, ProgressMonitor monitor) {
        AssertUtil.assertNotNull((Object)normalFile, (String)"normalFile");
        AssertUtil.assertNotNull((Object)file, (String)"file");
        AssertUtil.assertNotNull((Object)monitor, (String)"monitor");
        SsNormalFile nf = (SsNormalFile)normalFile;
        PersistenceManager pm = ((ContextWithPersistenceManager)this.transaction).getPersistenceManager();
        pm.getFetchPlan().setGroups(new String[]{"default"});
        HashMap<Long, SsFileChunk> original_offset2FileChunk = new HashMap<Long, SsFileChunk>(normalFile.getFileChunks().size());
        for (FileChunk fileChunk : normalFile.getFileChunks()) {
            SsFileChunk fc = (SsFileChunk)((Object)pm.detachCopy((Object)((SsFileChunk)fileChunk)));
            original_offset2FileChunk.put(fc.getOffset(), fc);
        }
        super.sha(normalFile, file, monitor);
        if (nf.getLengthWithPadding() < nf.getLength()) {
            this.assignLengthWithPadding(nf);
        }
        SsFileChunk lastNewFileChunk = null;
        long fileNoPaddingLength = nf.getLength();
        long fileWithPaddingLength = nf.getLengthWithPadding();
        long filePaddingLength = fileWithPaddingLength - fileNoPaddingLength;
        if (filePaddingLength > 0L) {
            for (FileChunk fileChunk : nf.getFileChunks()) {
                if (lastNewFileChunk != null && lastNewFileChunk.getOffset() >= fileChunk.getOffset()) continue;
                lastNewFileChunk = (SsFileChunk)fileChunk;
            }
            AssertUtil.assertNotNull(lastNewFileChunk, (String)"lastNewFileChunk");
            long offset = lastNewFileChunk.getOffset();
            lastNewFileChunk.makeWritable();
            int chunkWithPaddingLength = (int)Math.min(0x100000L, fileWithPaddingLength - offset);
            lastNewFileChunk.setLengthWithPadding(chunkWithPaddingLength);
            lastNewFileChunk.makeReadOnly();
            offset = lastNewFileChunk.getOffset() + (long)lastNewFileChunk.getLengthWithPadding();
            while (offset < fileWithPaddingLength) {
                chunkWithPaddingLength = (int)Math.min(0x100000L, fileWithPaddingLength - offset);
                SsFileChunk fileChunk = (SsFileChunk)((Object)original_offset2FileChunk.get(offset));
                if (fileChunk == null) {
                    fileChunk = this.createPaddingFileChunk(nf, offset, chunkWithPaddingLength);
                } else {
                    fileChunk.makeWritable();
                    fileChunk.setNormalFile(nf);
                    if (fileChunk.getLengthWithPadding() != chunkWithPaddingLength || fileChunk.getLength() != 0) {
                        fileChunk.setSha1(this.createRandomSha1());
                        fileChunk.setLengthWithPadding(chunkWithPaddingLength);
                        fileChunk.setLength(0);
                    }
                    fileChunk.makeReadOnly();
                }
                nf.getFileChunks().add(fileChunk);
                lastNewFileChunk = fileChunk;
                offset = lastNewFileChunk.getOffset() + (long)lastNewFileChunk.getLengthWithPadding();
            }
        }
    }

    protected void onFinalizeFileChunk(FileChunk fileChunk) {
        super.onFinalizeFileChunk(fileChunk);
        SsFileChunk fc = (SsFileChunk)fileChunk;
        fc.setLengthWithPadding(fc.getLength());
    }

    private SsFileChunk createPaddingFileChunk(SsNormalFile normalFile, long offset, int paddingLength) {
        AssertUtil.assertNotNull((Object)normalFile, (String)"normalFile");
        SsFileChunk fileChunk = (SsFileChunk)((Object)ObjectFactoryUtil.createObject(FileChunk.class));
        fileChunk.setNormalFile(normalFile);
        fileChunk.setOffset(offset);
        fileChunk.setSha1(this.createRandomSha1());
        fileChunk.setLengthWithPadding(paddingLength);
        fileChunk.setLength(0);
        return fileChunk;
    }

    private String createRandomSha1() {
        byte[] randomBytes = new byte[16];
        KeyFactory.secureRandom.nextBytes(randomBytes);
        String sha1 = HashUtil.sha1((byte[])randomBytes);
        return sha1;
    }

    private void assignLengthWithPadding(SsNormalFile normalFile) {
        File file = normalFile.getFile(this.localRoot);
        FilePaddingLengthRandom filePaddingLengthRandom = new FilePaddingLengthRandom(file);
        long paddingLength = filePaddingLengthRandom.nextPaddingLength();
        if (paddingLength < 0L) {
            throw new IllegalStateException("paddingLength < 0");
        }
        normalFile.setLengthWithPadding(normalFile.getLength() + paddingLength);
    }

    public void updateRepoFile(RepoFile repoFile, File file, ProgressMonitor monitor) {
        super.updateRepoFile(repoFile, file, monitor);
    }

    protected void createCopyModificationsIfPossible(NormalFile newNormalFile) {
    }

    protected void createDeleteModifications(RepoFile repoFile) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteRepoFileWithAllChildrenRecursively(RepoFile repoFile) {
        boolean deletedByIgnoreRuleControlledHere;
        Cryptree cryptree = this.getCryptree(this.transaction);
        String localPath = repoFile.getPath();
        File file = repoFile.getFile(this.localRoot);
        if (this.deletedByIgnoreRule == null) {
            deletedByIgnoreRuleControlledHere = true;
            this.deletedByIgnoreRule = IgnoreRuleManagerImpl.getInstanceForDirectory((File)file.getParentFile()).isIgnored(file);
        } else {
            deletedByIgnoreRuleControlledHere = false;
        }
        try {
            cryptree.preDelete(localPath, this.deletedByIgnoreRule.booleanValue());
            super.deleteRepoFileWithAllChildrenRecursively(repoFile);
        }
        finally {
            if (deletedByIgnoreRuleControlledHere) {
                this.deletedByIgnoreRule = null;
            }
        }
    }

    protected UserRepoKeyRing getUserRepoKeyRing() {
        if (this.userRepoKeyRing == null) {
            UserRepoKeyRingLookup lookup = UserRepoKeyRingLookup.Helper.getUserRepoKeyRingLookup();
            UserRepoKeyRingLookupContext context = new UserRepoKeyRingLookupContext(this.getClientRepositoryId(), this.getServerRepositoryId());
            this.userRepoKeyRing = lookup.getUserRepoKeyRing(context);
            if (this.userRepoKeyRing == null) {
                throw new IllegalStateException(String.format("UserRepoKeyRingLookup.getUserRepoKeyRing(context) returned null! lookup=%s context=%s", lookup, context));
            }
        }
        return this.userRepoKeyRing;
    }

    private UUID getServerRepositoryId() {
        Collection remoteRepositories = ((RemoteRepositoryDao)this.transaction.getDao(RemoteRepositoryDao.class)).getObjects();
        if (remoteRepositories.size() != 1) {
            throw new IllegalStateException("remoteRepositories.size() != 1");
        }
        return ((RemoteRepository)remoteRepositories.iterator().next()).getRepositoryId();
    }

    private String getServerPathPrefix() {
        Collection remoteRepositories = ((RemoteRepositoryDao)this.transaction.getDao(RemoteRepositoryDao.class)).getObjects();
        if (remoteRepositories.size() != 1) {
            throw new IllegalStateException("remoteRepositories.size() != 1");
        }
        return ((SsRemoteRepository)((Object)remoteRepositories.iterator().next())).getRemotePathPrefix();
    }

    private UUID getClientRepositoryId() {
        return this.getLocalRepository().getRepositoryId();
    }

    protected CryptreeFactory getCryptreeFactory() {
        if (this.cryptreeFactory == null) {
            this.cryptreeFactory = CryptreeFactoryRegistry.getInstance().getCryptreeFactoryOrFail();
        }
        return this.cryptreeFactory;
    }

    protected Cryptree getCryptree(LocalRepoTransaction transaction) {
        return this.getCryptreeFactory().getCryptreeOrCreate(transaction, this.getServerRepositoryId(), this.getServerPathPrefix(), this.getUserRepoKeyRing());
    }
}

