/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.sign;

import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.io.ByteArrayOutputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.io.NullOutputStream;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpEncoder;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpRegistry;
import org.subshare.core.sign.PgpSignable;

public class PgpSignableSigner {
    private final Pgp pgp;
    private final PgpKey pgpKey;

    public PgpSignableSigner(PgpKey pgpKey) {
        this(PgpRegistry.getInstance().getPgpOrFail(), pgpKey);
    }

    public PgpSignableSigner(Pgp pgp, PgpKey pgpKey) {
        this.pgp = (Pgp)AssertUtil.assertNotNull((Object)pgp, (String)"pgp");
        this.pgpKey = (PgpKey)AssertUtil.assertNotNull((Object)pgpKey, (String)"pgpKey");
    }

    public void sign(PgpSignable pgpSignable) {
        AssertUtil.assertNotNull((Object)pgpSignable, (String)"pgpSignable");
        String signedDataType = pgpSignable.getSignedDataType();
        if (StringUtil.isEmpty((String)signedDataType)) {
            throw new IllegalArgumentException(String.format("Implementation error in class %s: pgpSignable.getSignedDataType() returned null! %s", pgpSignable.getClass().getName(), pgpSignable));
        }
        int signedDataVersion = pgpSignable.getSignedDataVersion();
        if (signedDataVersion > 65535) {
            throw new IllegalStateException("signedDataVersion > 65535");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(1);
            out.write(signedDataVersion);
            out.write(signedDataVersion >>> 8);
            ByteArrayOutputStream signatureOut = new ByteArrayOutputStream();
            ByteArrayOutputStream additionalSignedDataOut = new ByteArrayOutputStream();
            additionalSignedDataOut.write(signedDataType.getBytes(StandardCharsets.UTF_8));
            try (InputStream signedDataInputStream = pgpSignable.getSignedData(signedDataVersion);
                 MultiInputStream in = new MultiInputStream(InputStreamSource.Helper.createInputStreamSource(new ByteArrayInputStream(additionalSignedDataOut.toByteArray())), InputStreamSource.Helper.createInputStreamSource(signedDataInputStream));){
                PgpEncoder pgpEncoder = this.pgp.createEncoder(in, new NullOutputStream());
                pgpEncoder.setSignPgpKey(this.pgpKey);
                pgpEncoder.setSignOutputStream((IOutputStream)signatureOut);
                pgpEncoder.encode();
            }
            byte[] signatureBytes = signatureOut.toByteArray();
            int signatureBytesLength = signatureBytes.length;
            out.write(signatureBytesLength);
            out.write(signatureBytesLength >>> 8);
            out.write(signatureBytesLength >>> 16);
            out.write(signatureBytesLength >>> 24);
            out.write(signatureBytes);
            pgpSignable.setPgpSignatureData(out.toByteArray());
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }
}

