/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.error;

import co.codewizards.cloudstore.core.dto.Error;
import co.codewizards.cloudstore.core.dto.RemoteExceptionUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.gui.util.PlatformUtil;

public class ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(ErrorHandler.class);
    private final String headerText;
    private final String contentText;
    private final Throwable error;
    private Alert alert;
    private final Map<Boolean, double[]> expanded2WidthHeight = new HashMap<Boolean, double[]>();
    private static final AtomicInteger serial = new AtomicInteger();
    private final Timer deferredWidthHeightHandlingTimer = new Timer("deferredWidthHeightHandlingTimer-" + serial.getAndIncrement(), true);
    private TimerTask deferredWidthHeightHandlingTimerTask;
    private static final Pattern fullyQualifiedClassNamePattern = Pattern.compile("^(?:[^\\d+\\-\\*/ \\.][^+\\-\\*/ \\.]*\\.)*[^+\\-\\*/ \\.]*$");
    private static final Thread.UncaughtExceptionHandler uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            ErrorHandler.handleError(e);
        }
    };
    private final ChangeListener<Number> widthHeightPropertyChangeListener = (observable, oldValue, newValue) -> {
        if (this.deferredWidthHeightHandlingTimerTask != null) {
            this.deferredWidthHeightHandlingTimerTask.cancel();
            this.deferredWidthHeightHandlingTimerTask = null;
        }
        this.deferredWidthHeightHandlingTimerTask = new TimerTask(){

            @Override
            public void run() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ErrorHandler.this.deferredWidthHeightHandlingTimerTask = null;
                        boolean expanded = ErrorHandler.this.alert.getDialogPane().isExpanded();
                        double[] widthHeight = new double[]{ErrorHandler.this.alert.getWidth(), ErrorHandler.this.alert.getHeight()};
                        ErrorHandler.this.expanded2WidthHeight.put(expanded, widthHeight);
                        logger.debug("widthHeightPropertyChangeListener: expanded={} width={} height={}", new Object[]{expanded, widthHeight[0], widthHeight[1]});
                    }
                });
            }
        };
        this.deferredWidthHeightHandlingTimer.schedule(this.deferredWidthHeightHandlingTimerTask, 500L);
    };

    public static Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return uncaughtExceptionHandler;
    }

    private ErrorHandler(String headerText, String contentText, Throwable error) {
        this.headerText = headerText;
        this.contentText = contentText;
        this.error = error;
    }

    public Throwable getError() {
        return this.error;
    }

    public static void handleError(String headerText, String contentText, Throwable error) {
        new ErrorHandler(headerText, contentText, error).doHandleError();
    }

    public static void handleError(Throwable error) {
        new ErrorHandler(null, null, error).doHandleError();
    }

    public static void handleError(String headerText, String contentText, Error error) {
        try {
            RemoteExceptionUtil.throwOriginalExceptionIfPossible((Error)error);
        }
        catch (Throwable throwable) {
            ErrorHandler.handleError(headerText, contentText, throwable);
        }
    }

    public static void handleError(Error error) {
        ErrorHandler.handleError(null, null, error);
    }

    protected String getHeaderText() {
        if (this.headerText == null) {
            return "Sorry! An error occurred!";
        }
        return this.headerText;
    }

    protected String getContentText() {
        if (this.contentText == null && this.error != null) {
            String localizedMessage;
            Throwable t;
            for (t = this.error; t != null; t = t.getCause()) {
                localizedMessage = t.getLocalizedMessage();
                if (StringUtil.isEmpty((String)localizedMessage) || this.isFullyQualifiedClassName(localizedMessage)) continue;
                return localizedMessage;
            }
            for (t = this.error; t != null; t = t.getCause()) {
                localizedMessage = t.getLocalizedMessage();
                if (StringUtil.isEmpty((String)localizedMessage)) continue;
                return localizedMessage;
            }
        }
        return this.contentText;
    }

    private boolean isFullyQualifiedClassName(String string) {
        if (StringUtil.isEmpty((String)string)) {
            return false;
        }
        return fullyQualifiedClassNamePattern.matcher(string).matches();
    }

    protected void doHandleError() {
        logger.error("doHandleError: " + this.error, this.error);
        PlatformUtil.runAndWait(new Runnable(){

            @Override
            public void run() {
                ErrorHandler.this._doHandleError();
            }
        });
    }

    protected void _doHandleError() {
        PlatformUtil.assertFxApplicationThread();
        this.buildAlert();
        try {
            this.alert.showAndWait();
        }
        catch (IllegalStateException x) {
            this.alert.show();
        }
    }

    protected void buildAlert() {
        PlatformUtil.assertFxApplicationThread();
        this.alert = new Alert(Alert.AlertType.ERROR);
        this.alert.setHeaderText(this.getHeaderText());
        this.alert.setContentText(this.getContentText());
        this.alert.getDialogPane().setMinSize(500.0, 250.0);
        if (this.error != null) {
            Label label = new Label("The exception stacktrace was:");
            TextArea textArea = new TextArea(ErrorHandler.getStackTrace(this.error));
            textArea.setEditable(false);
            textArea.setWrapText(true);
            textArea.setMaxWidth(Double.MAX_VALUE);
            textArea.setMaxHeight(Double.MAX_VALUE);
            GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
            GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
            GridPane expContent = new GridPane();
            expContent.setMaxWidth(Double.MAX_VALUE);
            expContent.add((Node)label, 0, 0);
            expContent.add((Node)textArea, 0, 1);
            this.alert.getDialogPane().setExpandableContent((Node)expContent);
            this.setUpExpandCollapseWorkaround();
        }
    }

    private void setUpExpandCollapseWorkaround() {
        this.alert.widthProperty().addListener(this.widthHeightPropertyChangeListener);
        this.alert.heightProperty().addListener(this.widthHeightPropertyChangeListener);
        this.alert.getDialogPane().expandedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                boolean expanded = ErrorHandler.this.alert.getDialogPane().isExpanded();
                double[] widthHeight = (double[])ErrorHandler.this.expanded2WidthHeight.get(expanded);
                double width = widthHeight == null ? Double.NaN : widthHeight[0];
                double height = widthHeight == null ? Double.NaN : widthHeight[1];
                logger.debug("alert.expandedProperty.changed: expanded={} width={} height={} >>>", new Object[]{expanded, width, height});
                ErrorHandler.this.alert.setWidth(Double.isNaN(width) ? 800.0 : width);
                ErrorHandler.this.alert.setHeight(Double.isNaN(height) ? 500.0 : height);
                logger.debug("alert.expandedProperty.changed: expanded={} width={} height={} <<<", new Object[]{expanded, width, height});
            }
        });
    }

    private static String getStackTrace(Throwable error) {
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        error.printStackTrace(pw);
        return w.toString();
    }
}

