/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.histo;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.dto.NormalFileDto;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.image.ImageView;
import org.subshare.core.dto.CollisionDto;
import org.subshare.core.dto.HistoCryptoRepoFileDto;
import org.subshare.core.dto.PlainHistoCryptoRepoFileDto;
import org.subshare.core.repo.LocalRepo;
import org.subshare.gui.histo.HistoCryptoRepoFileTreeItem;
import org.subshare.gui.histo.HistoryPane;
import org.subshare.gui.histo.HistoryPaneContainer;
import org.subshare.gui.histo.exp.ExportFromHistoryData;
import org.subshare.gui.histo.exp.ExportFromHistoryWizard;
import org.subshare.gui.resolvecollision.ResolveCollisionData;
import org.subshare.gui.resolvecollision.ResolveCollisionWizard;
import org.subshare.gui.util.PlatformUtil;
import org.subshare.gui.wizard.WizardDialog;

public class HistoryPaneSupport {
    private final HistoryPaneContainer container;
    private final LocalRepo localRepo;
    private final TabPane tabPane;
    private final Tab historyTab;
    private final Button resolveCollisionInHistoryButton;
    private final Button exportFromHistoryButton;
    private WeakReference<HistoryPane> historyPaneRef;
    private final InvalidationListener selectedHistoCryptoRepoFileTreeItemsInvalidationListener = observable -> this.selectedHistoCryptoRepoFileTreeItemsChanged();
    private final ObservableSet<Uid> selectedHistoCryptoRepoFileIds = FXCollections.observableSet(new HashSet());
    private final ObservableSet<Uid> selectedCollisionIds = FXCollections.observableSet(new HashSet());

    public HistoryPaneSupport(HistoryPaneContainer container) {
        PlatformUtil.assertFxApplicationThread();
        this.container = (HistoryPaneContainer)AssertUtil.assertNotNull((Object)container, (String)"container");
        this.localRepo = (LocalRepo)AssertUtil.assertNotNull((Object)this.container.getLocalRepo(), (String)"container.localRepo");
        this.tabPane = (TabPane)AssertUtil.assertNotNull((Object)this.container.getTabPane(), (String)"container.tabPane");
        this.historyTab = (Tab)AssertUtil.assertNotNull((Object)this.container.getHistoryTab(), (String)"container.historyTab");
        this.resolveCollisionInHistoryButton = (Button)AssertUtil.assertNotNull((Object)this.container.getResolveCollisionInHistoryButton(), (String)"container.resolveCollisionInHistoryButton");
        this.exportFromHistoryButton = (Button)AssertUtil.assertNotNull((Object)this.container.getExportFromHistoryButton(), (String)"container.exportFromHistoryButton");
        this.tabPane.getSelectionModel().selectedItemProperty().addListener(observable -> this.createOrForgetHistoryPane());
        this.selectedHistoCryptoRepoFileIds.addListener(observable -> this.selectedHistoCryptoRepoFileIdsChanged());
        this.selectedCollisionIds.addListener(observable -> this.selectedCollisionIdsChanged());
        this.configureResolveCollisionInHistoryButton();
        this.configureExportFromHistoryButton();
        this.createOrForgetHistoryPane();
    }

    private void configureResolveCollisionInHistoryButton() {
        String imageName = "collision-resolved_24x24.png";
        URL imageUrl = HistoryPaneSupport.class.getResource("collision-resolved_24x24.png");
        AssertUtil.assertNotNull((Object)imageUrl, (String)"imageUrl", (String)"imageName = %s", (Object[])new Object[]{"collision-resolved_24x24.png"});
        this.resolveCollisionInHistoryButton.setGraphic((Node)new ImageView(imageUrl.toString()));
        this.resolveCollisionInHistoryButton.setTooltip(new Tooltip("Resolve the selected collision(s). You may also undo resolutions."));
        this.resolveCollisionInHistoryButton.setOnAction(event -> this.resolveCollisionInHistoryButtonClicked((ActionEvent)event));
    }

    private void configureExportFromHistoryButton() {
        String imageName = "export-from-history_24x24.png";
        URL imageUrl = HistoryPaneSupport.class.getResource("export-from-history_24x24.png");
        AssertUtil.assertNotNull((Object)imageUrl, (String)"imageUrl", (String)"imageName = %s", (Object[])new Object[]{"export-from-history_24x24.png"});
        this.exportFromHistoryButton.setGraphic((Node)new ImageView(imageUrl.toString()));
        this.exportFromHistoryButton.setTooltip(new Tooltip("Export the selected file(s) from the history."));
        this.exportFromHistoryButton.setOnAction(event -> this.exportFromHistoryButtonClicked((ActionEvent)event));
    }

    public ObservableSet<Uid> getSelectedHistoCryptoRepoFileIds() {
        return this.selectedHistoCryptoRepoFileIds;
    }

    private void createOrForgetHistoryPane() {
        HistoryPane historyPane;
        PlatformUtil.assertFxApplicationThread();
        HistoryPane historyPane2 = historyPane = this.historyPaneRef == null ? null : (HistoryPane)((Object)this.historyPaneRef.get());
        if (historyPane != null) {
            historyPane.getSelectedHistoCryptoRepoFileTreeItems().removeListener(this.selectedHistoCryptoRepoFileTreeItemsInvalidationListener);
        }
        if (this.historyTab != this.tabPane.getSelectionModel().getSelectedItem()) {
            this.historyTab.setContent(null);
            this.setButtonsVisible(false);
            this.selectedHistoCryptoRepoFileIds.clear();
            return;
        }
        if (historyPane == null) {
            historyPane = new HistoryPane();
            historyPane.setLocalRepo(this.localRepo);
            historyPane.setLocalPath(this.container.getLocalPath());
            this.historyPaneRef = new WeakReference<HistoryPane>(historyPane);
        }
        historyPane.getSelectedHistoCryptoRepoFileTreeItems().addListener(this.selectedHistoCryptoRepoFileTreeItemsInvalidationListener);
        if (this.historyTab.getContent() == null) {
            this.historyTab.setContent((Node)historyPane);
        }
        this.setButtonsVisible(true);
        this.selectedHistoCryptoRepoFileTreeItemsChanged();
        this.selectedHistoCryptoRepoFileIdsChanged();
        this.selectedCollisionIdsChanged();
    }

    private void setButtonsVisible(boolean visible) {
        this.resolveCollisionInHistoryButton.setVisible(visible);
        this.resolveCollisionInHistoryButton.setManaged(visible);
        this.exportFromHistoryButton.setVisible(visible);
        this.exportFromHistoryButton.setManaged(visible);
    }

    private void selectedHistoCryptoRepoFileTreeItemsChanged() {
        HistoryPane historyPane = this.historyPaneRef == null ? null : (HistoryPane)((Object)this.historyPaneRef.get());
        List<Object> selectedTreeItems = historyPane == null ? Collections.emptyList() : historyPane.getSelectedHistoCryptoRepoFileTreeItems();
        HashSet<Uid> newSelectedHistoCryptoRepoFileIds = new HashSet<Uid>();
        HashSet<Uid> newCollisionIds = new HashSet<Uid>();
        for (TreeItem treeItem : selectedTreeItems) {
            if (treeItem == null) continue;
            HistoCryptoRepoFileTreeItem ti = (HistoCryptoRepoFileTreeItem)((Object)treeItem.getValue());
            HistoCryptoRepoFileDto histoCryptoRepoFileDto = ti.getHistoCryptoRepoFileDto();
            PlainHistoCryptoRepoFileDto plainHistoCryptoRepoFileDto = ti.getPlainHistoCryptoRepoFileDto();
            if (histoCryptoRepoFileDto != null && ti.getPlainHistoCryptoRepoFileDto().getRepoFileDto() instanceof NormalFileDto) {
                newSelectedHistoCryptoRepoFileIds.add(histoCryptoRepoFileDto.getHistoCryptoRepoFileId());
            }
            if (plainHistoCryptoRepoFileDto == null) continue;
            for (CollisionDto collisionDto : plainHistoCryptoRepoFileDto.getCollisionDtos()) {
                newCollisionIds.add(collisionDto.getCollisionId());
            }
        }
        this.selectedHistoCryptoRepoFileIds.retainAll(newSelectedHistoCryptoRepoFileIds);
        this.selectedHistoCryptoRepoFileIds.addAll(newSelectedHistoCryptoRepoFileIds);
        this.selectedCollisionIds.retainAll(newCollisionIds);
        this.selectedCollisionIds.addAll(newCollisionIds);
    }

    private void selectedCollisionIdsChanged() {
        this.resolveCollisionInHistoryButton.setDisable(this.selectedCollisionIds.isEmpty());
    }

    private void selectedHistoCryptoRepoFileIdsChanged() {
        this.exportFromHistoryButton.setDisable(this.selectedHistoCryptoRepoFileIds.isEmpty());
    }

    private void exportFromHistoryButtonClicked(ActionEvent event) {
        ExportFromHistoryData exportFromHistoryData = new ExportFromHistoryData(this.localRepo);
        exportFromHistoryData.getHistoCryptoRepoFileIds().addAll((Collection<Uid>)this.selectedHistoCryptoRepoFileIds);
        ExportFromHistoryWizard wizard = new ExportFromHistoryWizard(exportFromHistoryData);
        WizardDialog dialog = new WizardDialog(this.tabPane.getScene().getWindow(), wizard);
        dialog.show();
    }

    private void resolveCollisionInHistoryButtonClicked(ActionEvent event) {
        ResolveCollisionData resolveCollisionData = new ResolveCollisionData(this.localRepo, new HashSet<Uid>((Collection<Uid>)this.selectedCollisionIds));
        ResolveCollisionWizard wizard = new ResolveCollisionWizard(resolveCollisionData);
        WizardDialog dialog = new WizardDialog(this.tabPane.getScene().getWindow(), wizard);
        dialog.show();
    }
}

