/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.selectuser;

import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableSet;
import javafx.fxml.FXML;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import org.subshare.core.user.User;
import org.subshare.gui.userlist.UserListItem;
import org.subshare.gui.util.FxmlUtil;

public class SelectUserPane
extends GridPane {
    private final ObservableSet<User> selectedUsers;
    private final List<UserListItem> userListItems;
    private final Timer applyFilterLaterTimer = new Timer(true);
    private TimerTask applyFilterLaterTimerTask;
    @FXML
    private Text headerText;
    @FXML
    private TextField filterTextField;
    @FXML
    private TableView<UserListItem> tableView;
    private final ListChangeListener<UserListItem> selectedItemsChangeListener = new ListChangeListener<UserListItem>(){

        public void onChanged(ListChangeListener.Change<? extends UserListItem> c) {
            while (c.next()) {
                ArrayList<User> users = new ArrayList<User>(c.getRemoved().size());
                for (UserListItem userListItem : c.getRemoved()) {
                    users.add(userListItem.getUser());
                }
                SelectUserPane.this.selectedUsers.removeAll(users);
                users = new ArrayList(c.getAddedSubList().size());
                for (UserListItem userListItem : c.getAddedSubList()) {
                    users.add(userListItem.getUser());
                }
                SelectUserPane.this.selectedUsers.addAll(users);
            }
        }
    };

    public SelectUserPane() {
        this(Collections.emptyList(), Collections.emptyList(), SelectionMode.SINGLE, "Bla bla header");
    }

    public SelectUserPane(List<User> users, Collection<User> selectedUsers, SelectionMode selectionMode, String headerText) {
        UserListItem userListItem;
        AssertUtil.assertNotNull(users, (String)"users");
        AssertUtil.assertNotNull((Object)selectionMode, (String)"selectionMode");
        FxmlUtil.loadDynamicComponentFxml(SelectUserPane.class, this);
        this.headerText.setText(headerText);
        this.userListItems = new ArrayList<UserListItem>(users.size());
        IdentityHashMap<User, UserListItem> user2UserListItem = new IdentityHashMap<User, UserListItem>();
        for (User user : users) {
            if (user2UserListItem.put(user, userListItem = new UserListItem(user)) != null) {
                throw new IllegalArgumentException("Duplicate user element: " + user);
            }
            this.userListItems.add(userListItem);
        }
        this.tableView.getItems().addAll(this.userListItems);
        this.selectedUsers = selectedUsers instanceof ObservableSet ? (ObservableSet)selectedUsers : FXCollections.observableSet(new HashSet<User>(selectedUsers != null ? selectedUsers : Collections.emptyList()));
        for (User user : this.selectedUsers) {
            userListItem = (UserListItem)user2UserListItem.get(user);
            if (userListItem == null) {
                throw new IllegalArgumentException("selectedUsers contains user not being contained in users: " + user);
            }
            this.tableView.getSelectionModel().getSelectedItems().add((Object)userListItem);
        }
        this.filterTextField.textProperty().addListener(observable -> this.applyFilterLater());
        this.tableView.getSelectionModel().getSelectedItems().addListener(this.selectedItemsChangeListener);
        this.tableView.getSelectionModel().setSelectionMode(selectionMode);
        this.selectedUsers.addListener(observable -> this.updateComplete());
        this.updateComplete();
    }

    private void applyFilterLater() {
        if (this.applyFilterLaterTimerTask != null) {
            this.applyFilterLaterTimerTask.cancel();
            this.applyFilterLaterTimerTask = null;
        }
        this.applyFilterLaterTimerTask = new TimerTask(){

            @Override
            public void run() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SelectUserPane.this.applyFilterLaterTimerTask = null;
                        SelectUserPane.this.applyFilter();
                    }
                });
            }
        };
        this.applyFilterLaterTimer.schedule(this.applyFilterLaterTimerTask, 300L);
    }

    private void applyFilter() {
        String filterText = this.filterTextField.getText().toLowerCase();
        Iterator<UserListItem> sourceIterator = this.userListItems.iterator();
        ListIterator tableItemIterator = this.tableView.getItems().listIterator();
        HashSet<User> includedUsers = new HashSet<User>();
        while (sourceIterator.hasNext()) {
            UserListItem tableUserListItem;
            UserListItem sourceUserListItem = sourceIterator.next();
            boolean matchesFilter = sourceUserListItem.matchesFilter(filterText);
            if (matchesFilter) {
                includedUsers.add(sourceUserListItem.getUser());
            }
            UserListItem userListItem = tableUserListItem = tableItemIterator.hasNext() ? (UserListItem)tableItemIterator.next() : null;
            if (tableUserListItem == null) {
                if (!matchesFilter) continue;
                tableItemIterator.add(sourceUserListItem);
                continue;
            }
            if (tableUserListItem == sourceUserListItem) {
                if (matchesFilter) continue;
                tableItemIterator.remove();
                continue;
            }
            if (matchesFilter) {
                tableItemIterator.previous();
                tableItemIterator.add(sourceUserListItem);
                continue;
            }
            tableItemIterator.previous();
        }
        while (tableItemIterator.hasNext()) {
            tableItemIterator.next();
            tableItemIterator.remove();
        }
        this.selectedUsers.retainAll(includedUsers);
    }

    public void requestFocus() {
        super.requestFocus();
        this.tableView.requestFocus();
    }

    protected void updateComplete() {
    }

    public ObservableSet<User> getSelectedUsers() {
        return this.selectedUsers;
    }
}

