/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.repo.local.AbstractLocalRepoTransactionListener;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.ContextWithPersistenceManager;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.listener.CreateLifecycleListener;
import javax.jdo.listener.DeleteLifecycleListener;
import javax.jdo.listener.InstanceLifecycleEvent;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.listener.StoreLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.repo.listener.EntityId;
import org.subshare.core.repo.listener.EntityModification;
import org.subshare.core.repo.listener.EntityModificationType;
import org.subshare.core.repo.listener.LocalRepoCommitEventManagerImpl;

public class LocalRepoCommitEventManagerNotifyingListener
extends AbstractLocalRepoTransactionListener
implements CreateLifecycleListener,
StoreLifecycleListener,
DeleteLifecycleListener {
    private static final Logger logger = LoggerFactory.getLogger(LocalRepoCommitEventManagerNotifyingListener.class);
    private final Map<EntityId, EntityModification> entityId2LastModification = new HashMap<EntityId, EntityModification>();
    private final List<EntityModification> modifications = new LinkedList<EntityModification>();

    public void onBegin() {
        LocalRepoTransaction tx = this.getTransactionOrFail();
        PersistenceManager pm = ((ContextWithPersistenceManager)tx).getPersistenceManager();
        pm.addInstanceLifecycleListener((InstanceLifecycleListener)this, new Class[]{Object.class});
    }

    public void onCommit() {
        if (this.modifications.isEmpty()) {
            return;
        }
        LocalRepoManager localRepoManager = this.getTransactionOrFail().getLocalRepoManager();
        LocalRepoCommitEventManagerImpl localRepoCommitEventManagerImpl = (LocalRepoCommitEventManagerImpl)LocalRepoCommitEventManagerImpl.getInstance();
        localRepoCommitEventManagerImpl.fireLater(localRepoManager, this.modifications);
        this.modifications.clear();
        this.entityId2LastModification.clear();
    }

    public void preDelete(InstanceLifecycleEvent event) {
    }

    public void postDelete(InstanceLifecycleEvent event) {
        Object entity = AssertUtil.assertNotNull((Object)event.getPersistentInstance(), (String)"event.persistentInstance");
        EntityId entityId = this.getEntityId(entity);
        if (entityId != null) {
            this.enlist(new EntityModification(entityId, EntityModificationType.DELETE));
        }
    }

    public void preStore(InstanceLifecycleEvent event) {
    }

    public void postStore(InstanceLifecycleEvent event) {
        Object entity = AssertUtil.assertNotNull((Object)event.getPersistentInstance(), (String)"event.persistentInstance");
        EntityId entityId = this.getEntityId(entity);
        if (entityId != null) {
            this.enlist(new EntityModification(entityId, EntityModificationType.CHANGE));
        }
    }

    public void postCreate(InstanceLifecycleEvent event) {
        Object entity = AssertUtil.assertNotNull((Object)event.getPersistentInstance(), (String)"event.persistentInstance");
        EntityId entityId = this.getEntityId(entity);
        if (entityId != null) {
            this.enlist(new EntityModification(entityId, EntityModificationType.CREATE));
        }
    }

    private void enlist(EntityModification modification) {
        AssertUtil.assertNotNull((Object)modification, (String)"modification");
        EntityId entityId = modification.getEntityId();
        EntityModification lastModification = this.entityId2LastModification.get(entityId);
        if (lastModification != null) {
            if (lastModification.getType() == modification.getType()) {
                return;
            }
            if (lastModification.getType() == EntityModificationType.CREATE && modification.getType() == EntityModificationType.CHANGE) {
                return;
            }
            if (lastModification.getType() == EntityModificationType.DELETE && modification.getType() == EntityModificationType.CHANGE) {
                throw new IllegalStateException("WTF?! How can a deleted entity be changed?!");
            }
            if (lastModification.getType() == EntityModificationType.CHANGE && modification.getType() == EntityModificationType.CREATE) {
                throw new IllegalStateException("WTF?! How can an entity be created *after* it was changed?!");
            }
            if (lastModification.getType() == EntityModificationType.CHANGE && modification.getType() == EntityModificationType.DELETE) {
                this.modifications.remove(lastModification);
                this.entityId2LastModification.remove(entityId);
            }
            if (lastModification.getType() == EntityModificationType.CREATE && modification.getType() == EntityModificationType.DELETE) {
                this.modifications.remove(lastModification);
                this.entityId2LastModification.remove(entityId);
                return;
            }
        }
        this.modifications.add(modification);
        this.entityId2LastModification.put(entityId, modification);
    }

    private EntityId getEntityId(Object entity) {
        AssertUtil.assertNotNull((Object)entity, (String)"entity");
        if (entity instanceof Entity) {
            long id = ((Entity)entity).getId();
            return new EntityId(entity.getClass(), id);
        }
        logger.warn("getEntityId: entity is not an instance of Entity! class={} id={}", (Object)entity.getClass().getName(), JDOHelper.getObjectId((Object)entity));
        return null;
    }
}

