/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.localrepo.userrepokeylist;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.util.UUID;
import org.subshare.core.dto.DebugUserRepoKeyDto;
import org.subshare.core.dto.UserIdentityPayloadDto;

public class UserRepoKeyListItem {
    private final DebugUserRepoKeyDto debugUserRepoKeyDto;
    private final String name;

    public UserRepoKeyListItem(DebugUserRepoKeyDto debugUserRepoKeyDto) {
        this.debugUserRepoKeyDto = (DebugUserRepoKeyDto)AssertUtil.assertNotNull((Object)debugUserRepoKeyDto, (String)"debugUserRepoKeyDto");
        this.name = UserRepoKeyListItem._getName(debugUserRepoKeyDto.getUserIdentityPayloadDto());
    }

    private static String _getName(UserIdentityPayloadDto dto) {
        if (dto == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isEmpty((String)dto.getFirstName())) {
            sb.append(dto.getFirstName());
        }
        if (sb.length() > 0 && !StringUtil.isEmpty((String)dto.getLastName())) {
            sb.append(' ');
        }
        if (!StringUtil.isEmpty((String)dto.getLastName())) {
            sb.append(dto.getLastName());
        }
        return sb.toString();
    }

    public DebugUserRepoKeyDto getDebugUserRepoKeyDto() {
        return this.debugUserRepoKeyDto;
    }

    public Uid getUserRepoKeyId() {
        return this.debugUserRepoKeyDto.getUserRepoKeyId();
    }

    public UUID getServerRepositoryId() {
        return this.debugUserRepoKeyDto.getServerRepositoryId();
    }

    public boolean isOwner() {
        return this.debugUserRepoKeyDto.isOwner();
    }

    public boolean isInDatabase() {
        return this.debugUserRepoKeyDto.isInDatabase();
    }

    public String getKeyRingType() {
        DebugUserRepoKeyDto.KeyRingType keyRingType = this.debugUserRepoKeyDto.getKeyRingType();
        return keyRingType == null ? null : keyRingType.toString();
    }

    public int getUserIdentityCount() {
        return this.debugUserRepoKeyDto.getUserIdentityCount();
    }

    public boolean isInvitation() {
        return this.debugUserRepoKeyDto.isInvitation();
    }

    public String getName() {
        return this.name;
    }
}

