/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.wizard;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.subshare.gui.wizard.Wizard;
import org.subshare.gui.wizard.WizardPage;
import org.subshare.gui.wizard.WizardState;

public class WizardDialog
extends Stage {
    private final Wizard wizard;

    public WizardDialog(Window owner, Wizard wizard) {
        AssertUtil.assertNotNull((Object)owner, (String)"owner");
        this.wizard = (Wizard)((Object)AssertUtil.assertNotNull((Object)((Object)wizard), (String)"wizard"));
        this.setResizable(true);
        this.initStyle(StageStyle.UTILITY);
        this.initModality(Modality.APPLICATION_MODAL);
        this.initOwner(owner);
        this.setIconified(false);
        wizard.stateProperty().addListener(observable -> {
            switch ((WizardState)((Object)((Object)wizard.stateProperty().get()))) {
                case FINISHED: 
                case CANCELLED: {
                    this.close();
                    break;
                }
            }
        });
        wizard.init();
        this.setScene(new Scene((Parent)wizard));
        wizard.currentPageProperty().addListener(observable -> this.updateTitle());
        this.updateTitle();
        this.setOnShown(event -> {
            this.requestFocus();
            wizard.getCurrentPage().requestFocus();
        });
    }

    private void updateTitle() {
        String pageTitle;
        WizardPage currentPage = (WizardPage)((Object)this.wizard.currentPageProperty().get());
        String string = pageTitle = currentPage == null ? null : currentPage.getTitle();
        if (pageTitle == null || Util.equal((Object)this.wizard.getTitle(), (Object)pageTitle)) {
            this.setTitle(this.wizard.getTitle());
        } else {
            this.setTitle(String.format("%s \u2013 %s", this.wizard.getTitle(), pageTitle));
        }
    }
}

