/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.AutoTrackLocalRevision;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Discriminator;
import javax.jdo.annotations.DiscriminatorStrategy;
import javax.jdo.annotations.Index;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import org.bouncycastle.crypto.CipherParameters;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.state.StateManager;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.user.UserRepoKey;
import org.subshare.core.user.UserRepoKeyImpl;
import org.subshare.crypto.CryptoRegistry;

@PersistenceCapable
@Discriminator(strategy=DiscriminatorStrategy.VALUE_MAP, value="UserRepoKeyPublicKey")
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@Unique(name="UserRepoKeyPublicKey_userRepoKeyId", members={"userRepoKeyId"})
@Index(name="UserRepoKeyPublicKey_localRevision", members={"localRevision"})
@Queries(value={@Query(name="getUserRepoKeyPublicKey_userRepoKeyId", value="SELECT UNIQUE WHERE this.userRepoKeyId == :userRepoKeyId"), @Query(name="getUserRepoKeyPublicKeysChangedAfter_localRevision", value="SELECT WHERE this.localRevision > :localRevision")})
public class UserRepoKeyPublicKey
extends Entity
implements AutoTrackLocalRevision,
Persistable {
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(length=22)
    private String userRepoKeyId;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(length=36)
    private String serverRepositoryId;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(jdbcType="BLOB")
    private byte[] publicKeyData;
    private long localRevision;
    @NotPersistent
    private UserRepoKey.PublicKey publicKey;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public UserRepoKeyPublicKey() {
    }

    public UserRepoKeyPublicKey(Uid userRepoKeyId) {
        this.setUserRepoKeyId(userRepoKeyId);
    }

    public UserRepoKeyPublicKey(UserRepoKey.PublicKey publicKey) {
        AssertUtil.assertNotNull((Object)publicKey, (String)"publicKey");
        this.publicKey = publicKey;
        this.setUserRepoKeyId(publicKey.getUserRepoKeyId());
        this.setServerRepositoryId(publicKey.getServerRepositoryId());
        this.setPublicKeyData(CryptoRegistry.getInstance().encodePublicKey((CipherParameters)publicKey.getPublicKey()));
    }

    public Uid getUserRepoKeyId() {
        return UserRepoKeyPublicKey.dnGetuserRepoKeyId(this) == null ? null : new Uid(UserRepoKeyPublicKey.dnGetuserRepoKeyId(this));
    }

    protected void setUserRepoKeyId(Uid userRepoKeyId) {
        if (!Util.equal((Object)this.getUserRepoKeyId(), (Object)userRepoKeyId)) {
            UserRepoKeyPublicKey.dnSetuserRepoKeyId(this, userRepoKeyId == null ? null : userRepoKeyId.toString());
        }
    }

    public UUID getServerRepositoryId() {
        return UserRepoKeyPublicKey.dnGetserverRepositoryId(this) == null ? null : UUID.fromString(UserRepoKeyPublicKey.dnGetserverRepositoryId(this));
    }

    public void setServerRepositoryId(UUID serverRepositoryId) {
        if (!Util.equal((Object)this.getServerRepositoryId(), (Object)serverRepositoryId)) {
            UserRepoKeyPublicKey.dnSetserverRepositoryId(this, serverRepositoryId == null ? null : serverRepositoryId.toString());
        }
    }

    public byte[] getPublicKeyData() {
        return UserRepoKeyPublicKey.dnGetpublicKeyData(this);
    }

    public void setPublicKeyData(byte[] publicKeyData) {
        if (!Util.equal((byte[])UserRepoKeyPublicKey.dnGetpublicKeyData(this), (byte[])publicKeyData)) {
            UserRepoKeyPublicKey.dnSetpublicKeyData(this, publicKeyData);
        }
    }

    public long getLocalRevision() {
        return UserRepoKeyPublicKey.dnGetlocalRevision(this);
    }

    public void setLocalRevision(long localRevision) {
        if (!Util.equal((long)UserRepoKeyPublicKey.dnGetlocalRevision(this), (long)localRevision)) {
            UserRepoKeyPublicKey.dnSetlocalRevision(this, localRevision);
        }
    }

    public int getSignedDataVersion() {
        return 0;
    }

    public InputStream getSignedData(int signedDataVersion) {
        try {
            byte separatorIndex = 0;
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[5];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource((Uid)this.getUserRepoKeyId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource((byte[])this.getPublicKeyData());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[3] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[4] = InputStreamSource.Helper.createInputStreamSource((UUID)this.getServerRepositoryId());
            return new MultiInputStream(inputStreamSourceArray);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public UserRepoKey.PublicKey getPublicKey() {
        if (this.publicKey == null) {
            this.publicKey = this.createPublicKey();
        }
        return this.publicKey;
    }

    protected UserRepoKey.PublicKey createPublicKey() {
        try {
            return new UserRepoKeyImpl.PublicKeyImpl(this.getUserRepoKeyId(), this.getServerRepositoryId(), CryptoRegistry.getInstance().decodePublicKey(this.getPublicKeyData()), null, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return String.format("%s{userRepoKeyId=%s, serverRepositoryId=%s}", super.toString(), UserRepoKeyPublicKey.dnGetuserRepoKeyId(this), UserRepoKeyPublicKey.dnGetserverRepositoryId(this));
    }

    static {
        dnFieldNames = UserRepoKeyPublicKey.__dnFieldNamesInit();
        dnFieldTypes = UserRepoKeyPublicKey.__dnFieldTypesInit();
        dnFieldFlags = UserRepoKeyPublicKey.__dnFieldFlagsInit();
        dnInheritedFieldCount = UserRepoKeyPublicKey.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = UserRepoKeyPublicKey.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)UserRepoKeyPublicKey.___dn$loadClass("org.subshare.local.persistence.UserRepoKeyPublicKey"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new UserRepoKeyPublicKey());
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        UserRepoKeyPublicKey result = new UserRepoKeyPublicKey();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        UserRepoKeyPublicKey result = new UserRepoKeyPublicKey();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.localRevision = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 1: {
                this.publicKeyData = (byte[])this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 2: {
                this.serverRepositoryId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 3: {
                this.userRepoKeyId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.localRevision);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.publicKeyData);
                break;
            }
            case 2: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.serverRepositoryId);
                break;
            }
            case 3: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.userRepoKeyId);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(UserRepoKeyPublicKey obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.localRevision = obj.localRevision;
                break;
            }
            case 1: {
                this.publicKeyData = obj.publicKeyData;
                break;
            }
            case 2: {
                this.serverRepositoryId = obj.serverRepositoryId;
                break;
            }
            case 3: {
                this.userRepoKeyId = obj.userRepoKeyId;
                break;
            }
            default: {
                super.dnCopyField((Entity)obj, index);
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof UserRepoKeyPublicKey)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.UserRepoKeyPublicKey");
        }
        UserRepoKeyPublicKey other = (UserRepoKeyPublicKey)((Object)obj);
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"localRevision", "publicKeyData", "serverRepositoryId", "userRepoKeyId"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{Long.TYPE, UserRepoKeyPublicKey.___dn$loadClass("[B"), UserRepoKeyPublicKey.___dn$loadClass("java.lang.String"), UserRepoKeyPublicKey.___dn$loadClass("java.lang.String")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{21, 26, 21, 21};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 4 + Entity.dnGetManagedFieldCount();
    }

    private static Class __dnPersistableSuperclassInit() {
        return UserRepoKeyPublicKey.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Entity");
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        UserRepoKeyPublicKey o = (UserRepoKeyPublicKey)((Object)super.clone());
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static long dnGetlocalRevision(UserRepoKeyPublicKey objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.localRevision);
        }
        return objPC.localRevision;
    }

    private static void dnSetlocalRevision(UserRepoKeyPublicKey objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.localRevision, val);
        } else {
            objPC.localRevision = val;
        }
    }

    private static byte[] dnGetpublicKeyData(UserRepoKeyPublicKey objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return (byte[])objPC.dnStateManager.getObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.publicKeyData);
        }
        return objPC.publicKeyData;
    }

    private static void dnSetpublicKeyData(UserRepoKeyPublicKey objPC, byte[] val) {
        if (objPC.dnStateManager == null) {
            objPC.publicKeyData = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.publicKeyData, (Object)val);
        }
    }

    private static String dnGetserverRepositoryId(UserRepoKeyPublicKey objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.serverRepositoryId);
        }
        return objPC.serverRepositoryId;
    }

    private static void dnSetserverRepositoryId(UserRepoKeyPublicKey objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.serverRepositoryId, val);
        } else {
            objPC.serverRepositoryId = val;
        }
    }

    private static String dnGetuserRepoKeyId(UserRepoKeyPublicKey objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.userRepoKeyId);
        }
        return objPC.userRepoKeyId;
    }

    private static void dnSetuserRepoKeyId(UserRepoKeyPublicKey objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.userRepoKeyId, val);
        } else {
            objPC.userRepoKeyId = val;
        }
    }
}

