/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.rest.server.service;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.dto.UidList;
import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.io.ByteArrayOutputStream;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.io.LockFile;
import co.codewizards.cloudstore.core.io.LockFileFactory;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.bouncycastle.util.io.Streams;
import org.subshare.core.locker.LockerEncryptedDataFile;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.PgpRegistry;
import org.subshare.core.pgp.PgpSignature;
import org.subshare.rest.server.LockerDir;

@Path(value="_Locker")
public class LockerService {
    private static final String DATA_FILE_SUFFIX = ".data";
    @PathParam(value="pgpKeyId")
    private PgpKeyId pgpKeyId;
    @PathParam(value="lockerContentName")
    private String lockerContentName;
    private final File lockerDir = LockerDir.getInstance().getFile();
    private final Pgp pgp = PgpRegistry.getInstance().getPgpOrFail();

    @GET
    @Path(value="{pgpKeyId}/{lockerContentName}")
    @Produces(value={"application/xml"})
    public UidList getLockerContentVersions() {
        AssertUtil.assertNotNull((Object)this.pgpKeyId, (String)"pgpKeyId");
        AssertUtil.assertNotNull((Object)this.lockerContentName, (String)"lockerContentName");
        UidList result = new UidList();
        File dir = OioFileFactory.createFile((File)this.lockerDir, (String[])new String[]{this.pgpKeyId.toString(), this.lockerContentName});
        File[] children = dir.listFiles();
        if (children != null) {
            for (File file : children) {
                String fileName = file.getName();
                if (!fileName.endsWith(DATA_FILE_SUFFIX)) continue;
                String s = fileName.substring(0, fileName.length() - DATA_FILE_SUFFIX.length());
                result.add((Object)new Uid(s));
            }
        }
        return result;
    }

    @PUT
    @Consumes(value={"application/octet-stream"})
    public void putLockerEncryptedDataFile(InputStream inputStream) throws IOException {
        byte[] input = LockerService.safeRead(inputStream);
        LockerEncryptedDataFile encryptedDataFile = new LockerEncryptedDataFile(input);
        PgpSignature pgpSignature = encryptedDataFile.assertManifestSignatureValid();
        PgpKeyId signaturePgpKeyId = pgpSignature.getPgpKeyId();
        AssertUtil.assertNotNull((Object)signaturePgpKeyId, (String)"pgpSignature.pgpKeyId");
        PgpKey signaturePgpKey = this.pgp.getPgpKey(signaturePgpKeyId);
        AssertUtil.assertNotNull((Object)signaturePgpKey, (String)("pgp.getPgpKey(signaturePgpKeyId=" + signaturePgpKeyId + ")"));
        this.pgpKeyId = signaturePgpKey.getMasterKey().getPgpKeyId();
        this.lockerContentName = encryptedDataFile.getContentName();
        AssertUtil.assertNotNull((Object)this.lockerContentName, (String)"encryptedDataFile.contentName");
        Uid lockerContentVersion = encryptedDataFile.getContentVersion();
        AssertUtil.assertNotNull((Object)lockerContentVersion, (String)"encryptedDataFile.contentVersion");
        File file = OioFileFactory.createFile((File)this.lockerDir, (String[])new String[]{this.pgpKeyId.toString(), this.lockerContentName, lockerContentVersion.toString() + DATA_FILE_SUFFIX});
        file.getParentFile().mkdirs();
        try (LockFile lockFile = LockFileFactory.getInstance().acquire(file, 30000L);){
            if (lockFile.getFile().length() == (long)input.length) {
                ByteArrayInputStream newIn = new ByteArrayInputStream(input);
                try (InputStream oldIn = StreamUtil.castStream((IInputStream)lockFile.createInputStream());){
                    if (IOUtil.compareInputStreams((InputStream)newIn, (InputStream)oldIn)) {
                        return;
                    }
                }
            }
            try (IOutputStream out = lockFile.createOutputStream();){
                out.write(input);
            }
        }
        for (Uid replacedContentVersion : encryptedDataFile.getReplacedContentVersions()) {
            File f = OioFileFactory.createFile((File)file.getParentFile(), (String[])new String[]{replacedContentVersion.toString() + DATA_FILE_SUFFIX});
            f.delete();
            if (!f.exists()) continue;
            throw new IOException("Deleting file failed: " + f);
        }
    }

    @GET
    @Path(value="{pgpKeyId}/{lockerContentName}/{version}")
    @Produces(value={"application/octet-stream"})
    public Response getLockerEncryptedDataFile(@PathParam(value="version") String version) {
        AssertUtil.assertNotNull((Object)version, (String)"version");
        AssertUtil.assertNotNull((Object)this.pgpKeyId, (String)"pgpKeyId");
        AssertUtil.assertNotNull((Object)this.lockerContentName, (String)"lockerContentName");
        final File file = OioFileFactory.createFile((File)this.lockerDir, (String[])new String[]{this.pgpKeyId.toString(), this.lockerContentName, version.toString() + DATA_FILE_SUFFIX});
        if (!file.exists()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        StreamingOutput result = new StreamingOutput(){

            public void write(OutputStream out) throws IOException, WebApplicationException {
                File deletedFileToDeleteAgain;
                try (LockFile lockFile = LockFileFactory.getInstance().acquire(file, 30000L);){
                    try (InputStream in = StreamUtil.castStream((IInputStream)lockFile.createInputStream());){
                        Streams.pipeAll((InputStream)in, (OutputStream)out);
                        out.flush();
                    }
                    File f = lockFile.getFile();
                    deletedFileToDeleteAgain = f.length() == 0L ? f : null;
                }
                if (deletedFileToDeleteAgain != null) {
                    deletedFileToDeleteAgain.delete();
                }
            }
        };
        return Response.ok((Object)result).build();
    }

    private static byte[] safeRead(InputStream inputStream) throws IOException {
        int bytesRead;
        AssertUtil.assertNotNull((Object)inputStream, (String)"inputStream");
        int maxBytesLimit = 0x500000;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[65536];
        int totalBytesRead = 0;
        while ((bytesRead = inputStream.read(buf)) >= 0) {
            if (bytesRead <= 0) continue;
            if ((totalBytesRead += bytesRead) > 0x500000) {
                throw new IOException(String.format("Input buffer size (%d B) exceeded!", 0x500000));
            }
            out.write(buf, 0, bytesRead);
        }
        return out.toByteArray();
    }
}

