/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.sign;

import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum SignerTransformation {
    RSA_SHA1("RSA/SHA1"),
    RSA_SHA256("RSA/SHA256"),
    RSA_SHA512("RSA/SHA512");

    private static final Map<String, SignerTransformation> transformation2SignerTransformation;
    private final String transformation;
    public static final String CONFIG_KEY = "signerTransformation";
    public static final SignerTransformation CONFIG_DEFAULT_VALUE;

    private SignerTransformation(String transformation) {
        this.transformation = (String)AssertUtil.assertNotNull((Object)transformation, (String)"transformation");
    }

    public String getTransformation() {
        return this.transformation;
    }

    public static SignerTransformation fromTransformation(String transformation) {
        AssertUtil.assertNotNull((Object)transformation, (String)"transformation");
        SignerTransformation st = transformation2SignerTransformation.get(transformation);
        if (st == null) {
            throw new IllegalArgumentException("There is no SignerTransformation for this transformation: " + transformation);
        }
        return st;
    }

    static {
        HashMap<String, SignerTransformation> m = new HashMap<String, SignerTransformation>(SignerTransformation.values().length);
        for (SignerTransformation st : SignerTransformation.values()) {
            m.put(st.getTransformation(), st);
        }
        transformation2SignerTransformation = Collections.unmodifiableMap(m);
        CONFIG_DEFAULT_VALUE = RSA_SHA1;
    }
}

