/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.ConnectionFactoryNotFoundException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.UnsupportedConnectionFactoryException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.AbstractEmulatedXAResource;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.rdbms.ConnectionProvider;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.connectionpool.ConnectionPool;
import org.datanucleus.store.rdbms.connectionpool.ConnectionPoolFactory;
import org.datanucleus.transaction.TransactionUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    DataSource[] dataSources;
    ConnectionPool pool = null;

    public ConnectionFactoryImpl(StoreManager storeMgr, String resourceType) {
        super(storeMgr, resourceType);
        if (resourceType.equals("tx")) {
            this.initialiseDataSources();
        }
    }

    public void close() {
        if (this.pool != null) {
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"047010", (Object[])new Object[]{this.resourceType}));
            }
            this.pool.close();
        }
        super.close();
    }

    protected synchronized void initialiseDataSources() {
        if (this.resourceType.equals("tx")) {
            String requiredPoolingType = this.storeMgr.getStringProperty("datanucleus.connectionPoolingType");
            Object connDS = this.storeMgr.getConnectionFactory();
            String connJNDI = this.storeMgr.getConnectionFactoryName();
            String connURL = this.storeMgr.getConnectionURL();
            this.dataSources = this.generateDataSources(this.storeMgr, connDS, connJNDI, this.resourceType, requiredPoolingType, connURL);
            if (this.dataSources == null) {
                throw new NucleusUserException(Localiser.msg((String)"047009", (Object[])new Object[]{"transactional"})).setFatal();
            }
        } else {
            String requiredPoolingType = this.storeMgr.getStringProperty("datanucleus.connectionPoolingType.nontx");
            if (requiredPoolingType == null) {
                requiredPoolingType = this.storeMgr.getStringProperty("datanucleus.connectionPoolingType");
            }
            Object connDS = this.storeMgr.getConnectionFactory2();
            String connJNDI = this.storeMgr.getConnectionFactory2Name();
            String connURL = this.storeMgr.getConnectionURL();
            this.dataSources = this.generateDataSources(this.storeMgr, connDS, connJNDI, this.resourceType, requiredPoolingType, connURL);
            if (this.dataSources == null) {
                connDS = this.storeMgr.getConnectionFactory();
                connJNDI = this.storeMgr.getConnectionFactoryName();
                this.dataSources = this.generateDataSources(this.storeMgr, connDS, connJNDI, this.resourceType, requiredPoolingType, connURL);
            }
            if (this.dataSources == null) {
                throw new NucleusUserException(Localiser.msg((String)"047009", (Object[])new Object[]{"non-transactional"})).setFatal();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataSource[] generateDataSources(StoreManager storeMgr, Object connDS, String connJNDI, String resourceType, String requiredPoolingType, String connURL) {
        DataSource[] dataSources = null;
        if (connDS != null) {
            if (!(connDS instanceof DataSource) && !(connDS instanceof XADataSource)) {
                throw new UnsupportedConnectionFactoryException(connDS);
            }
            dataSources = new DataSource[]{(DataSource)connDS};
            return dataSources;
        }
        if (connJNDI != null) {
            String[] connectionFactoryNames = StringUtils.split((String)connJNDI, (String)",");
            dataSources = new DataSource[connectionFactoryNames.length];
            for (int i = 0; i < connectionFactoryNames.length; ++i) {
                Object obj;
                try {
                    obj = new InitialContext().lookup(connectionFactoryNames[i]);
                }
                catch (NamingException e) {
                    throw new ConnectionFactoryNotFoundException(connectionFactoryNames[i], (Exception)e);
                }
                if (!(obj instanceof DataSource) && !(obj instanceof XADataSource)) {
                    throw new UnsupportedConnectionFactoryException(obj);
                }
                dataSources[i] = (DataSource)obj;
            }
            return dataSources;
        }
        if (connURL == null) return dataSources;
        dataSources = new DataSource[1];
        String poolingType = ConnectionFactoryImpl.calculatePoolingType(storeMgr, requiredPoolingType);
        try {
            ConnectionPoolFactory connPoolFactory = (ConnectionPoolFactory)storeMgr.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store.rdbms.connectionpool", "name", poolingType, "class-name", null, null);
            if (connPoolFactory == null) {
                throw new NucleusUserException(Localiser.msg((String)"047003", (Object[])new Object[]{poolingType})).setFatal();
            }
            this.pool = connPoolFactory.createConnectionPool(storeMgr);
            dataSources[0] = this.pool.getDataSource();
            if (!NucleusLogger.CONNECTION.isDebugEnabled()) return dataSources;
            NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"047008", (Object[])new Object[]{resourceType, poolingType}));
            return dataSources;
        }
        catch (ClassNotFoundException cnfe) {
            throw new NucleusUserException(Localiser.msg((String)"047003", (Object[])new Object[]{poolingType}), (Throwable)cnfe).setFatal();
        }
        catch (Exception e) {
            if (!(e instanceof InvocationTargetException)) throw new NucleusException(Localiser.msg((String)"047004", (Object[])new Object[]{poolingType, e.getMessage()}), (Throwable)e).setFatal();
            InvocationTargetException ite = (InvocationTargetException)e;
            throw new NucleusException(Localiser.msg((String)"047004", (Object[])new Object[]{poolingType, ite.getTargetException().getMessage()}), ite.getTargetException()).setFatal();
        }
    }

    public ManagedConnection createManagedConnection(ExecutionContext ec, Map options) {
        if (this.dataSources == null) {
            this.initialiseDataSources();
        }
        ManagedConnectionImpl mconn = new ManagedConnectionImpl(ec, options);
        boolean singleConnection = this.storeMgr.getBooleanProperty("datanucleus.connection.singleConnectionPerExecutionContext");
        boolean releaseAfterUse = this.storeMgr.getBooleanProperty("datanucleus.connection.nontx.releaseAfterUse");
        if (!(ec == null || ec.getTransaction().isActive() || releaseAfterUse && !singleConnection)) {
            mconn.setCloseOnRelease(false);
        }
        return mconn;
    }

    protected static String calculatePoolingType(StoreManager storeMgr, String requiredPoolingType) {
        String poolingType = requiredPoolingType;
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        if (poolingType != null) {
            if (poolingType.equalsIgnoreCase("DBCP") && !ConnectionFactoryImpl.dbcpPresent(clr)) {
                NucleusLogger.CONNECTION.warn((Object)"DBCP specified but not present in CLASSPATH (or one of dependencies)");
                poolingType = null;
            } else if (poolingType.equalsIgnoreCase("C3P0") && !ConnectionFactoryImpl.c3p0Present(clr)) {
                NucleusLogger.CONNECTION.warn((Object)"C3P0 specified but not present in CLASSPATH (or one of dependencies)");
                poolingType = null;
            } else if (poolingType.equalsIgnoreCase("Proxool") && !ConnectionFactoryImpl.proxoolPresent(clr)) {
                NucleusLogger.CONNECTION.warn((Object)"Proxool specified but not present in CLASSPATH (or one of dependencies)");
                poolingType = null;
            } else if (poolingType.equalsIgnoreCase("BoneCP") && !ConnectionFactoryImpl.bonecpPresent(clr)) {
                NucleusLogger.CONNECTION.warn((Object)"BoneCP specified but not present in CLASSPATH (or one of dependencies)");
                poolingType = null;
            }
        }
        if (poolingType == null && ConnectionFactoryImpl.dbcpPresent(clr)) {
            poolingType = "DBCP";
        }
        if (poolingType == null && ConnectionFactoryImpl.c3p0Present(clr)) {
            poolingType = "C3P0";
        }
        if (poolingType == null && ConnectionFactoryImpl.proxoolPresent(clr)) {
            poolingType = "Proxool";
        }
        if (poolingType == null && ConnectionFactoryImpl.bonecpPresent(clr)) {
            poolingType = "BoneCP";
        }
        if (poolingType == null) {
            poolingType = "dbcp-builtin";
        }
        return poolingType;
    }

    protected static boolean dbcpPresent(ClassLoaderResolver clr) {
        try {
            clr.classForName("org.apache.commons.pool.ObjectPool");
            clr.classForName("org.apache.commons.dbcp.ConnectionFactory");
            return true;
        }
        catch (ClassNotResolvedException cnre) {
            return false;
        }
    }

    protected static boolean c3p0Present(ClassLoaderResolver clr) {
        try {
            clr.classForName("com.mchange.v2.c3p0.ComboPooledDataSource");
            return true;
        }
        catch (ClassNotResolvedException cnre) {
            return false;
        }
    }

    protected static boolean proxoolPresent(ClassLoaderResolver clr) {
        try {
            clr.classForName("org.logicalcobwebs.proxool.ProxoolDriver");
            clr.classForName("org.apache.commons.logging.Log");
            return true;
        }
        catch (ClassNotResolvedException cnre) {
            return false;
        }
    }

    protected static boolean bonecpPresent(ClassLoaderResolver clr) {
        try {
            clr.classForName("com.jolbox.bonecp.BoneCPDataSource");
            clr.classForName("org.slf4j.Logger");
            clr.classForName("com.google.common.collect.Multiset");
            return true;
        }
        catch (ClassNotResolvedException cnre) {
            return false;
        }
    }

    static class EmulatedXAResource
    extends AbstractEmulatedXAResource {
        Connection conn;

        EmulatedXAResource(ManagedConnection mconn) {
            super(mconn);
            this.conn = (Connection)mconn.getConnection();
        }

        public void commit(Xid xid, boolean onePhase) throws XAException {
            super.commit(xid, onePhase);
            try {
                this.conn.commit();
                ((ManagedConnectionImpl)this.mconn).xaRes = null;
            }
            catch (SQLException e) {
                NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"009020", (Object[])new Object[]{this.mconn.toString(), xid.toString(), onePhase}));
                XAException xe = new XAException(StringUtils.getStringFromStackTrace((Throwable)e));
                xe.initCause(e);
                throw xe;
            }
        }

        public void rollback(Xid xid) throws XAException {
            super.rollback(xid);
            try {
                this.conn.rollback();
                ((ManagedConnectionImpl)this.mconn).xaRes = null;
            }
            catch (SQLException e) {
                NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"009022", (Object[])new Object[]{this.mconn.toString(), xid.toString()}));
                XAException xe = new XAException(StringUtils.getStringFromStackTrace((Throwable)e));
                xe.initCause(e);
                throw xe;
            }
        }

        public void end(Xid xid, int flags) throws XAException {
            super.end(xid, flags);
            ((ManagedConnectionImpl)this.mconn).xaRes = null;
        }
    }

    class ManagedConnectionImpl
    extends AbstractManagedConnection {
        ExecutionContext ec;
        XAResource xaRes = null;
        int isolation;
        boolean needsCommitting = false;
        ConnectionProvider connProvider = null;
        private Map<String, Savepoint> savepoints = null;

        ManagedConnectionImpl(ExecutionContext ec, Map options) {
            this.isolation = options != null && options.get("transaction.isolation") != null ? ((Number)options.get("transaction.isolation")).intValue() : TransactionUtils.getTransactionIsolationLevelForName((String)ConnectionFactoryImpl.this.storeMgr.getStringProperty("datanucleus.transactionIsolation"));
            try {
                this.connProvider = (ConnectionProvider)ConnectionFactoryImpl.this.storeMgr.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store.rdbms.connectionprovider", "name", ConnectionFactoryImpl.this.storeMgr.getStringProperty("datanucleus.rdbms.connectionProviderName"), "class-name", null, null);
                if (this.connProvider == null) {
                    throw new NucleusException(Localiser.msg((String)"050000", (Object[])new Object[]{ConnectionFactoryImpl.this.storeMgr.getStringProperty("datanucleus.rdbms.connectionProviderName")})).setFatal();
                }
                this.connProvider.setFailOnError(ConnectionFactoryImpl.this.storeMgr.getBooleanProperty("datanucleus.rdbms.connectionProviderFailOnError"));
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"050001", (Object[])new Object[]{ConnectionFactoryImpl.this.storeMgr.getStringProperty("datanucleus.rdbms.connectionProviderName"), e.getMessage()}), (Throwable)e).setFatal();
            }
        }

        public void release() {
            if (this.commitOnRelease) {
                try {
                    Connection conn;
                    DatastoreAdapter dba = ((RDBMSStoreManager)ConnectionFactoryImpl.this.storeMgr).getDatastoreAdapter();
                    if (!dba.supportsOption("HoldCursorsOverCommit")) {
                        for (int i = 0; i < this.listeners.size(); ++i) {
                            ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
                        }
                    }
                    if ((conn = this.getSqlConnection()) != null && !conn.isClosed() && !conn.getAutoCommit()) {
                        ((RDBMSStoreManager)ConnectionFactoryImpl.this.storeMgr).getSQLController().processConnectionStatement((ManagedConnection)this);
                        this.needsCommitting = false;
                        if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                            NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"009015", (Object[])new Object[]{this.toString()}));
                        }
                        conn.commit();
                    }
                }
                catch (SQLException sqle) {
                    throw new NucleusDataStoreException(sqle.getMessage(), (Throwable)sqle);
                }
            }
            super.release();
        }

        public XAResource getXAResource() {
            if (this.xaRes != null) {
                return this.xaRes;
            }
            if (this.getConnection() instanceof Connection) {
                this.xaRes = new EmulatedXAResource((ManagedConnection)this);
            } else {
                try {
                    this.xaRes = ((XAConnection)this.getConnection()).getXAResource();
                }
                catch (SQLException e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
            }
            return this.xaRes;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object getConnection() {
            if (this.conn == null) {
                Connection cnx;
                block28: {
                    cnx = null;
                    try {
                        boolean readOnly;
                        RDBMSStoreManager rdbmsMgr = (RDBMSStoreManager)ConnectionFactoryImpl.this.storeMgr;
                        boolean bl = readOnly = this.ec != null ? this.ec.getBooleanProperty("datanucleus.readOnlyDatastore").booleanValue() : ConnectionFactoryImpl.this.storeMgr.getBooleanProperty("datanucleus.readOnlyDatastore");
                        if (rdbmsMgr.getDatastoreAdapter() != null) {
                            DatastoreAdapter rdba = rdbmsMgr.getDatastoreAdapter();
                            int reqdIsolationLevel = this.isolation;
                            if (rdba.getRequiredTransactionIsolationLevel() >= 0) {
                                reqdIsolationLevel = rdba.getRequiredTransactionIsolationLevel();
                            }
                            cnx = this.connProvider.getConnection(ConnectionFactoryImpl.this.dataSources);
                            boolean succeeded = false;
                            try {
                                if (cnx.isReadOnly() != readOnly) {
                                    NucleusLogger.CONNECTION.debug((Object)("Setting readonly=" + readOnly + " to connection: " + cnx.toString()));
                                    cnx.setReadOnly(readOnly);
                                }
                                if (reqdIsolationLevel == 0) {
                                    if (!cnx.getAutoCommit()) {
                                        cnx.setAutoCommit(true);
                                    }
                                } else {
                                    if (cnx.getAutoCommit()) {
                                        cnx.setAutoCommit(false);
                                    }
                                    if (rdba.supportsTransactionIsolation(reqdIsolationLevel)) {
                                        int currentIsolationLevel = cnx.getTransactionIsolation();
                                        if (currentIsolationLevel != reqdIsolationLevel) {
                                            cnx.setTransactionIsolation(reqdIsolationLevel);
                                        }
                                    } else {
                                        NucleusLogger.CONNECTION.warn((Object)Localiser.msg((String)"051008", (long)reqdIsolationLevel));
                                    }
                                }
                                if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                                    NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"009012", (Object[])new Object[]{this.toString(), TransactionUtils.getNameForTransactionIsolationLevel((int)reqdIsolationLevel), cnx.getAutoCommit()}));
                                }
                                if (reqdIsolationLevel != this.isolation && this.isolation == 0 && !cnx.getAutoCommit()) {
                                    NucleusLogger.CONNECTION.debug((Object)("Setting autocommit=true for connection: " + StringUtils.toJVMIDString((Object)cnx)));
                                    cnx.setAutoCommit(true);
                                }
                                if (succeeded = true) break block28;
                            }
                            catch (SQLException e) {
                                try {
                                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                                }
                                catch (Throwable throwable) {
                                    if (!succeeded) {
                                        try {
                                            cnx.close();
                                        }
                                        catch (SQLException e2) {
                                            // empty catch block
                                        }
                                        if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                                            NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"009013", (Object[])new Object[]{this.toString()}));
                                        }
                                    }
                                    throw throwable;
                                }
                            }
                            try {
                                cnx.close();
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                                NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"009013", (Object[])new Object[]{this.toString()}));
                            }
                            break block28;
                        }
                        cnx = ConnectionFactoryImpl.this.dataSources[0].getConnection();
                        if (cnx == null) {
                            String msg = Localiser.msg((String)"009010", (Object[])new Object[]{ConnectionFactoryImpl.this.dataSources[0]});
                            NucleusLogger.CONNECTION.error((Object)msg);
                            throw new NucleusDataStoreException(msg);
                        }
                        if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                            NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"009011", (Object[])new Object[]{this.toString()}));
                        }
                    }
                    catch (SQLException e) {
                        throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                    }
                }
                this.conn = cnx;
            }
            this.needsCommitting = true;
            return this.conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void close() {
            block23: {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
                }
                Connection conn = this.getSqlConnection();
                if (conn != null) {
                    block22: {
                        try {
                            if (!this.commitOnRelease || !this.needsCommitting || conn.isClosed() || conn.getAutoCommit()) break block22;
                            SQLController sqlController = ((RDBMSStoreManager)ConnectionFactoryImpl.this.storeMgr).getSQLController();
                            if (sqlController != null) {
                                sqlController.processConnectionStatement((ManagedConnection)this);
                            }
                            conn.commit();
                            this.needsCommitting = false;
                            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                                NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"009015", (Object[])new Object[]{this.toString()}));
                            }
                        }
                        catch (SQLException sqle) {
                            try {
                                throw new NucleusDataStoreException(sqle.getMessage(), (Throwable)sqle);
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (conn.isClosed()) {
                                        if (!NucleusLogger.CONNECTION.isDebugEnabled()) throw throwable;
                                        NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"009014", (Object[])new Object[]{this.toString()}));
                                        throw throwable;
                                    }
                                    if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                                        NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"009013", (Object[])new Object[]{this.toString()}));
                                    }
                                    conn.close();
                                    throw throwable;
                                }
                                catch (SQLException sqle2) {
                                    throw new NucleusDataStoreException(sqle2.getMessage(), (Throwable)sqle2);
                                }
                            }
                        }
                    }
                    try {
                        if (!conn.isClosed()) {
                            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                                NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"009013", (Object[])new Object[]{this.toString()}));
                            }
                            conn.close();
                            break block23;
                        }
                        if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                            NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"009014", (Object[])new Object[]{this.toString()}));
                        }
                    }
                    catch (SQLException sqle) {
                        throw new NucleusDataStoreException(sqle.getMessage(), (Throwable)sqle);
                    }
                }
            }
            try {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
                }
            }
            finally {
                this.listeners.clear();
            }
            if (this.savepoints != null) {
                this.savepoints.clear();
                this.savepoints = null;
            }
            this.conn = null;
            this.xaRes = null;
        }

        private Connection getSqlConnection() {
            if (this.conn != null && this.conn instanceof Connection) {
                return (Connection)this.conn;
            }
            if (this.conn != null && this.conn instanceof XAConnection) {
                try {
                    return ((XAConnection)this.conn).getConnection();
                }
                catch (SQLException e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
            }
            return null;
        }

        public void setSavepoint(String name) {
            try {
                Savepoint sp = ((Connection)this.conn).setSavepoint(name);
                if (this.savepoints == null) {
                    this.savepoints = new HashMap<String, Savepoint>();
                }
                this.savepoints.put(name, sp);
            }
            catch (SQLException sqle) {
                throw new NucleusDataStoreException("Exception setting savepoint " + name, (Throwable)sqle);
            }
        }

        public void releaseSavepoint(String name) {
            try {
                if (this.savepoints == null) {
                    return;
                }
                Savepoint sp = this.savepoints.remove(name);
                if (sp == null) {
                    throw new IllegalStateException("No savepoint with name " + name);
                }
                ((Connection)this.conn).releaseSavepoint(sp);
            }
            catch (SQLException sqle) {
                throw new NucleusDataStoreException("Exception releasing savepoint " + name, (Throwable)sqle);
            }
        }

        public void rollbackToSavepoint(String name) {
            try {
                if (this.savepoints == null) {
                    return;
                }
                Savepoint sp = this.savepoints.get(name);
                if (sp == null) {
                    throw new IllegalStateException("No savepoint with name " + name);
                }
                ((Connection)this.conn).rollback(sp);
            }
            catch (SQLException sqle) {
                throw new NucleusDataStoreException("Exception rolling back to savepoint " + name, (Throwable)sqle);
            }
        }

        public boolean closeAfterTransactionEnd() {
            if (ConnectionFactoryImpl.this.storeMgr.getBooleanProperty("datanucleus.connection.singleConnectionPerExecutionContext")) {
                return false;
            }
            return super.closeAfterTransactionEnd();
        }
    }
}

