/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.NormalFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.local.persistence.TempFileChunk;

public class TempFileChunkDao
extends Dao<TempFileChunk, TempFileChunkDao> {
    private static final Logger logger = LoggerFactory.getLogger(TempFileChunkDao.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TempFileChunk getTempFileChunk(NormalFile normalFile, UUID remoteRepositoryId, long offset) {
        AssertUtil.assertNotNull((Object)normalFile, (String)"repoFile");
        AssertUtil.assertNotNull((Object)remoteRepositoryId, (String)"remoteRepositoryId");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getTempFileChunk_normalFile_remoteRepositoryId_offset");
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(3);
            params.put("normalFile", normalFile);
            params.put("remoteRepositoryId", remoteRepositoryId.toString());
            params.put("offset", offset);
            long startTimestamp = System.currentTimeMillis();
            TempFileChunk result = (TempFileChunk)((Object)query.executeWithMap(params));
            logger.debug("getFileChunk: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            TempFileChunk tempFileChunk = result;
            return tempFileChunk;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TempFileChunk> getTempFileChunks(NormalFile normalFile) {
        AssertUtil.assertNotNull((Object)normalFile, (String)"repoFile");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getTempFileChunks_normalFile");
        try {
            HashMap<String, NormalFile> params = new HashMap<String, NormalFile>(1);
            params.put("normalFile", normalFile);
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.executeWithMap(params);
            logger.debug("getTempFileChunks: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getTempFileChunks: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TempFileChunk> getTempFileChunks(NormalFile normalFile, UUID remoteRepositoryId) {
        AssertUtil.assertNotNull((Object)normalFile, (String)"repoFile");
        AssertUtil.assertNotNull((Object)remoteRepositoryId, (String)"remoteRepositoryId");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getTempFileChunks_normalFile_remoteRepositoryId");
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("normalFile", normalFile);
            params.put("remoteRepositoryId", remoteRepositoryId.toString());
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.executeWithMap(params);
            logger.debug("getTempFileChunks: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getTempFileChunks: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }
}

