/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.invitation.issue.selectuser;

import co.codewizards.cloudstore.core.Severity;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javafx.collections.ObservableSet;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyValidity;
import org.subshare.core.user.User;
import org.subshare.gui.IconSize;
import org.subshare.gui.invitation.issue.IssueInvitationData;
import org.subshare.gui.invitation.issue.destination.IssueInvitationDestWizardPage;
import org.subshare.gui.invitation.issue.selectkey.SelectKeyWizardPage;
import org.subshare.gui.invitation.issue.selectuser.Messages;
import org.subshare.gui.ls.PgpLs;
import org.subshare.gui.ls.UserRegistryLs;
import org.subshare.gui.selectuser.SelectUserPane;
import org.subshare.gui.severity.SeverityImageRegistry;
import org.subshare.gui.wizard.WizardPage;

public class SelectUserWizardPage
extends WizardPage {
    private final IssueInvitationData issueInvitationData;
    private VBox contentVBox;
    private SelectUserPane selectUserPane;
    private Label statusLabel;
    private IssueInvitationDestWizardPage issueInvitationDestWizardPage;
    private SelectKeyWizardPage selectKeyWizardPage;
    private Pgp pgp;

    public SelectUserWizardPage(IssueInvitationData issueInvitationData) {
        super(Messages.getString("SelectUserWizardPage.title"));
        this.issueInvitationData = (IssueInvitationData)AssertUtil.assertNotNull((Object)issueInvitationData, (String)"issueInvitationData");
    }

    @Override
    protected void init() {
        super.init();
        this.issueInvitationDestWizardPage = new IssueInvitationDestWizardPage(this.issueInvitationData);
        this.setNextPage(this.issueInvitationDestWizardPage);
    }

    @Override
    protected Parent createContent() {
        ArrayList users = new ArrayList(UserRegistryLs.getUserRegistry().getUsers());
        this.contentVBox = new VBox(8.0);
        this.statusLabel = new Label();
        this.selectUserPane = new SelectUserPane(users, (Collection)this.issueInvitationData.getInvitees(), SelectionMode.MULTIPLE, Messages.getString("SelectUserWizardPage.selectUserPane.headerText")){

            @Override
            protected void updateComplete() {
                SelectUserWizardPage.this.determineComplete();
                if (SelectUserWizardPage.this.isComplete()) {
                    SelectUserWizardPage.this.determineNextPage();
                }
            }
        };
        this.contentVBox.getChildren().add(0, (Object)this.selectUserPane);
        return this.contentVBox;
    }

    private void determineComplete() {
        PgpKeyValidity validity;
        ObservableSet<User> invitees = this.issueInvitationData.getInvitees();
        boolean complete = true;
        Severity severity = null;
        this.statusLabel.setText(null);
        this.statusLabel.setTooltip(null);
        if (invitees.isEmpty()) {
            complete = false;
            severity = Severity.ERROR;
        }
        if (complete && StringUtil.isEmpty((String)this.statusLabel.getText())) {
            for (User invitee : invitees) {
                if (!invitee.getValidPgpKeys().isEmpty()) continue;
                complete = false;
                severity = Severity.ERROR;
                this.statusLabel.setText("At least one selected user does not have any valid PGP key!");
                this.statusLabel.setTooltip(new Tooltip("An invitation requires the invited user's PGP key. Either this user has no \nkey at all, or all his keys are unusable (disabled, revoked or expired).\n\nPlease ask this user to generate a new PGP key and send it to you."));
                break;
            }
        }
        if (complete && StringUtil.isEmpty((String)this.statusLabel.getText())) {
            block1: for (User invitee : invitees) {
                for (PgpKey pgpKey : invitee.getValidPgpKeys()) {
                    validity = this.getPgp().getKeyValidity(pgpKey);
                    if (validity.compareTo((Enum)PgpKeyValidity.MARGINAL) >= 0) continue;
                    severity = Severity.WARNING;
                    this.statusLabel.setText("Selected user's PGP key is NOT TRUSTED!");
                    this.statusLabel.setTooltip(new Tooltip("At least one of the PGP keys involved is NOT trusted. This means, you do not have \nany indication that the PGP key truly belongs to the user it claims to belong to."));
                    continue block1;
                }
            }
        }
        if (complete && StringUtil.isEmpty((String)this.statusLabel.getText())) {
            block3: for (User invitee : invitees) {
                for (PgpKey pgpKey : invitee.getValidPgpKeys()) {
                    validity = this.getPgp().getKeyValidity(pgpKey);
                    if (validity.compareTo((Enum)PgpKeyValidity.FULL) >= 0) continue;
                    severity = Severity.INFO;
                    this.statusLabel.setText("Selected user's PGP key is not fully trusted (only marginally)!");
                    this.statusLabel.setTooltip(new Tooltip("At least one of the PGP keys involved is only marginally trusted. This means, there is \na low risk that the PGP key does not truly belong to the user it claims to belong to."));
                    continue block3;
                }
            }
        }
        if (StringUtil.isEmpty((String)this.statusLabel.getText())) {
            this.statusLabel.setGraphic(null);
            this.contentVBox.getChildren().remove((Object)this.statusLabel);
        } else {
            this.statusLabel.setGraphic((Node)(severity == null ? null : new ImageView(SeverityImageRegistry.getInstance().getImage(severity, IconSize._24x24))));
            if (!this.contentVBox.getChildren().contains((Object)this.statusLabel)) {
                this.contentVBox.getChildren().add((Object)this.statusLabel);
            }
        }
        this.setComplete(complete);
    }

    private void determineNextPage() {
        WizardPage nextPage = this.issueInvitationDestWizardPage;
        block0: for (User invitee : this.issueInvitationData.getInvitees()) {
            Set validPgpKeys = invitee.getValidPgpKeys();
            HashSet<PgpKeyValidity> validities = new HashSet<PgpKeyValidity>(validPgpKeys.size());
            for (PgpKey pgpKey : validPgpKeys) {
                PgpKeyValidity validity = this.getPgp().getKeyValidity(pgpKey);
                if (validity.compareTo((Enum)PgpKeyValidity.FULL) < 0) {
                    nextPage = this.getSelectKeyWizardPage();
                    break block0;
                }
                validities.add(validity);
            }
            if (validities.size() <= 1) continue;
            nextPage = this.getSelectKeyWizardPage();
            break;
        }
    }

    protected SelectKeyWizardPage getSelectKeyWizardPage() {
        if (this.selectKeyWizardPage == null) {
            this.selectKeyWizardPage = new SelectKeyWizardPage(this.issueInvitationData);
        }
        return this.selectKeyWizardPage;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        if (this.selectUserPane != null) {
            this.selectUserPane.requestFocus();
        }
    }

    protected Pgp getPgp() {
        if (this.pgp == null) {
            this.pgp = PgpLs.getPgpOrFail();
        }
        return this.pgp;
    }
}

