/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.assignownertrust.selectkey;

import co.codewizards.cloudstore.core.util.AssertUtil;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.collections.SetChangeListener;
import javafx.fxml.FXML;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeItem;
import org.subshare.core.pgp.PgpOwnerTrust;
import org.subshare.gui.pgp.assignownertrust.AssignOwnerTrustData;
import org.subshare.gui.pgp.keytree.PgpKeyPgpKeyTreeItem;
import org.subshare.gui.pgp.keytree.PgpKeyTreeItem;
import org.subshare.gui.pgp.keytree.PgpKeyTreePane;
import org.subshare.gui.pgp.keytree.UserRootPgpKeyTreeItem;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.wizard.WizardPageContentGridPane;

public class SelectKeyPane
extends WizardPageContentGridPane {
    private AssignOwnerTrustData assignOwnerTrustData;
    @FXML
    private ToggleGroup toggleGroup;
    @FXML
    private RadioButton assignToAllPgpKeysRadioButton;
    @FXML
    private RadioButton assignToSelectedPgpKeysRadioButton;
    @FXML
    private TextField newOwnerTrustTextField;
    @FXML
    private PgpKeyTreePane pgpKeyTreePane;
    private final ChangeListener<Boolean> assignToAllPgpKeysChangeListener = (observable, oldValue, newValue) -> {
        if (newValue == null) {
            this.toggleGroup.selectToggle(null);
        } else if (newValue.booleanValue()) {
            this.toggleGroup.selectToggle((Toggle)this.assignToAllPgpKeysRadioButton);
        } else {
            this.toggleGroup.selectToggle((Toggle)this.assignToSelectedPgpKeysRadioButton);
        }
    };
    private final InvalidationListener toggleGroupSelectedToggleListener = observable -> {
        Toggle toggle = (Toggle)this.toggleGroup.selectedToggleProperty().get();
        if (toggle == this.assignToAllPgpKeysRadioButton) {
            this.assignOwnerTrustData.setAssignToAllPgpKeys(true);
        } else if (toggle == this.assignToSelectedPgpKeysRadioButton) {
            this.assignOwnerTrustData.setAssignToAllPgpKeys(false);
        } else {
            this.assignOwnerTrustData.setAssignToAllPgpKeys(null);
        }
        this.updateComplete();
    };
    private final InvalidationListener ownerTrustListener = observable -> {
        PgpOwnerTrust ownerTrust = (PgpOwnerTrust)this.assignOwnerTrustData.ownerTrustProperty().get();
        this.newOwnerTrustTextField.setText(ownerTrust == null ? null : ownerTrust.toString());
    };

    public SelectKeyPane(final AssignOwnerTrustData assignOwnerTrustData) {
        this.assignOwnerTrustData = (AssignOwnerTrustData)AssertUtil.assertNotNull((Object)assignOwnerTrustData, (String)"assignOwnerTrustData");
        FxmlUtil.loadDynamicComponentFxml(SelectKeyPane.class, this);
        assignOwnerTrustData.assignToAllPgpKeysProperty().addListener(this.assignToAllPgpKeysChangeListener);
        this.toggleGroup.selectedToggleProperty().addListener(this.toggleGroupSelectedToggleListener);
        assignOwnerTrustData.ownerTrustProperty().addListener(this.ownerTrustListener);
        this.pgpKeyTreePane.getCheckBoxVisibleForPgpKeyTreeItemClasses().add(PgpKeyPgpKeyTreeItem.class);
        UserRootPgpKeyTreeItem root = new UserRootPgpKeyTreeItem(this.pgpKeyTreePane, assignOwnerTrustData.getUser());
        this.pgpKeyTreePane.getTreeTableView().setRoot((TreeItem)root);
        for (TreeItem treeItem : root.getChildren()) {
            if (!(treeItem instanceof PgpKeyPgpKeyTreeItem)) continue;
            PgpKeyPgpKeyTreeItem ti = (PgpKeyPgpKeyTreeItem)treeItem;
            ti.setChecked(assignOwnerTrustData.getPgpKeys().contains(ti.getPgpKey()));
        }
        this.pgpKeyTreePane.getCheckedTreeItems().addListener(new SetChangeListener<PgpKeyTreeItem<?>>(){

            public void onChanged(SetChangeListener.Change<? extends PgpKeyTreeItem<?>> change) {
                PgpKeyTreeItem elementRemoved;
                PgpKeyTreeItem elementAdded = (PgpKeyTreeItem)((Object)change.getElementAdded());
                if (elementAdded instanceof PgpKeyPgpKeyTreeItem) {
                    assignOwnerTrustData.getPgpKeys().add(((PgpKeyPgpKeyTreeItem)elementAdded).getPgpKey());
                }
                if ((elementRemoved = (PgpKeyTreeItem)((Object)change.getElementRemoved())) instanceof PgpKeyPgpKeyTreeItem) {
                    assignOwnerTrustData.getPgpKeys().remove(((PgpKeyPgpKeyTreeItem)elementRemoved).getPgpKey());
                }
                SelectKeyPane.this.assignToSelectedPgpKeysRadioButton.setSelected(true);
                SelectKeyPane.this.updateComplete();
            }
        });
    }

    @Override
    protected boolean isComplete() {
        return this.assignOwnerTrustData.getAssignToAllPgpKeys() == Boolean.TRUE || !this.assignOwnerTrustData.getPgpKeys().isEmpty();
    }

    public void requestFocus() {
        super.requestFocus();
        this.pgpKeyTreePane.requestFocus();
    }
}

