/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.crypto.internal.asymmetric.keypairgenerator;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.DSAKeyPairGenerator;
import org.bouncycastle.crypto.generators.DSAParametersGenerator;
import org.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.DSAParameters;
import org.subshare.crypto.internal.asymmetric.keypairgenerator.AbstractAsymmetricCipherKeyPairGeneratorFactory;

public class DSAKeyPairGeneratorFactory
extends AbstractAsymmetricCipherKeyPairGeneratorFactory {
    public DSAKeyPairGeneratorFactory() {
        this.setAlgorithmName("DSA");
    }

    @Override
    public AsymmetricCipherKeyPairGenerator createAsymmetricCipherKeyPairGenerator(boolean initWithDefaults) {
        DSAKeyPairGenerator generator = new DSAKeyPairGenerator();
        if (initWithDefaults) {
            int certainty = 12;
            SecureRandom random = new SecureRandom();
            DSAParametersGenerator pGen = new DSAParametersGenerator();
            pGen.init(4096, 12, random);
            DSAParameters dsaParameters = pGen.generateParameters();
            DSAKeyGenerationParameters dsaKeyGenerationParameters = new DSAKeyGenerationParameters(random, dsaParameters);
            generator.init((KeyGenerationParameters)dsaKeyGenerationParameters);
        }
        return generator;
    }
}

