/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.file;

import co.codewizards.cloudstore.core.auth.SignatureException;
import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.io.ByteArrayOutputStream;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.io.NoCloseInputStream;
import co.codewizards.cloudstore.core.io.NoCloseOutputStream;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.bouncycastle.util.io.Streams;
import org.subshare.core.io.NullOutputStream;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpDecoder;
import org.subshare.core.pgp.PgpEncoder;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpRegistry;
import org.subshare.core.pgp.PgpSignature;

public abstract class DataFile {
    private Date manifestTimestamp;
    private Properties manifestProperties;
    private final Map<String, byte[]> name2ByteArray = new HashMap<String, byte[]>();

    public DataFile(byte[] in) throws IOException {
        this((InputStream)new ByteArrayInputStream((byte[])AssertUtil.assertNotNull((Object)in, (String)"in")));
    }

    public DataFile(InputStream in) throws IOException {
        AssertUtil.assertNotNull((Object)in, (String)"in");
        this.read(in);
    }

    public DataFile() {
        this.initManifestProperties();
    }

    public Date getManifestTimestamp() {
        return this.manifestTimestamp;
    }

    public Properties getManifestProperties() {
        return this.manifestProperties;
    }

    public void putData(String name, byte[] data) {
        AssertUtil.assertNotNull((Object)name, (String)"name");
        AssertUtil.assertNotNull((Object)data, (String)"data");
        this.name2ByteArray.put(name, data);
    }

    public Set<String> getDataNames() {
        return Collections.unmodifiableSet(this.name2ByteArray.keySet());
    }

    public byte[] getData(String name) {
        AssertUtil.assertNotNull((Object)name, (String)"name");
        return this.name2ByteArray.get(name);
    }

    protected void read(InputStream in) throws IOException {
        ZipInputStream zin = new ZipInputStream((InputStream)new NoCloseInputStream((InputStream)AssertUtil.assertNotNull((Object)in, (String)"in")));
        Map.Entry<Date, Properties> me = this.readManifest(zin);
        this.manifestTimestamp = me == null ? null : (Date)AssertUtil.assertNotNull((Object)me.getKey(), (String)"me.key");
        Properties properties = this.manifestProperties = me == null ? null : me.getValue();
        if (this.manifestProperties == null) {
            this.initManifestProperties();
            return;
        }
        this.readPayload(zin);
        zin.close();
    }

    private void initManifestProperties() {
        if (this.manifestTimestamp == null) {
            this.manifestTimestamp = new Date();
        }
        this.manifestProperties = new Properties();
        this.manifestProperties.setProperty("contentType", this.getContentTypeValue());
        this.manifestProperties.setProperty("contentTypeVersion", Integer.toString(1));
    }

    protected abstract String getContentTypeValue();

    protected Map.Entry<Date, Properties> readManifest(ZipInputStream zin) throws IOException {
        AssertUtil.assertNotNull((Object)zin, (String)"zin");
        ZipEntry ze = zin.getNextEntry();
        if (ze == null) {
            return null;
        }
        if (!"MANIFEST.properties".equals(ze.getName())) {
            throw new IllegalArgumentException(String.format("Input data is not valid: The very first zip-entry is not '%s' (it is '%s' instead)!", "MANIFEST.properties", ze.getName()));
        }
        Properties properties = new Properties();
        properties.load(zin);
        this.assertValidContentType(properties);
        return new AbstractMap.SimpleEntry<Date, Properties>(new Date(ze.getTime()), properties);
    }

    protected void assertValidContentType(Properties manifestProperties) {
        String contentType = manifestProperties.getProperty("contentType");
        if (!this.getContentTypeValue().equals(contentType)) {
            throw new IllegalArgumentException(String.format("Input data is not valid: The manifest indicates the content-type '%s', but '%s' is expected!", contentType, this.getContentTypeValue()));
        }
    }

    protected void readPayload(ZipInputStream zin) throws IOException {
        ZipEntry zipEntry;
        while (null != (zipEntry = zin.getNextEntry())) {
            String name = zipEntry.getName();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Streams.pipeAll((InputStream)zin, (OutputStream)out);
            this.name2ByteArray.put(name, out.toByteArray());
        }
    }

    public byte[] write() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.write((OutputStream)out);
        return out.toByteArray();
    }

    public void write(OutputStream out) throws IOException {
        AssertUtil.assertNotNull((Object)out, (String)"out");
        byte[] manifestData = this.createManifestData();
        byte[] detachedSignatureData = this.name2ByteArray.get("MANIFEST.properties.sig");
        if (detachedSignatureData != null && !this.isSignatureValid(manifestData, detachedSignatureData)) {
            this.name2ByteArray.remove("MANIFEST.properties.sig");
        }
        ZipOutputStream zout = new ZipOutputStream((OutputStream)new NoCloseOutputStream(out));
        zout.putNextEntry(this.createManifestZipEntry(manifestData));
        zout.write(manifestData);
        zout.closeEntry();
        for (Map.Entry<String, byte[]> me : this.name2ByteArray.entrySet()) {
            String name = me.getKey();
            zout.putNextEntry(new ZipEntry(name));
            zout.write(me.getValue());
            zout.closeEntry();
        }
        zout.close();
    }

    public void signManifestData(PgpKey signPgpKey) throws IOException {
        byte[] manifestData = this.createManifestData();
        this.signManifestData(signPgpKey, manifestData);
    }

    protected void signManifestData(PgpKey signPgpKey, byte[] manifestData) throws IOException {
        AssertUtil.assertNotNull((Object)signPgpKey, (String)"signPgpKey");
        AssertUtil.assertNotNull((Object)manifestData, (String)"manifestData");
        Pgp pgp = PgpRegistry.getInstance().getPgpOrFail();
        PgpEncoder encoder = pgp.createEncoder((IInputStream)new ByteArrayInputStream(manifestData), new NullOutputStream());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        encoder.setSignOutputStream((IOutputStream)out);
        encoder.setSignPgpKey(signPgpKey);
        encoder.encode();
        byte[] detachedSignatureData = out.toByteArray();
        this.name2ByteArray.put("MANIFEST.properties.sig", detachedSignatureData);
    }

    private boolean isSignatureValid(byte[] signedData, byte[] detachedSignatureData) {
        AssertUtil.assertNotNull((Object)signedData, (String)"signedData");
        AssertUtil.assertNotNull((Object)detachedSignatureData, (String)"detachedSignatureData");
        try {
            this.assertSignatureValid(signedData, detachedSignatureData);
            return true;
        }
        catch (SignatureException | IOException x) {
            return false;
        }
    }

    private PgpSignature assertSignatureValid(byte[] signedData, byte[] detachedSignatureData) throws SignatureException, IOException {
        AssertUtil.assertNotNull((Object)signedData, (String)"signedData");
        AssertUtil.assertNotNull((Object)detachedSignatureData, (String)"detachedSignatureData");
        Pgp pgp = PgpRegistry.getInstance().getPgpOrFail();
        PgpDecoder decoder = pgp.createDecoder((IInputStream)new ByteArrayInputStream(signedData), new NullOutputStream());
        decoder.setSignInputStream((IInputStream)new ByteArrayInputStream(detachedSignatureData));
        decoder.decode();
        return decoder.getPgpSignature();
    }

    private ZipEntry createManifestZipEntry(byte[] manifestData) {
        ZipEntry ze = new ZipEntry("MANIFEST.properties");
        ze.setMethod(0);
        ze.setSize(manifestData.length);
        ze.setCompressedSize(manifestData.length);
        CRC32 crc32 = new CRC32();
        crc32.update(manifestData);
        ze.setCrc(crc32.getValue());
        return ze;
    }

    private byte[] createManifestData() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
        SortedMap<String, String> sortedManifestProperties = this.createSortedManifestProperties();
        String contentType = (String)sortedManifestProperties.remove("contentType");
        AssertUtil.assertNotNull((Object)contentType, (String)"contentType");
        this.writeManifestEntry(w, "contentType", contentType);
        String version = (String)sortedManifestProperties.remove("contentTypeVersion");
        AssertUtil.assertNotNull((Object)version, (String)"contentTypeVersion");
        try {
            Integer.parseInt(version);
        }
        catch (NumberFormatException x) {
            throw new IllegalStateException("contentTypeVersion is not a valid integer: " + version);
        }
        this.writeManifestEntry(w, "contentTypeVersion", version);
        for (Map.Entry<String, String> me : sortedManifestProperties.entrySet()) {
            this.writeManifestEntry(w, me.getKey(), me.getValue());
        }
        ((Writer)w).close();
        return out.toByteArray();
    }

    public boolean isManifestSigned() {
        return this.name2ByteArray.get("MANIFEST.properties.sig") != null;
    }

    public PgpSignature assertManifestSignatureValid() throws SignatureException {
        byte[] manifestData;
        byte[] manifestSignatureData = this.name2ByteArray.get("MANIFEST.properties.sig");
        if (manifestSignatureData == null) {
            throw new SignatureException(String.format("There is no signature! No entry named '%s' found!", "MANIFEST.properties.sig"));
        }
        try {
            manifestData = this.createManifestData();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            return this.assertSignatureValid(manifestData, manifestSignatureData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private SortedMap<String, String> createSortedManifestProperties() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> me : this.manifestProperties.entrySet()) {
            result.put(me.getKey().toString(), me.getValue().toString());
        }
        return result;
    }

    private void writeManifestEntry(Writer w, String key, String value) throws IOException {
        AssertUtil.assertNotNull((Object)w, (String)"w");
        AssertUtil.assertNotNull((Object)key, (String)"key");
        AssertUtil.assertNotNull((Object)value, (String)"value");
        w.write(key);
        w.write(61);
        w.write(value);
        w.write(10);
    }
}

