/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.dto;

import co.codewizards.cloudstore.core.dto.DirectoryDto;
import co.codewizards.cloudstore.core.dto.NormalFileDto;
import co.codewizards.cloudstore.core.dto.RepoFileDto;
import co.codewizards.cloudstore.core.dto.SymlinkDto;
import co.codewizards.cloudstore.core.dto.TempChunkFileDto;
import co.codewizards.cloudstore.core.dto.jaxb.TempChunkFileDtoIo;
import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.dto.FileChunkDtoConverter;
import co.codewizards.cloudstore.local.persistence.Directory;
import co.codewizards.cloudstore.local.persistence.FileChunk;
import co.codewizards.cloudstore.local.persistence.NormalFile;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import co.codewizards.cloudstore.local.persistence.RepoFileDao;
import co.codewizards.cloudstore.local.persistence.Symlink;
import co.codewizards.cloudstore.local.transport.TempChunkFileManager;
import co.codewizards.cloudstore.local.transport.TempChunkFileWithDtoFile;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepoFileDtoConverter {
    private static final Logger logger = LoggerFactory.getLogger(RepoFileDtoConverter.class);
    private final TempChunkFileManager tempChunkFileManager = TempChunkFileManager.getInstance();
    private final FileChunkDtoConverter fileChunkDtoConverter = FileChunkDtoConverter.create();
    private final LocalRepoManager localRepoManager;
    private final LocalRepoTransaction transaction;
    private final RepoFileDao repoFileDao;
    private boolean excludeLocalIds;
    private boolean excludeMutableData;

    public static RepoFileDtoConverter create(LocalRepoTransaction transaction) {
        return (RepoFileDtoConverter)ObjectFactoryUtil.createObject(RepoFileDtoConverter.class, (Object[])new Object[]{transaction});
    }

    protected RepoFileDtoConverter(LocalRepoTransaction transaction) {
        this.transaction = (LocalRepoTransaction)AssertUtil.assertNotNull((Object)transaction, (String)"transaction");
        this.localRepoManager = (LocalRepoManager)AssertUtil.assertNotNull((Object)transaction.getLocalRepoManager(), (String)"transaction.localRepoManager");
        this.repoFileDao = (RepoFileDao)this.transaction.getDao(RepoFileDao.class);
    }

    public RepoFileDto toRepoFileDto(RepoFile repoFile, int depth) {
        RepoFileDto repoFileDto;
        AssertUtil.assertNotNull((Object)this.repoFileDao, (String)"repoFileDao");
        AssertUtil.assertNotNull((Object)repoFile, (String)"repoFile");
        if (repoFile instanceof NormalFile) {
            NormalFile normalFile = (NormalFile)repoFile;
            NormalFileDto normalFileDto = (NormalFileDto)ObjectFactoryUtil.createObject(NormalFileDto.class);
            repoFileDto = normalFileDto;
            if (this.isExcludeMutableData()) {
                normalFileDto.setLength(-1L);
            } else {
                normalFileDto.setLength(normalFile.getLength());
                normalFileDto.setSha1(normalFile.getSha1());
            }
            if (depth > 0) {
                ArrayList<FileChunk> fileChunks = new ArrayList<FileChunk>(normalFile.getFileChunks());
                Collections.sort(fileChunks);
                for (FileChunk fileChunk : fileChunks) {
                    normalFileDto.getFileChunkDtos().add(this.fileChunkDtoConverter.toFileChunkDto(fileChunk));
                }
            }
            if (depth > 1) {
                TempChunkFileDtoIo tempChunkFileDtoIo = new TempChunkFileDtoIo();
                File file = repoFile.getFile(this.localRepoManager.getLocalRoot());
                for (TempChunkFileWithDtoFile tempChunkFileWithDtoFile : this.tempChunkFileManager.getOffset2TempChunkFileWithDtoFile(file).values()) {
                    TempChunkFileDto tempChunkFileDto;
                    File tempChunkFileDtoFile = tempChunkFileWithDtoFile.getTempChunkFileDtoFile();
                    if (tempChunkFileDtoFile == null) continue;
                    try {
                        tempChunkFileDto = (TempChunkFileDto)tempChunkFileDtoIo.deserialize(tempChunkFileDtoFile);
                    }
                    catch (Exception x) {
                        logger.warn("toRepoFileDto: Ignoring corrupt tempChunkFileDtoFile '" + tempChunkFileDtoFile.getAbsolutePath() + "': " + x, (Throwable)x);
                        continue;
                    }
                    normalFileDto.getTempFileChunkDtos().add(AssertUtil.assertNotNull((Object)tempChunkFileDto.getFileChunkDto(), (String)"tempChunkFileDto.fileChunkDto"));
                }
            }
        } else if (repoFile instanceof Directory) {
            repoFileDto = (RepoFileDto)ObjectFactoryUtil.createObject(DirectoryDto.class);
        } else if (repoFile instanceof Symlink) {
            Symlink symlink = (Symlink)repoFile;
            SymlinkDto symlinkDto = (SymlinkDto)ObjectFactoryUtil.createObject(SymlinkDto.class);
            repoFileDto = symlinkDto;
            if (!this.isExcludeMutableData()) {
                symlinkDto.setTarget(symlink.getTarget());
            }
        } else {
            throw new UnsupportedOperationException("RepoFile type not yet supported: " + repoFile);
        }
        if (!this.isExcludeLocalIds()) {
            repoFileDto.setId(repoFile.getId());
            repoFileDto.setParentId(repoFile.getParent() == null ? null : Long.valueOf(repoFile.getParent().getId()));
            repoFileDto.setLocalRevision(repoFile.getLocalRevision());
        }
        repoFileDto.setName(repoFile.getName());
        repoFileDto.setLastModified(repoFile.getLastModified());
        return repoFileDto;
    }

    public boolean isExcludeLocalIds() {
        return this.excludeLocalIds;
    }

    public void setExcludeLocalIds(boolean excludeLocalIds) {
        this.excludeLocalIds = excludeLocalIds;
    }

    public boolean isExcludeMutableData() {
        return this.excludeMutableData;
    }

    public void setExcludeMutableData(boolean excludeMutableData) {
        this.excludeMutableData = excludeMutableData;
    }
}

