/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.wrappers;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.store.types.SCOCollection;
import org.datanucleus.store.types.SCOCollectionIterator;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class TreeSet
extends java.util.TreeSet
implements SCOCollection<java.util.TreeSet> {
    private static final long serialVersionUID = 2716348073191575719L;
    protected transient ObjectProvider ownerOP;
    protected transient AbstractMemberMetaData ownerMmd;
    protected java.util.TreeSet delegate;

    public TreeSet(ObjectProvider ownerOP, AbstractMemberMetaData mmd) {
        this.ownerOP = ownerOP;
        this.ownerMmd = mmd;
    }

    @Override
    public void initialise(java.util.TreeSet c, boolean forInsert, boolean forUpdate) {
        if (c != null) {
            this.initialiseDelegate();
            this.delegate.addAll(c);
        } else {
            this.initialiseDelegate();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("023003", this.ownerOP.getObjectAsPrintable(), this.ownerMmd.getName(), "" + this.size(), SCOUtils.getSCOWrapperOptionsMessage(true, false, true, false)));
        }
    }

    @Override
    public void initialise() {
        this.initialiseDelegate();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("023003", this.ownerOP.getObjectAsPrintable(), this.ownerMmd.getName(), "" + this.size(), SCOUtils.getSCOWrapperOptionsMessage(true, false, true, false)));
        }
    }

    protected void initialiseDelegate() {
        Comparator comparator = SCOUtils.getComparator(this.ownerMmd, this.ownerOP.getExecutionContext().getClassLoaderResolver());
        this.delegate = comparator != null ? new java.util.TreeSet(comparator) : new java.util.TreeSet();
    }

    @Override
    public java.util.TreeSet getValue() {
        return this.delegate;
    }

    @Override
    public void load() {
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
        this.makeDirty();
    }

    @Override
    public String getFieldName() {
        return this.ownerMmd.getName();
    }

    @Override
    public Object getOwner() {
        return this.ownerOP != null ? this.ownerOP.getObject() : null;
    }

    @Override
    public synchronized void unsetOwner() {
        if (this.ownerOP != null) {
            this.ownerOP = null;
            this.ownerMmd = null;
        }
    }

    public void makeDirty() {
        if (this.ownerOP != null) {
            this.ownerOP.makeDirty(this.ownerMmd.getAbsoluteFieldNumber());
        }
    }

    @Override
    public java.util.TreeSet detachCopy(FetchPlanState state) {
        Comparator comparator = SCOUtils.getComparator(this.ownerMmd, this.ownerOP.getExecutionContext().getClassLoaderResolver());
        java.util.TreeSet detached = null;
        detached = comparator != null ? new java.util.TreeSet(comparator) : new java.util.TreeSet();
        SCOUtils.detachCopyForCollection(this.ownerOP, this.toArray(), state, detached);
        return detached;
    }

    @Override
    public void attachCopy(java.util.TreeSet value) {
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(this.ownerMmd);
        SCOUtils.attachCopyElements(this.ownerOP, this, value, elementsWithoutIdentity);
    }

    @Override
    public Object clone() {
        return this.delegate.clone();
    }

    @Override
    public Comparator comparator() {
        return this.delegate.comparator();
    }

    @Override
    public boolean contains(Object element) {
        return this.delegate.contains(element);
    }

    @Override
    public synchronized boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public synchronized boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public Object first() {
        return this.delegate.first();
    }

    @Override
    public synchronized int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return new SCOCollectionIterator(this, this.ownerOP, this.delegate, null, true);
    }

    @Override
    public SortedSet headSet(Object toElement) {
        return this.delegate.headSet(toElement);
    }

    @Override
    public SortedSet subSet(Object fromElement, Object toElement) {
        return this.delegate.subSet(fromElement, toElement);
    }

    @Override
    public SortedSet tailSet(Object fromElement) {
        return this.delegate.headSet(fromElement);
    }

    @Override
    public Object last() {
        return this.delegate.last();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(Object element) {
        boolean success = this.delegate.add(element);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP).relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public boolean addAll(Collection elements) {
        boolean success = this.delegate.addAll(elements);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP).relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), iter.next());
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public void clear() {
        Iterator iter;
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            iter = this.delegate.iterator();
            RelationshipManager relMgr = this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP);
            while (iter.hasNext()) {
                relMgr.relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), iter.next());
            }
        }
        if (this.ownerOP != null && !this.delegate.isEmpty() && SCOUtils.hasDependentElement(this.ownerMmd)) {
            iter = this.delegate.iterator();
            while (iter.hasNext()) {
                this.ownerOP.getExecutionContext().deleteObjectInternal(iter.next());
            }
        }
        this.delegate.clear();
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public synchronized boolean remove(Object element) {
        return this.remove(element, true);
    }

    @Override
    public synchronized boolean remove(Object element, boolean allowCascadeDelete) {
        boolean success = this.delegate.remove(element);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP).relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        if (this.ownerOP != null && allowCascadeDelete && SCOUtils.hasDependentElement(this.ownerMmd)) {
            this.ownerOP.getExecutionContext().deleteObjectInternal(element);
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public boolean removeAll(Collection elements) {
        Iterator iter;
        boolean success = this.delegate.removeAll(elements);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            iter = elements.iterator();
            RelationshipManager relMgr = this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP);
            while (iter.hasNext()) {
                relMgr.relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), iter.next());
            }
        }
        if (this.ownerOP != null && elements != null && !elements.isEmpty() && SCOUtils.hasDependentElement(this.ownerMmd)) {
            iter = elements.iterator();
            while (iter.hasNext()) {
                this.ownerOP.getExecutionContext().deleteObjectInternal(iter.next());
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public synchronized boolean retainAll(Collection c) {
        boolean success = this.delegate.retainAll(c);
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new java.util.TreeSet(this.delegate);
    }
}

