/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp.gnupg;

import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.IOUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GnuPgDir {
    private static final Logger logger = LoggerFactory.getLogger(GnuPgDir.class);
    public static final String CONFIG_KEY_GNU_PG_DIR = "gnupg.dir";
    public static final String DEFAULT_GNU_PG_DIR = "${user.home}/.gnupg";

    public static GnuPgDir getInstance() {
        return Holder.instance;
    }

    protected GnuPgDir() {
    }

    public File getFile() {
        String dirString = ConfigImpl.getInstance().getPropertyAsNonEmptyTrimmedString(CONFIG_KEY_GNU_PG_DIR, DEFAULT_GNU_PG_DIR);
        logger.debug("getFile: dirString={}", (Object)dirString);
        String resolvedDir = IOUtil.replaceTemplateVariables((String)dirString, (Map)System.getProperties());
        File result = OioFileFactory.createFile((String)resolvedDir).getAbsoluteFile();
        logger.debug("getFile: result={}", (Object)result);
        return result;
    }

    private static final class Holder {
        public static final GnuPgDir instance = new GnuPgDir();

        private Holder() {
        }
    }
}

