/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core;

import co.codewizards.cloudstore.core.dto.jaxb.UidXmlAdapter;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Base64Url;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.security.SecureRandom;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlJavaTypeAdapter(type=Uid.class, value=UidXmlAdapter.class)
public class Uid
implements Comparable<Uid>,
Serializable {
    public static final int LENGTH_BYTES = 16;
    public static final int LENGTH_STRING = 22;
    private static final long serialVersionUID = 1L;
    private final long hi;
    private final long lo;
    private transient WeakReference<String> toString;

    public Uid() {
        this(RandomHolder.next16Bytes());
    }

    public Uid(long hi, long lo) {
        this.hi = hi;
        this.lo = lo;
    }

    public Uid(byte[] bytes) {
        int i;
        if (AssertUtil.assertNotNull(bytes, "bytes").length != 16) {
            throw new IllegalArgumentException("bytes.length != 16");
        }
        long hi = 0L;
        long lo = 0L;
        for (i = 0; i < Math.min(8, bytes.length); ++i) {
            hi = hi << 8 | (long)(bytes[i] & 0xFF);
        }
        for (i = 8; i < Math.min(16, bytes.length); ++i) {
            lo = lo << 8 | (long)(bytes[i] & 0xFF);
        }
        this.hi = hi;
        this.lo = lo;
    }

    private static final String assertValidUidString(String uidString) {
        if (AssertUtil.assertNotNull(uidString, "uidString").length() != 22) {
            throw new IllegalArgumentException("uidString.length != 22 :: '" + uidString + "'");
        }
        return uidString;
    }

    public Uid(String uidString) {
        this(Uid.uidStringToByteArray(uidString));
    }

    private static byte[] uidStringToByteArray(String uidString) {
        return Base64Url.decodeBase64FromString(Uid.assertValidUidString(uidString));
    }

    public byte[] toBytes() {
        int i;
        byte[] bytes = new byte[16];
        int idx = -1;
        for (i = 7; i >= 0; --i) {
            bytes[++idx] = (byte)(this.hi >> 8 * i);
        }
        for (i = 7; i >= 0; --i) {
            bytes[++idx] = (byte)(this.lo >> 8 * i);
        }
        return bytes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.hi ^ this.hi >>> 32);
        result = 31 * result + (int)(this.lo ^ this.lo >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Uid other = (Uid)obj;
        if (this.hi != other.hi) {
            return false;
        }
        return this.lo == other.lo;
    }

    public String toString() {
        String s;
        String string = s = this.toString == null ? null : (String)this.toString.get();
        if (s != null) {
            return s;
        }
        s = Base64Url.encodeBase64ToString(this.toBytes());
        if (s.length() != 22) {
            throw new IllegalStateException("uidString.length != 22");
        }
        this.toString = new WeakReference<String>(s);
        return s;
    }

    @Override
    public int compareTo(Uid other) {
        AssertUtil.assertNotNull(other, "other");
        return this.hi < other.hi ? -1 : (this.hi > other.hi ? 1 : (this.lo < other.lo ? -1 : (this.lo > other.lo ? 1 : 0)));
    }

    private static class RandomHolder {
        static final SecureRandom random = new SecureRandom();

        private RandomHolder() {
        }

        static final byte[] next16Bytes() {
            byte[] bytes = new byte[16];
            random.nextBytes(bytes);
            return bytes;
        }
    }
}

