/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.repo.local;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerException;

public class FileAlreadyRepositoryException
extends LocalRepoManagerException {
    private static final long serialVersionUID = 1L;
    private final File file;

    public FileAlreadyRepositoryException(File file) {
        super(FileAlreadyRepositoryException.createMessage(file));
        this.file = file;
    }

    public FileAlreadyRepositoryException(File file, Throwable cause) {
        super(FileAlreadyRepositoryException.createMessage(file), cause);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    private static String createMessage(File file) {
        return String.format("File is already (in) a repository (cannot be converted into one): %s", file == null ? null : file.getAbsolutePath());
    }
}

