/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.repo.local;

import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistry;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistryImpl;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;

public final class LocalRepoHelper {
    private LocalRepoHelper() {
    }

    public static co.codewizards.cloudstore.core.oio.File getLocalRootContainingFile(co.codewizards.cloudstore.core.oio.File file) {
        for (co.codewizards.cloudstore.core.oio.File parentFile = AssertUtil.assertNotNull(file, "file"); parentFile != null; parentFile = parentFile.getParentFile()) {
            co.codewizards.cloudstore.core.oio.File parentMetaDir = OioFileFactory.createFile(parentFile, LocalRepoManager.META_DIR_NAME);
            if (!parentMetaDir.exists()) continue;
            return parentFile;
        }
        return null;
    }

    public static Collection<co.codewizards.cloudstore.core.oio.File> getLocalRootsContainedInDirectory(co.codewizards.cloudstore.core.oio.File directory) {
        AssertUtil.assertNotNull(directory, "directory");
        directory = directory.getAbsoluteFile();
        if (!directory.isDirectory()) {
            return Collections.emptyList();
        }
        String containerPath = directory.getPath() + File.separator;
        ArrayList<co.codewizards.cloudstore.core.oio.File> result = new ArrayList<co.codewizards.cloudstore.core.oio.File>();
        LocalRepoRegistry localRepoRegistry = LocalRepoRegistryImpl.getInstance();
        for (UUID repositoryId : localRepoRegistry.getRepositoryIds()) {
            co.codewizards.cloudstore.core.oio.File localRoot = localRepoRegistry.getLocalRoot(repositoryId);
            if (localRoot == null) continue;
            if (directory.equals(localRoot)) {
                result.add(localRoot);
                continue;
            }
            String localRootPath = localRoot.getAbsolutePath();
            if (!localRootPath.startsWith(containerPath)) continue;
            result.add(localRoot);
        }
        return Collections.unmodifiableList(result);
    }
}

