/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.util;

import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.progress.SubProgressMonitor;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.core.util.UrlUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipUtil {
    private static final Logger logger = LoggerFactory.getLogger(ZipUtil.class);
    private static final String PROPERTY_KEY_ZIP_TIMESTAMP = "zip.timestamp";
    private static final String PROPERTY_KEY_ZIP_FILESIZE = "zip.size";

    private ZipUtil() {
    }

    public static void zipFolder(File zipOutputFile, File zipInputFolder) throws IOException {
        ZipUtil.zipFolder(zipOutputFile, zipInputFolder, null);
    }

    public static void zipFolder(File zipOutputFile, File zipInputFolder, ProgressMonitor monitor) throws IOException {
        ZipUtil.zipFilesRecursively(zipOutputFile, zipInputFolder.listFiles(), zipInputFolder.getAbsoluteFile(), monitor);
    }

    public static void zipFilesRecursively(File zipOutputFile, File[] files, File entryRoot) throws IOException {
        ZipUtil.zipFilesRecursively(zipOutputFile, files, entryRoot, (ProgressMonitor)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFilesRecursively(File zipOutputFile, File[] files, File entryRoot, ProgressMonitor monitor) throws IOException {
        OutputStream fout = StreamUtil.castStream(zipOutputFile.createOutputStream());
        try (ZipOutputStream out = new ZipOutputStream(fout);){
            ZipUtil.zipFilesRecursively(out, zipOutputFile, files, entryRoot, monitor);
        }
    }

    public static void zipFilesRecursively(ZipOutputStream out, File zipOutputFile, File[] files, File entryRoot) throws IOException {
        ZipUtil.zipFilesRecursively(out, zipOutputFile, files, entryRoot, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFilesRecursively(ZipOutputStream out, File zipOutputFile, File[] files, File entryRoot, ProgressMonitor monitor) throws IOException {
        if (entryRoot == null && files == null) {
            throw new IllegalArgumentException("entryRoot and files must not both be null!");
        }
        if (entryRoot != null && !entryRoot.isDirectory()) {
            throw new IllegalArgumentException("entryRoot is not a directory: " + entryRoot.getAbsolutePath());
        }
        if (files == null) {
            files = new File[]{entryRoot};
        }
        if (monitor != null) {
            int dirCount = 0;
            int fileCount = 0;
            File[] fileArray = files;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file = fileArray[i];
                if (file.isDirectory()) {
                    ++dirCount;
                    continue;
                }
                ++fileCount;
            }
            monitor.beginTask("Zipping files", dirCount * 10 + fileCount);
        }
        try {
            byte[] buf = new byte[5120];
            for (File file : files) {
                int len;
                if (zipOutputFile != null && file.equals(zipOutputFile)) {
                    if (monitor == null) continue;
                    monitor.worked(1);
                    continue;
                }
                String relativePath = entryRoot == null ? file.getName() : IOUtil.getRelativePath(entryRoot, file.getAbsoluteFile());
                relativePath = relativePath.replace('\\', '/');
                if (file.isDirectory()) {
                    relativePath = relativePath + '/';
                    ZipEntry entry = new ZipEntry(relativePath);
                    entry.setTime(file.lastModified());
                    entry.setSize(0L);
                    entry.setCompressedSize(0L);
                    entry.setCrc(0L);
                    entry.setMethod(0);
                    out.putNextEntry(entry);
                    out.closeEntry();
                    File[] dirFiles = file.listFiles();
                    if (dirFiles == null) {
                        logger.error("zipFilesRecursively: file.listFiles() returned null, even though file is a directory! file=\"{}\"", (Object)file.getAbsolutePath());
                        if (monitor == null) continue;
                        monitor.worked(10);
                        continue;
                    }
                    ZipUtil.zipFilesRecursively(out, zipOutputFile, dirFiles, entryRoot, monitor == null ? null : new SubProgressMonitor(monitor, 10));
                    continue;
                }
                BufferedInputStream in = new BufferedInputStream(StreamUtil.castStream(file.createInputStream()));
                ZipEntry entry = new ZipEntry(relativePath);
                entry.setTime(file.lastModified());
                out.putNextEntry(entry);
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
                if (monitor == null) continue;
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static synchronized void unzipArchiveIfModified(File zipArchive, File unzipRootFolder) throws IOException {
        ZipUtil.unzipArchive(zipArchive.toURI().toURL(), unzipRootFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void unzipArchiveIfModified(URL zipArchive, File unzipRootFolder) throws IOException {
        File metaFile = OioFileFactory.createFile(unzipRootFolder, ".archive.properties");
        long timestamp = Long.MIN_VALUE;
        long fileSize = Long.MIN_VALUE;
        Properties properties = new Properties();
        if (metaFile.exists()) {
            String fileSizeS;
            try (InputStream in = StreamUtil.castStream(metaFile.createInputStream());){
                properties.load(in);
            }
            String timestampS = properties.getProperty(PROPERTY_KEY_ZIP_TIMESTAMP);
            if (timestampS != null) {
                try {
                    timestamp = Long.parseLong(timestampS, 36);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((fileSizeS = properties.getProperty(PROPERTY_KEY_ZIP_FILESIZE)) != null) {
                try {
                    fileSize = Long.parseLong(fileSizeS, 36);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        boolean doUnzip = true;
        long zipLength = -1L;
        long zipLastModified = System.currentTimeMillis();
        if ("file".equals(zipArchive.getProtocol())) {
            File fileToCheck = OioFileFactory.createFile(UrlUtil.urlToUri(zipArchive));
            zipLastModified = fileToCheck.lastModified();
            zipLength = fileToCheck.length();
            boolean bl = doUnzip = !unzipRootFolder.exists() || zipLastModified != timestamp || zipLength != fileSize;
        }
        if (doUnzip) {
            IOUtil.deleteDirectoryRecursively(unzipRootFolder);
            ZipUtil.unzipArchive(zipArchive, unzipRootFolder);
            properties.setProperty(PROPERTY_KEY_ZIP_FILESIZE, Long.toString(zipLength, 36));
            properties.setProperty(PROPERTY_KEY_ZIP_TIMESTAMP, Long.toString(zipLastModified, 36));
            try (OutputStream out = StreamUtil.castStream(metaFile.createOutputStream());){
                properties.store(out, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipArchive(URL zipArchive, File unzipRootFolder) throws IOException {
        try (ZipInputStream in = new ZipInputStream(zipArchive.openStream());){
            ZipEntry entry = null;
            while ((entry = in.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    File dir = OioFileFactory.createFile(unzipRootFolder, entry.getName());
                    if (dir.exists() || dir.mkdirs()) continue;
                    throw new IllegalStateException("Could not create directory entry, possibly permission issues.");
                }
                File file = OioFileFactory.createFile(unzipRootFolder, entry.getName());
                File dir = file.getParentFile();
                if (dir.exists()) {
                    assert (dir.isDirectory());
                } else {
                    dir.mkdirs();
                }
                BufferedOutputStream out = new BufferedOutputStream(StreamUtil.castStream(file.createOutputStream()));
                Throwable throwable = null;
                try {
                    int len;
                    byte[] buf = new byte[5120];
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
        }
    }

    public static void unzipArchive(File zipArchive, File unzipRootFolder) throws IOException {
        ZipUtil.unzipArchive(zipArchive.toURI().toURL(), unzipRootFolder);
    }
}

