/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class StringUtil {
    private StringUtil() {
    }

    public static final List<Integer> getIndexesOf(String string, char c) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int index = 0; index < string.length(); ++index) {
            if (string.charAt(index) != c) continue;
            indexes.add(index);
        }
        indexes.trimToSize();
        return Collections.unmodifiableList(indexes);
    }

    public static final boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static final String nullToEmpty(String string) {
        return string == null ? "" : string;
    }

    public static final String emptyToNull(String string) {
        return StringUtil.isEmpty(string) ? null : string;
    }

    public static final String trim(String string) {
        return string == null ? null : string.trim();
    }

    public static final String trimLeft(String string) {
        int st;
        int len = string.length();
        for (st = 0; st < len && string.charAt(st) <= ' '; ++st) {
        }
        return st > 0 ? string.substring(st) : string;
    }

    public static final String trimRight(String string) {
        int length;
        int len;
        for (len = length = string.length(); 0 < len && string.charAt(len - 1) <= ' '; --len) {
        }
        return len < length ? string.substring(0, len) : string;
    }
}

