/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.observable.standard;

import java.util.Collection;
import org.subshare.core.observable.ModificationEventType;
import org.subshare.core.observable.ModificationHandler;
import org.subshare.core.observable.ModificationHandlerFactory;
import org.subshare.core.observable.ObservableCollection;
import org.subshare.core.observable.standard.StandardPostModificationEvent;
import org.subshare.core.observable.standard.StandardPostModificationListener;
import org.subshare.core.observable.standard.StandardPreModificationEvent;
import org.subshare.core.observable.standard.StandardPreModificationListener;

public class StandardModificationHandler<E>
extends ModificationHandler<E> {
    public static final ModificationHandlerFactory FACTORY = new Factory();
    protected static final PreHolder[] EMPTY_PRE_HOLDERS = new PreHolder[0];
    protected static final PostHolder[] EMPTY_POST_HOLDERS = new PostHolder[0];
    protected int preMask = 0;
    protected int postMask = 0;
    protected PreHolder[] preHolder = EMPTY_PRE_HOLDERS;
    protected PostHolder[] postHolder = EMPTY_POST_HOLDERS;
    protected int preSize;

    public StandardModificationHandler() {
    }

    public StandardModificationHandler(StandardPreModificationListener pre, int preMask, StandardPostModificationListener post, int postMask) {
        if (pre != null) {
            this.preHolder = new PreHolder[1];
            this.preHolder[0] = new PreHolder(pre, preMask);
            this.preMask = preMask;
        }
        if (post != null) {
            this.postHolder = new PostHolder[1];
            this.postHolder[0] = new PostHolder(post, postMask);
            this.postMask = postMask;
        }
    }

    @Override
    public synchronized Object[] getPreModificationListeners() {
        Object[] lnrs = new Object[this.preHolder.length];
        for (int i = 0; i < this.preHolder.length; ++i) {
            lnrs[i] = this.preHolder[i].listener;
        }
        return lnrs;
    }

    @Override
    public void addPreModificationListener(Object listener) {
        this.addPreModificationListener((StandardPreModificationListener)listener, -1);
    }

    public synchronized void addPreModificationListener(StandardPreModificationListener listener, int mask) {
        if (listener != null) {
            int oldSize = this.preHolder.length;
            PreHolder[] array = new PreHolder[oldSize + 1];
            System.arraycopy(this.preHolder, 0, array, 0, oldSize);
            array[oldSize] = new PreHolder(listener, mask);
            this.preHolder = array;
            this.calculatePreMask();
        }
    }

    @Override
    public synchronized void removePreModificationListener(Object listener) {
        if (listener != null) {
            switch (this.preHolder.length) {
                case 0: {
                    return;
                }
                case 1: {
                    if (this.preHolder[0].listener == listener) {
                        this.preHolder = EMPTY_PRE_HOLDERS;
                        this.calculatePreMask();
                    }
                    return;
                }
            }
            PreHolder[] array = new PreHolder[this.preHolder.length - 1];
            boolean match = false;
            for (int i = 0; i < this.preHolder.length; ++i) {
                if (match) {
                    array[i - 1] = this.preHolder[i];
                    continue;
                }
                if (this.preHolder[i].listener == listener) {
                    match = true;
                    continue;
                }
                array[i] = this.preHolder[i];
            }
            this.preHolder = array;
            this.calculatePreMask();
            return;
        }
    }

    public synchronized void setPreModificationListenerMask(StandardPreModificationListener listener, int mask) {
        if (listener != null) {
            for (int i = 0; i < this.preHolder.length; ++i) {
                if (this.preHolder[i].listener != listener) continue;
                this.preHolder[i].mask = mask;
                this.calculatePreMask();
                break;
            }
        }
    }

    protected void calculatePreMask() {
        this.preMask = 0;
        for (int i = 0; i < this.preHolder.length; ++i) {
            this.preMask |= this.preHolder[i].mask;
        }
    }

    @Override
    public synchronized Object[] getPostModificationListeners() {
        Object[] lnrs = new Object[this.postHolder.length];
        for (int i = 0; i < this.postHolder.length; ++i) {
            lnrs[i] = this.postHolder[i].listener;
        }
        return lnrs;
    }

    @Override
    public void addPostModificationListener(Object listener) {
        this.addPostModificationListener((StandardPostModificationListener)listener, -1);
    }

    public synchronized void addPostModificationListener(StandardPostModificationListener listener, int mask) {
        if (listener != null) {
            int oldSize = this.postHolder.length;
            PostHolder[] array = new PostHolder[oldSize + 1];
            System.arraycopy(this.postHolder, 0, array, 0, oldSize);
            array[oldSize] = new PostHolder(listener, mask);
            this.postHolder = array;
            this.calculatePostMask();
        }
    }

    @Override
    public synchronized void removePostModificationListener(Object listener) {
        if (listener != null) {
            switch (this.postHolder.length) {
                case 0: {
                    return;
                }
                case 1: {
                    if (this.postHolder[0].listener == listener) {
                        this.postHolder = EMPTY_POST_HOLDERS;
                        this.calculatePostMask();
                    }
                    return;
                }
            }
            PostHolder[] array = new PostHolder[this.postHolder.length - 1];
            boolean match = false;
            for (int i = 0; i < this.postHolder.length; ++i) {
                if (match) {
                    array[i - 1] = this.postHolder[i];
                    continue;
                }
                if (this.postHolder[i].listener == listener) {
                    match = true;
                    continue;
                }
                array[i] = this.postHolder[i];
            }
            this.postHolder = array;
            this.calculatePostMask();
            return;
        }
    }

    public synchronized void setPostModificationListenerMask(StandardPostModificationListener listener, int mask) {
        if (listener != null) {
            for (int i = 0; i < this.postHolder.length; ++i) {
                if (this.postHolder[i].listener != listener) continue;
                this.postHolder[i].mask = mask;
                this.calculatePostMask();
                break;
            }
        }
    }

    protected void calculatePostMask() {
        this.postMask = 0;
        for (int i = 0; i < this.postHolder.length; ++i) {
            this.postMask |= this.postHolder[i].mask;
        }
    }

    @Override
    protected boolean preEvent(int type, int index, Object object, int repeat, Object previous, ObservableCollection view, int viewOffset) {
        this.preSize = this.getObservedCollection().size();
        return this.firePreEvent(type, index, object, repeat, previous, view, viewOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean firePreEvent(int type, int index, Object object, int repeat, Object previous, ObservableCollection view, int viewOffset) {
        if ((this.preMask & type) > 0) {
            StandardPreModificationEvent event = null;
            StandardModificationHandler standardModificationHandler = this;
            synchronized (standardModificationHandler) {
                for (int i = 0; i < this.preHolder.length; ++i) {
                    PreHolder holder = this.preHolder[i];
                    if ((holder.mask & type) <= 0) continue;
                    if (event == null) {
                        event = new StandardPreModificationEvent(this.getObservedCollection(), this, type, this.preSize, index, object, repeat, previous, view, viewOffset);
                    }
                    holder.listener.modificationOccurring(event);
                }
            }
        }
        return true;
    }

    @Override
    protected void postEvent(boolean modified, int type, int index, Object object, int repeat, Object previous, ObservableCollection view, int viewOffset) {
        if (modified) {
            this.firePostEvent(type, index, object, repeat, previous, view, viewOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePostEvent(int type, int index, Object object, int repeat, Object previous, ObservableCollection view, int viewOffset) {
        if ((this.postMask & type) > 0) {
            StandardPostModificationEvent event = null;
            StandardModificationHandler standardModificationHandler = this;
            synchronized (standardModificationHandler) {
                for (int i = 0; i < this.postHolder.length; ++i) {
                    PostHolder holder = this.postHolder[i];
                    if ((holder.mask & type) <= 0) continue;
                    if (event == null) {
                        event = new StandardPostModificationEvent(this.getObservedCollection(), this, type, this.preSize, index, object, repeat, previous, view, viewOffset);
                    }
                    holder.listener.modificationOccurred(event);
                }
            }
        }
    }

    @Override
    protected void postClear() {
        this.postEvent(this.preSize > 0, 32768, -1, (Object)null, 1, (Object)null, (ObservableCollection)null, -1);
    }

    static class Factory
    implements ModificationHandlerFactory {
        Factory() {
        }

        @Override
        public ModificationHandler createHandler(Collection coll, Object listener) {
            if (listener instanceof StandardPreModificationListener) {
                if (listener instanceof StandardPostModificationListener) {
                    return new StandardModificationHandler((StandardPreModificationListener)listener, -1, (StandardPostModificationListener)listener, -1);
                }
                return new StandardModificationHandler((StandardPreModificationListener)listener, -1, null, 0);
            }
            if (listener instanceof StandardPostModificationListener) {
                return new StandardModificationHandler(null, 0, (StandardPostModificationListener)listener, -1);
            }
            return null;
        }
    }

    protected static class PostHolder {
        final StandardPostModificationListener listener;
        int mask;

        PostHolder(StandardPostModificationListener listener, int mask) {
            this.listener = listener;
            this.mask = mask;
        }

        public String toString() {
            return "[" + this.listener + "," + ModificationEventType.toString(this.mask) + "]";
        }
    }

    protected static class PreHolder {
        final StandardPreModificationListener listener;
        int mask;

        PreHolder(StandardPreModificationListener listener, int mask) {
            this.listener = listener;
            this.mask = mask;
        }

        public String toString() {
            return "[" + this.listener + "," + ModificationEventType.toString(this.mask) + "]";
        }
    }
}

