/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.createkey.advanced;

import co.codewizards.cloudstore.core.bean.PropertyBase;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.adapter.JavaBeanObjectProperty;
import javafx.beans.property.adapter.JavaBeanObjectPropertyBuilder;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.util.StringConverter;
import org.subshare.core.pgp.CreatePgpKeyParam;
import org.subshare.gui.pgp.createkey.advanced.Messages;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.wizard.WizardPageContentGridPane;

public class AdvancedPane
extends WizardPageContentGridPane {
    private final CreatePgpKeyParam createPgpKeyParam;
    @FXML
    private ComboBox<CreatePgpKeyParam.Algorithm> algorithmComboBox;
    private final JavaBeanObjectProperty<CreatePgpKeyParam.Algorithm> algorithm;
    @FXML
    private ComboBox<Integer> strengthComboBox;
    private StringConverter<CreatePgpKeyParam.Algorithm> algorithmStringConverter = new StringConverter<CreatePgpKeyParam.Algorithm>(){

        public String toString(CreatePgpKeyParam.Algorithm algorithm) {
            return Messages.getString(String.format("AdvancedPane.Algorithm[%s]", algorithm));
        }

        public CreatePgpKeyParam.Algorithm fromString(String string) {
            throw new UnsupportedOperationException();
        }
    };
    private final PropertyChangeListener strengthPropertyChangeListener = event -> Platform.runLater(() -> this.updateStrengthComboBoxItems());

    public AdvancedPane(CreatePgpKeyParam createPgpKeyParam) {
        this.createPgpKeyParam = (CreatePgpKeyParam)AssertUtil.assertNotNull((Object)createPgpKeyParam, (String)"createPgpKeyParam");
        FxmlUtil.loadDynamicComponentFxml(AdvancedPane.class, this);
        this.algorithm = this.createAlgorithmProperty();
        this.algorithm.addListener(observable -> this.updateStrengthComboBoxItems());
        this.algorithmComboBox.setItems(FXCollections.observableArrayList((Object[])CreatePgpKeyParam.Algorithm.values()));
        this.algorithmComboBox.setConverter(this.algorithmStringConverter);
        this.algorithmComboBox.valueProperty().bindBidirectional(this.algorithm);
        this.updateStrengthComboBoxItems();
        this.strengthComboBox.valueProperty().addListener(observable -> createPgpKeyParam.setStrength(((Integer)this.strengthComboBox.getValue()).intValue()));
        createPgpKeyParam.addPropertyChangeListener((PropertyBase)CreatePgpKeyParam.PropertyEnum.strength, this.strengthPropertyChangeListener);
        this.updateComplete();
    }

    private void updateStrengthComboBoxItems() {
        List supportedStrengths = this.createPgpKeyParam.getAlgorithm().getSupportedStrengths();
        ObservableList items = this.strengthComboBox.getItems();
        items.retainAll((Collection)supportedStrengths);
        int index = -1;
        for (Integer supportedStrength : supportedStrengths) {
            if (++index < items.size() && supportedStrength.equals(items.get(index))) continue;
            items.add(index, (Object)supportedStrength);
        }
        this.strengthComboBox.setValue((Object)this.createPgpKeyParam.getStrength());
    }

    private JavaBeanObjectProperty<CreatePgpKeyParam.Algorithm> createAlgorithmProperty() {
        try {
            return JavaBeanObjectPropertyBuilder.create().bean((Object)this.createPgpKeyParam).name(CreatePgpKeyParam.PropertyEnum.algorithm.name()).build();
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean isComplete() {
        boolean complete = this.createPgpKeyParam.getAlgorithm() != null;
        return complete &= this.createPgpKeyParam.getStrength() > 0;
    }
}

