/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.AutoTrackLocalRevision;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.FetchGroup;
import javax.jdo.annotations.FetchGroups;
import javax.jdo.annotations.Index;
import javax.jdo.annotations.Indices;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import javax.jdo.listener.StoreCallback;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.state.StateManager;
import org.subshare.core.dto.CryptoKeyPart;
import org.subshare.core.dto.CryptoKeyRole;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signature;
import org.subshare.core.sign.WriteProtected;
import org.subshare.local.persistence.CryptoKey;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.SignatureImpl;
import org.subshare.local.persistence.UserRepoKeyPublicKey;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@Unique(name="CryptoLink_cryptoLinkId", members={"cryptoLinkId"})
@Indices(value={@Index(name="CryptoLink_localRevision", members={"localRevision"})})
@Queries(value={@Query(name="getCryptoLink_cryptoLinkId", value="SELECT UNIQUE WHERE this.cryptoLinkId == :cryptoLinkId"), @Query(name="getCryptoLinksChangedAfter_localRevision_exclLastSyncFromRepositoryId", value="SELECT WHERE this.localRevision > :localRevision && (this.lastSyncFromRepositoryId == null || this.lastSyncFromRepositoryId != :lastSyncFromRepositoryId)"), @Query(name="getCryptoLinksFrom_fromCryptoKey", value="SELECT WHERE this.fromCryptoKey == :fromCryptoKey"), @Query(name="getCryptoLinksTo_toCryptoKey", value="SELECT WHERE this.toCryptoKey == :toCryptoKey"), @Query(name="getCryptoLinks_fromUserRepoKeyPublicKey", value="SELECT WHERE this.fromUserRepoKeyPublicKey == :fromUserRepoKeyPublicKey"), @Query(name="getActiveCryptoLinks_toCryptoRepoFile_toCryptoKeyRole_toCryptoKeyPart", value="SELECT WHERE this.toCryptoKey.cryptoKeyDeactivation == null && this.toCryptoKey.cryptoRepoFile == :toCryptoRepoFile && this.toCryptoKey.cryptoKeyRole == :toCryptoKeyRole && this.toCryptoKeyPart == :toCryptoKeyPart"), @Query(name="getCryptoLinks_signingUserRepoKeyId", value="SELECT WHERE this.signature.signingUserRepoKeyId == :signingUserRepoKeyId")})
@FetchGroups(value={@FetchGroup(name="CryptoLinkDto", members={@Persistent(name="fromCryptoKey"), @Persistent(name="fromUserRepoKeyPublicKey"), @Persistent(name="toCryptoKeyData"), @Persistent(name="toCryptoKey"), @Persistent(name="signature")}), @FetchGroup(name="Signature", members={@Persistent(name="signature")})})
public class CryptoLink
extends Entity
implements WriteProtected,
AutoTrackLocalRevision,
StoreCallback,
Persistable {
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(length=22)
    private String cryptoLinkId;
    private long localRevision;
    private String lastSyncFromRepositoryId;
    private CryptoKey fromCryptoKey;
    private UserRepoKeyPublicKey fromUserRepoKeyPublicKey;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private CryptoKey toCryptoKey;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(jdbcType="INTEGER")
    private CryptoKeyPart toCryptoKeyPart;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Column(jdbcType="BLOB")
    private byte[] toCryptoKeyData;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Embedded(nullIndicatorColumn="signatureCreated")
    private SignatureImpl signature;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public CryptoLink() {
    }

    public CryptoLink(Uid cryptoLinkId) {
        this.cryptoLinkId = cryptoLinkId == null ? null : cryptoLinkId.toString();
    }

    public Uid getCryptoLinkId() {
        if (CryptoLink.dnGetcryptoLinkId(this) == null) {
            CryptoLink.dnSetcryptoLinkId(this, new Uid().toString());
        }
        return new Uid(CryptoLink.dnGetcryptoLinkId(this));
    }

    public CryptoKey getFromCryptoKey() {
        return CryptoLink.dnGetfromCryptoKey(this);
    }

    public void setFromCryptoKey(CryptoKey fromCryptoKey) {
        if (!Util.equal((Object)((Object)CryptoLink.dnGetfromCryptoKey(this)), (Object)((Object)fromCryptoKey))) {
            CryptoLink.dnSetfromCryptoKey(this, fromCryptoKey);
        }
    }

    public UserRepoKeyPublicKey getFromUserRepoKeyPublicKey() {
        return CryptoLink.dnGetfromUserRepoKeyPublicKey(this);
    }

    public void setFromUserRepoKeyPublicKey(UserRepoKeyPublicKey fromUserRepoKeyPublicKey) {
        if (!Util.equal((Object)((Object)CryptoLink.dnGetfromUserRepoKeyPublicKey(this)), (Object)((Object)fromUserRepoKeyPublicKey))) {
            CryptoLink.dnSetfromUserRepoKeyPublicKey(this, fromUserRepoKeyPublicKey);
        }
    }

    public CryptoKey getToCryptoKey() {
        return CryptoLink.dnGettoCryptoKey(this);
    }

    public void setToCryptoKey(CryptoKey cryptoKey) {
        if (!Util.equal((Object)((Object)CryptoLink.dnGettoCryptoKey(this)), (Object)((Object)cryptoKey))) {
            CryptoLink.dnSettoCryptoKey(this, cryptoKey);
        }
    }

    public CryptoKeyPart getToCryptoKeyPart() {
        return CryptoLink.dnGettoCryptoKeyPart(this);
    }

    public void setToCryptoKeyPart(CryptoKeyPart toCryptoKeyPart) {
        if (!Util.equal((Object)CryptoLink.dnGettoCryptoKeyPart(this), (Object)toCryptoKeyPart)) {
            CryptoLink.dnSettoCryptoKeyPart(this, toCryptoKeyPart);
        }
    }

    public byte[] getToCryptoKeyData() {
        return CryptoLink.dnGettoCryptoKeyData(this);
    }

    public void setToCryptoKeyData(byte[] toCryptoKeyData) {
        if (!Util.equal((byte[])CryptoLink.dnGettoCryptoKeyData(this), (byte[])toCryptoKeyData)) {
            CryptoLink.dnSettoCryptoKeyData(this, toCryptoKeyData);
        }
    }

    public long getLocalRevision() {
        return CryptoLink.dnGetlocalRevision(this);
    }

    public void setLocalRevision(long localRevision) {
        if (!Util.equal((long)CryptoLink.dnGetlocalRevision(this), (long)localRevision)) {
            CryptoLink.dnSetlocalRevision(this, localRevision);
        }
    }

    public UUID getLastSyncFromRepositoryId() {
        return CryptoLink.dnGetlastSyncFromRepositoryId(this) == null ? null : UUID.fromString(CryptoLink.dnGetlastSyncFromRepositoryId(this));
    }

    public void setLastSyncFromRepositoryId(UUID repositoryId) {
        if (!Util.equal((Object)this.getLastSyncFromRepositoryId(), (Object)repositoryId)) {
            CryptoLink.dnSetlastSyncFromRepositoryId(this, repositoryId == null ? null : repositoryId.toString());
        }
    }

    public void jdoPreStore() {
        this.getCryptoLinkId();
        if (CryptoLink.dnGetfromCryptoKey(this) != null && CryptoLink.dnGetfromUserRepoKeyPublicKey(this) != null) {
            throw new IllegalStateException("fromCryptoKey != null && fromUserRepoKeyPublicKey != null :: toCryptoKeyData can only be encrypted with one key!");
        }
    }

    public String getSignedDataType() {
        return "CryptoLink";
    }

    public int getSignedDataVersion() {
        return 0;
    }

    public InputStream getSignedData(int signedDataVersion) {
        try {
            byte separatorIndex = 0;
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[11];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource((Uid)this.getCryptoLinkId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource(CryptoLink.dnGetfromCryptoKey(this) == null ? null : CryptoLink.dnGetfromCryptoKey(this).getCryptoKeyId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[3] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[4] = InputStreamSource.Helper.createInputStreamSource(CryptoLink.dnGetfromUserRepoKeyPublicKey(this) == null ? null : CryptoLink.dnGetfromUserRepoKeyPublicKey(this).getUserRepoKeyId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[5] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[6] = InputStreamSource.Helper.createInputStreamSource((Uid)CryptoLink.dnGettoCryptoKey(this).getCryptoKeyId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[7] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[8] = InputStreamSource.Helper.createInputStreamSource((int)CryptoLink.dnGettoCryptoKeyPart(this).ordinal());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[9] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[10] = InputStreamSource.Helper.createInputStreamSource((byte[])CryptoLink.dnGettoCryptoKeyData(this));
            return new MultiInputStream(inputStreamSourceArray);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public Signature getSignature() {
        return CryptoLink.dnGetsignature(this);
    }

    public void setSignature(Signature signature) {
        if (!Util.equal((Object)CryptoLink.dnGetsignature(this), (Object)signature)) {
            CryptoLink.dnSetsignature(this, SignatureImpl.copy(signature));
        }
    }

    public Uid getCryptoRepoFileIdControllingPermissions() {
        CryptoRepoFile cryptoRepoFile = ((CryptoKey)((Object)AssertUtil.assertNotNull((Object)((Object)CryptoLink.dnGettoCryptoKey(this)), (String)"toCryptoKey"))).getCryptoRepoFile();
        return ((CryptoRepoFile)((Object)AssertUtil.assertNotNull((Object)((Object)cryptoRepoFile), (String)"cryptoRepoFile"))).getCryptoRepoFileId();
    }

    public PermissionType getPermissionTypeRequiredForWrite() {
        if (CryptoLink.dnGettoCryptoKey(this) == null) {
            throw new IllegalStateException("toCryptoKey == null");
        }
        CryptoKeyRole cryptoKeyRole = CryptoLink.dnGettoCryptoKey(this).getCryptoKeyRole();
        if (cryptoKeyRole == null) {
            throw new IllegalStateException("toCryptoKey.cryptoKeyRole == null");
        }
        return cryptoKeyRole == CryptoKeyRole.clearanceKey ? PermissionType.grant : PermissionType.write;
    }

    public String toString() {
        return String.format("%s{cryptoLinkId=%s, fromCryptoKey=%s, fromUserRepoKeyPublicKey=%s, toCryptoKey=%s, toCryptoKeyPart=%s}", new Object[]{super.toString(), CryptoLink.dnGetcryptoLinkId(this), CryptoLink.dnGetfromCryptoKey(this), CryptoLink.dnGetfromUserRepoKeyPublicKey(this), CryptoLink.dnGettoCryptoKey(this), CryptoLink.dnGettoCryptoKeyPart(this)});
    }

    static {
        dnFieldNames = CryptoLink.__dnFieldNamesInit();
        dnFieldTypes = CryptoLink.__dnFieldTypesInit();
        dnFieldFlags = CryptoLink.__dnFieldFlagsInit();
        dnInheritedFieldCount = CryptoLink.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = CryptoLink.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)CryptoLink.___dn$loadClass("org.subshare.local.persistence.CryptoLink"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new CryptoLink());
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        CryptoLink result = new CryptoLink();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        CryptoLink result = new CryptoLink();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.cryptoLinkId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 1: {
                this.fromCryptoKey = (CryptoKey)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 2: {
                this.fromUserRepoKeyPublicKey = (UserRepoKeyPublicKey)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 3: {
                this.lastSyncFromRepositoryId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 4: {
                this.localRevision = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 5: {
                this.signature = (SignatureImpl)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 6: {
                this.toCryptoKey = (CryptoKey)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 7: {
                this.toCryptoKeyData = (byte[])this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 8: {
                this.toCryptoKeyPart = (CryptoKeyPart)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.cryptoLinkId);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.fromCryptoKey);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.fromUserRepoKeyPublicKey);
                break;
            }
            case 3: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.lastSyncFromRepositoryId);
                break;
            }
            case 4: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.localRevision);
                break;
            }
            case 5: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.signature);
                break;
            }
            case 6: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.toCryptoKey);
                break;
            }
            case 7: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.toCryptoKeyData);
                break;
            }
            case 8: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.toCryptoKeyPart);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(CryptoLink obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.cryptoLinkId = obj.cryptoLinkId;
                break;
            }
            case 1: {
                this.fromCryptoKey = obj.fromCryptoKey;
                break;
            }
            case 2: {
                this.fromUserRepoKeyPublicKey = obj.fromUserRepoKeyPublicKey;
                break;
            }
            case 3: {
                this.lastSyncFromRepositoryId = obj.lastSyncFromRepositoryId;
                break;
            }
            case 4: {
                this.localRevision = obj.localRevision;
                break;
            }
            case 5: {
                this.signature = obj.signature;
                break;
            }
            case 6: {
                this.toCryptoKey = obj.toCryptoKey;
                break;
            }
            case 7: {
                this.toCryptoKeyData = obj.toCryptoKeyData;
                break;
            }
            case 8: {
                this.toCryptoKeyPart = obj.toCryptoKeyPart;
                break;
            }
            default: {
                super.dnCopyField((Entity)obj, index);
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof CryptoLink)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.CryptoLink");
        }
        CryptoLink other = (CryptoLink)((Object)obj);
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"cryptoLinkId", "fromCryptoKey", "fromUserRepoKeyPublicKey", "lastSyncFromRepositoryId", "localRevision", "signature", "toCryptoKey", "toCryptoKeyData", "toCryptoKeyPart"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{CryptoLink.___dn$loadClass("java.lang.String"), CryptoLink.___dn$loadClass("org.subshare.local.persistence.CryptoKey"), CryptoLink.___dn$loadClass("org.subshare.local.persistence.UserRepoKeyPublicKey"), CryptoLink.___dn$loadClass("java.lang.String"), Long.TYPE, CryptoLink.___dn$loadClass("org.subshare.local.persistence.SignatureImpl"), CryptoLink.___dn$loadClass("org.subshare.local.persistence.CryptoKey"), CryptoLink.___dn$loadClass("[B"), CryptoLink.___dn$loadClass("org.subshare.core.dto.CryptoKeyPart")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{21, 10, 10, 21, 21, 10, 10, 26, 21};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 9 + Entity.dnGetManagedFieldCount();
    }

    private static Class __dnPersistableSuperclassInit() {
        return CryptoLink.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Entity");
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        CryptoLink o = (CryptoLink)((Object)super.clone());
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static String dnGetcryptoLinkId(CryptoLink objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.cryptoLinkId);
        }
        return objPC.cryptoLinkId;
    }

    private static void dnSetcryptoLinkId(CryptoLink objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.cryptoLinkId, val);
        } else {
            objPC.cryptoLinkId = val;
        }
    }

    private static CryptoKey dnGetfromCryptoKey(CryptoLink objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return (CryptoKey)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.fromCryptoKey));
        }
        return objPC.fromCryptoKey;
    }

    private static void dnSetfromCryptoKey(CryptoLink objPC, CryptoKey val) {
        if (objPC.dnStateManager == null) {
            objPC.fromCryptoKey = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.fromCryptoKey, (Object)val);
        }
    }

    private static UserRepoKeyPublicKey dnGetfromUserRepoKeyPublicKey(CryptoLink objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return (UserRepoKeyPublicKey)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.fromUserRepoKeyPublicKey));
        }
        return objPC.fromUserRepoKeyPublicKey;
    }

    private static void dnSetfromUserRepoKeyPublicKey(CryptoLink objPC, UserRepoKeyPublicKey val) {
        if (objPC.dnStateManager == null) {
            objPC.fromUserRepoKeyPublicKey = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.fromUserRepoKeyPublicKey, (Object)val);
        }
    }

    private static String dnGetlastSyncFromRepositoryId(CryptoLink objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.lastSyncFromRepositoryId);
        }
        return objPC.lastSyncFromRepositoryId;
    }

    private static void dnSetlastSyncFromRepositoryId(CryptoLink objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.lastSyncFromRepositoryId, val);
        } else {
            objPC.lastSyncFromRepositoryId = val;
        }
    }

    private static long dnGetlocalRevision(CryptoLink objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 4 + dnInheritedFieldCount, objPC.localRevision);
        }
        return objPC.localRevision;
    }

    private static void dnSetlocalRevision(CryptoLink objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 4 + dnInheritedFieldCount, objPC.localRevision, val);
        } else {
            objPC.localRevision = val;
        }
    }

    private static SignatureImpl dnGetsignature(CryptoLink objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5 + dnInheritedFieldCount)) {
            return (SignatureImpl)objPC.dnStateManager.getObjectField((Persistable)objPC, 5 + dnInheritedFieldCount, (Object)objPC.signature);
        }
        return objPC.signature;
    }

    private static void dnSetsignature(CryptoLink objPC, SignatureImpl val) {
        if (objPC.dnStateManager == null) {
            objPC.signature = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 5 + dnInheritedFieldCount, (Object)objPC.signature, (Object)val);
        }
    }

    private static CryptoKey dnGettoCryptoKey(CryptoLink objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6 + dnInheritedFieldCount)) {
            return (CryptoKey)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 6 + dnInheritedFieldCount, (Object)objPC.toCryptoKey));
        }
        return objPC.toCryptoKey;
    }

    private static void dnSettoCryptoKey(CryptoLink objPC, CryptoKey val) {
        if (objPC.dnStateManager == null) {
            objPC.toCryptoKey = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 6 + dnInheritedFieldCount, (Object)objPC.toCryptoKey, (Object)val);
        }
    }

    private static byte[] dnGettoCryptoKeyData(CryptoLink objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 7 + dnInheritedFieldCount)) {
            return (byte[])objPC.dnStateManager.getObjectField((Persistable)objPC, 7 + dnInheritedFieldCount, (Object)objPC.toCryptoKeyData);
        }
        return objPC.toCryptoKeyData;
    }

    private static void dnSettoCryptoKeyData(CryptoLink objPC, byte[] val) {
        if (objPC.dnStateManager == null) {
            objPC.toCryptoKeyData = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 7 + dnInheritedFieldCount, (Object)objPC.toCryptoKeyData, (Object)val);
        }
    }

    private static CryptoKeyPart dnGettoCryptoKeyPart(CryptoLink objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 8 + dnInheritedFieldCount)) {
            return (CryptoKeyPart)objPC.dnStateManager.getObjectField((Persistable)objPC, 8 + dnInheritedFieldCount, (Object)objPC.toCryptoKeyPart);
        }
        return objPC.toCryptoKeyPart;
    }

    private static void dnSettoCryptoKeyPart(CryptoLink objPC, CryptoKeyPart val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 8 + dnInheritedFieldCount, (Object)objPC.toCryptoKeyPart, (Object)val);
        } else {
            objPC.toCryptoKeyPart = val;
        }
    }
}

