/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot;

import java.util.HashMap;
import java.util.Map;

public enum OwnerTrust {
    UNKNOWN(0),
    NEVER(3),
    MARGINAL(4),
    FULL(5),
    ULTIMATE(6);

    private final int numericValue;
    private static volatile Map<Integer, OwnerTrust> numericValue2OwnerTrust;

    private OwnerTrust(int numericValue) {
        this.numericValue = numericValue;
    }

    public int getNumericValue() {
        return this.numericValue;
    }

    public static OwnerTrust fromNumericValue(int numericValue) {
        OwnerTrust ownerTrust = OwnerTrust.getNumericValue2OwnerTrust().get(numericValue);
        if (ownerTrust == null) {
            throw new IllegalArgumentException("numericValue unknown: " + numericValue);
        }
        return ownerTrust;
    }

    private static Map<Integer, OwnerTrust> getNumericValue2OwnerTrust() {
        if (numericValue2OwnerTrust == null) {
            HashMap<Integer, OwnerTrust> m = new HashMap<Integer, OwnerTrust>(OwnerTrust.values().length);
            for (OwnerTrust ownerTrust : OwnerTrust.values()) {
                m.put(ownerTrust.getNumericValue(), ownerTrust);
            }
            numericValue2OwnerTrust = m;
        }
        return numericValue2OwnerTrust;
    }
}

