/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.crypto.internal.mac;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.digests.MD2Digest;
import org.bouncycastle.crypto.digests.MD4Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.RIPEMD128Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.TigerDigest;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.macs.CBCBlockCipherMac;
import org.bouncycastle.crypto.macs.CFBBlockCipherMac;
import org.bouncycastle.crypto.macs.GOST28147Mac;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.macs.ISO9797Alg3Mac;
import org.bouncycastle.crypto.macs.OldHMac;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.ISO7816d4Padding;
import org.subshare.crypto.AbstractMACCalculatorFactory;
import org.subshare.crypto.MACCalculator;
import org.subshare.crypto.internal.mac.MACCalculatorImpl;

public abstract class MACCalculatorFactoryImpl
extends AbstractMACCalculatorFactory {

    public static class Tiger
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            TigerDigest digest = new TigerDigest();
            return new MACCalculatorImpl((Mac)new HMac((Digest)digest), digest.getDigestSize(), 0);
        }
    }

    public static class RIPEMD160
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            RIPEMD160Digest digest = new RIPEMD160Digest();
            return new MACCalculatorImpl((Mac)new HMac((Digest)digest), digest.getDigestSize(), 0);
        }
    }

    public static class RIPEMD128
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            RIPEMD128Digest digest = new RIPEMD128Digest();
            return new MACCalculatorImpl((Mac)new HMac((Digest)digest), digest.getDigestSize(), 0);
        }
    }

    @Deprecated
    public static class OldSHA512
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            SHA512Digest digest = new SHA512Digest();
            return new MACCalculatorImpl((Mac)new OldHMac((Digest)digest), digest.getDigestSize(), 0);
        }
    }

    public static class SHA512
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            SHA512Digest digest = new SHA512Digest();
            return new MACCalculatorImpl((Mac)new HMac((Digest)digest), digest.getDigestSize(), 0);
        }
    }

    @Deprecated
    public static class OldSHA384
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            SHA384Digest digest = new SHA384Digest();
            return new MACCalculatorImpl((Mac)new OldHMac((Digest)digest), digest.getDigestSize(), 0);
        }
    }

    public static class SHA384
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            SHA384Digest digest = new SHA384Digest();
            return new MACCalculatorImpl((Mac)new HMac((Digest)digest), digest.getDigestSize(), 0);
        }
    }

    public static class SHA256
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            SHA256Digest digest = new SHA256Digest();
            return new MACCalculatorImpl((Mac)new HMac((Digest)digest), digest.getDigestSize(), 0);
        }
    }

    public static class SHA224
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            SHA224Digest digest = new SHA224Digest();
            return new MACCalculatorImpl((Mac)new HMac((Digest)digest), digest.getDigestSize(), 0);
        }
    }

    public static class SHA1
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            SHA1Digest digest = new SHA1Digest();
            return new MACCalculatorImpl((Mac)new HMac((Digest)digest), digest.getDigestSize(), 0);
        }
    }

    public static class MD5
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            MD5Digest digest = new MD5Digest();
            return new MACCalculatorImpl((Mac)new HMac((Digest)digest), digest.getDigestSize(), 0);
        }
    }

    public static class MD4
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            MD4Digest digest = new MD4Digest();
            return new MACCalculatorImpl((Mac)new HMac((Digest)digest), digest.getDigestSize(), 0);
        }
    }

    public static class MD2
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            MD2Digest digest = new MD2Digest();
            return new MACCalculatorImpl((Mac)new HMac((Digest)digest), digest.getDigestSize(), 0);
        }
    }

    public static class DES9797Alg3
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            DESEngine cipher = new DESEngine();
            return new MACCalculatorImpl((Mac)new ISO9797Alg3Mac((BlockCipher)cipher), 24, cipher.getBlockSize());
        }
    }

    public static class DES9797Alg3with7816d4
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            DESEngine cipher = new DESEngine();
            return new MACCalculatorImpl((Mac)new ISO9797Alg3Mac((BlockCipher)cipher, (BlockCipherPadding)new ISO7816d4Padding()), 24, cipher.getBlockSize());
        }
    }

    public static class RC2CFB8
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            RC2Engine cipher = new RC2Engine();
            return new MACCalculatorImpl((Mac)new CFBBlockCipherMac((BlockCipher)cipher), cipher.getBlockSize(), cipher.getBlockSize());
        }
    }

    public static class DESCFB8
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            DESEngine cipher = new DESEngine();
            return new MACCalculatorImpl((Mac)new CFBBlockCipherMac((BlockCipher)cipher), cipher.getBlockSize(), cipher.getBlockSize());
        }
    }

    public static class GOST28147
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            return new MACCalculatorImpl((Mac)new GOST28147Mac(), 32, 0);
        }
    }

    public static class RC2
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            RC2Engine cipher = new RC2Engine();
            return new MACCalculatorImpl((Mac)new CBCBlockCipherMac((BlockCipher)cipher), cipher.getBlockSize(), cipher.getBlockSize());
        }
    }

    public static class DES64
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            DESEngine cipher = new DESEngine();
            return new MACCalculatorImpl((Mac)new CBCBlockCipherMac((BlockCipher)cipher, 64), cipher.getBlockSize(), cipher.getBlockSize());
        }
    }

    public static class DES
    extends MACCalculatorFactoryImpl {
        @Override
        public MACCalculator _createMACCalculator() {
            DESEngine cipher = new DESEngine();
            return new MACCalculatorImpl((Mac)new CBCBlockCipherMac((BlockCipher)cipher), cipher.getBlockSize(), cipher.getBlockSize());
        }
    }
}

