/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local;

import co.codewizards.cloudstore.core.context.ExtensibleContextSupport;
import co.codewizards.cloudstore.core.io.TimeoutException;
import co.codewizards.cloudstore.core.repo.local.ContextWithLocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.DaoProvider;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransactionListenerRegistry;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransactionPostCloseEvent;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransactionPostCloseListener;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransactionPreCloseEvent;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransactionPreCloseListener;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.ContextWithPersistenceManager;
import co.codewizards.cloudstore.local.LocalRepoManagerImpl;
import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.LocalRepository;
import co.codewizards.cloudstore.local.persistence.LocalRepositoryDao;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRepoTransactionImpl
implements LocalRepoTransaction,
ContextWithLocalRepoManager,
ContextWithPersistenceManager {
    private static final Logger logger = LoggerFactory.getLogger(LocalRepoTransactionImpl.class);
    public static final long LOCK_TIMEOUT = 300000L;
    private final LocalRepoManager localRepoManager;
    private final PersistenceManagerFactory persistenceManagerFactory;
    private final boolean write;
    private PersistenceManager persistenceManager;
    private Transaction jdoTransaction;
    private final Lock lock;
    private long localRevision = -1L;
    private final Map<Class<?>, Object> daoClass2Dao = new HashMap();
    private final ExtensibleContextSupport extensibleContextSupport = new ExtensibleContextSupport();
    private final LocalRepoTransactionListenerRegistry listenerRegistry = new LocalRepoTransactionListenerRegistry((LocalRepoTransaction)this);
    private final CopyOnWriteArrayList<LocalRepoTransactionPreCloseListener> preCloseListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<LocalRepoTransactionPostCloseListener> postCloseListeners = new CopyOnWriteArrayList();

    public LocalRepoTransactionImpl(LocalRepoManagerImpl localRepoManager, boolean write) {
        this.localRepoManager = (LocalRepoManager)AssertUtil.assertNotNull((Object)localRepoManager, (String)"localRepoManager");
        this.persistenceManagerFactory = (PersistenceManagerFactory)AssertUtil.assertNotNull((Object)localRepoManager.getPersistenceManagerFactory(), (String)"localRepoManager.persistenceManagerFactory");
        this.lock = localRepoManager.getLock();
        this.write = write;
        this.begin();
    }

    private void begin() {
        boolean locked = false;
        try {
            locked = this.lock.tryLock(300000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!locked) {
            throw new TimeoutException(String.format("Starting %s transaction on '%s' within timeout (%s ms) failed! ", this.write ? "write" : "read", this.localRepoManager.getLocalRoot(), 300000L));
        }
        try {
            if (this.isActive()) {
                throw new IllegalStateException("Transaction is already active!");
            }
            this.lockIfWrite();
            this.persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
            this.jdoTransaction = this.persistenceManager.currentTransaction();
            this.jdoTransaction.begin();
            this.listenerRegistry.onBegin();
        }
        finally {
            this.lock.unlock();
        }
    }

    private final void lockIfWrite() {
        if (this.write) {
            this.lock.lock();
        }
    }

    private final void unlockIfWrite() {
        if (this.write) {
            this.lock.unlock();
        }
    }

    public void commit() {
        this.lock.lock();
        try {
            if (!this.isActive()) {
                throw new IllegalStateException("Transaction is not active!");
            }
            this.listenerRegistry.onCommit();
            this.firePreCloseListeners(true);
            this.daoClass2Dao.clear();
            this.jdoTransaction.commit();
            this.persistenceManager.close();
            this.jdoTransaction = null;
            this.persistenceManager = null;
            this.localRevision = -1L;
            this.unlockIfWrite();
        }
        finally {
            this.lock.unlock();
        }
        this.firePostCloseListeners(true);
    }

    public boolean isActive() {
        this.lock.lock();
        try {
            boolean bl = this.jdoTransaction != null && this.jdoTransaction.isActive();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void rollback() {
        this._rollback();
        this.firePostCloseListeners(false);
    }

    public void rollbackIfActive() {
        boolean active;
        this.lock.lock();
        try {
            active = this.isActive();
            if (active) {
                this._rollback();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (active) {
            this.firePostCloseListeners(false);
        }
    }

    protected void _rollback() {
        this.lock.lock();
        try {
            if (!this.isActive()) {
                throw new IllegalStateException("Transaction is not active!");
            }
            this.listenerRegistry.onRollback();
            this.firePreCloseListeners(false);
            this.daoClass2Dao.clear();
            this.jdoTransaction.rollback();
            this.persistenceManager.close();
            this.jdoTransaction = null;
            this.persistenceManager = null;
            this.localRevision = -1L;
            this.unlockIfWrite();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() {
        this.rollbackIfActive();
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        if (!this.isActive()) {
            throw new IllegalStateException("Transaction is not active!");
        }
        return this.persistenceManager;
    }

    public long getLocalRevision() {
        if (this.localRevision < 0L) {
            if (!this.write) {
                throw new IllegalStateException("This is a read-only transaction!");
            }
            this.jdoTransaction.setSerializeRead(Boolean.valueOf(true));
            LocalRepository lr = this.getDao(LocalRepositoryDao.class).getLocalRepositoryOrFail();
            this.jdoTransaction.setSerializeRead(null);
            this.localRevision = lr.getRevision() + 1L;
            lr.setRevision(this.localRevision);
            this.persistenceManager.flush();
        }
        return this.localRevision;
    }

    public LocalRepoManager getLocalRepoManager() {
        return this.localRepoManager;
    }

    public <D> D getDao(Class<D> daoClass) {
        AssertUtil.assertNotNull(daoClass, (String)"daoClass");
        Object dao = this.daoClass2Dao.get(daoClass);
        if (dao == null) {
            PersistenceManager pm = this.getPersistenceManager();
            try {
                dao = daoClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (!(dao instanceof Dao)) {
                throw new IllegalStateException(String.format("dao class %s does not extend Dao!", daoClass.getName()));
            }
            ((Dao)dao).setPersistenceManager(pm);
            ((Dao)dao).setDaoProvider((DaoProvider)this);
            this.daoClass2Dao.put(daoClass, dao);
        }
        return (D)dao;
    }

    public void flush() {
        PersistenceManager pm = this.getPersistenceManager();
        pm.flush();
    }

    public void setContextObject(Object object) {
        this.extensibleContextSupport.setContextObject(object);
    }

    public <T> T getContextObject(Class<T> clazz) {
        return (T)this.extensibleContextSupport.getContextObject(clazz);
    }

    public void removeContextObject(Object object) {
        this.extensibleContextSupport.removeContextObject(object);
    }

    public void removeContextObject(Class<?> clazz) {
        this.extensibleContextSupport.removeContextObject(clazz);
    }

    public void addPreCloseListener(LocalRepoTransactionPreCloseListener listener) {
        this.preCloseListeners.add((LocalRepoTransactionPreCloseListener)AssertUtil.assertNotNull((Object)listener, (String)"listener"));
    }

    public void addPostCloseListener(LocalRepoTransactionPostCloseListener listener) {
        this.postCloseListeners.add((LocalRepoTransactionPostCloseListener)AssertUtil.assertNotNull((Object)listener, (String)"listener"));
    }

    protected void firePreCloseListeners(boolean commit) {
        LocalRepoTransactionPreCloseEvent event = null;
        for (LocalRepoTransactionPreCloseListener listener : this.preCloseListeners) {
            try {
                if (event == null) {
                    event = new LocalRepoTransactionPreCloseEvent((LocalRepoTransaction)this);
                }
                if (commit) {
                    listener.preCommit(event);
                    continue;
                }
                listener.preRollback(event);
            }
            catch (Exception x) {
                logger.error("firePreCloseListeners: " + x, (Throwable)x);
            }
        }
    }

    protected void firePostCloseListeners(boolean commit) {
        LocalRepoTransactionPostCloseEvent event = null;
        for (LocalRepoTransactionPostCloseListener listener : this.postCloseListeners) {
            try {
                if (event == null) {
                    event = new LocalRepoTransactionPostCloseEvent((LocalRepoTransaction)this);
                }
                if (commit) {
                    listener.postCommit(event);
                    continue;
                }
                listener.postRollback(event);
            }
            catch (Exception x) {
                logger.error("firePostCloseListeners: " + x, (Throwable)x);
            }
        }
    }
}

