/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp.gnupg;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.IdentityHashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.bouncycastle.openpgp.wot.IoFile;
import org.bouncycastle.openpgp.wot.PgpFile;
import org.bouncycastle.openpgp.wot.TrustDb;
import org.bouncycastle.openpgp.wot.key.PgpKeyRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustDbFactory {
    private static final Logger logger = LoggerFactory.getLogger(TrustDbFactory.class);
    private final File trustDbFile;
    private final PgpKeyRegistry pgpKeyRegistry;
    private TrustDb trustDb;
    private IdentityHashMap<TrustDb, TrustDb> proxies = new IdentityHashMap();
    private final Timer deferredCloseTimer = new Timer("TrustDbFactory.deferredCloseTimer");
    private DeferredCloseTimerTask deferredCloseTimerTask;

    public TrustDbFactory(File trustDbFile, PgpKeyRegistry pgpKeyRegistry) {
        this.trustDbFile = (File)AssertUtil.assertNotNull((Object)trustDbFile, (String)"trustDbFile");
        this.pgpKeyRegistry = (PgpKeyRegistry)AssertUtil.assertNotNull((Object)pgpKeyRegistry, (String)"pgpKeyRegistry");
    }

    public synchronized TrustDb createTrustDb() {
        if (this.trustDb == null) {
            logger.debug("createTrustDb: Creating *real* TrustDb instance.");
            try {
                this.trustDb = TrustDb.Helper.createInstance((PgpFile)new IoFile(this.trustDbFile.getIoFile()), (PgpKeyRegistry)this.pgpKeyRegistry);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        } else {
            logger.trace("createTrustDb: Using existing *real* TrustDb instance.");
        }
        Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{TrustDb.class}, new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                TrustDb trustDbProxy = (TrustDb)proxy;
                TrustDbFactory trustDbFactory = TrustDbFactory.this;
                synchronized (trustDbFactory) {
                    if ("close".equals(method.getName())) {
                        TrustDbFactory.this._close(trustDbProxy);
                        return null;
                    }
                    TrustDbFactory.this._assertIsOpen(trustDbProxy);
                    Object result = method.invoke((Object)TrustDbFactory.this.trustDb, args);
                    return result;
                }
            }
        });
        TrustDb trustDbProxy = (TrustDb)proxy;
        this.proxies.put(trustDbProxy, trustDbProxy);
        logger.trace("createTrustDb: Created and enlisted new proxy. openProxyCount={}", (Object)this.proxies.size());
        return trustDbProxy;
    }

    protected void _close(TrustDb trustDbProxy) {
        AssertUtil.assertNotNull((Object)trustDbProxy, (String)"trustDbProxy");
        if (this._isOpen(trustDbProxy)) {
            this.proxies.remove(trustDbProxy);
            logger.trace("_close: Delisted proxy. openProxyCount={}", (Object)this.proxies.size());
            if (this.proxies.isEmpty()) {
                if (this.deferredCloseTimerTask != null) {
                    this.deferredCloseTimerTask.cancel();
                }
                this.deferredCloseTimerTask = new DeferredCloseTimerTask();
                this.deferredCloseTimer.schedule((TimerTask)this.deferredCloseTimerTask, 10000L);
            }
        }
    }

    protected void _assertIsOpen(TrustDb trustDbProxy) {
        AssertUtil.assertNotNull((Object)trustDbProxy, (String)"trustDbProxy");
        if (!this._isOpen(trustDbProxy)) {
            throw new IllegalStateException("trustDbProxy is already closed!");
        }
    }

    protected boolean _isOpen(TrustDb trustDbProxy) {
        AssertUtil.assertNotNull((Object)trustDbProxy, (String)"trustDbProxy");
        return this.proxies.containsKey(trustDbProxy);
    }

    private class DeferredCloseTimerTask
    extends TimerTask {
        private final Logger logger = LoggerFactory.getLogger(DeferredCloseTimerTask.class);

        private DeferredCloseTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TrustDbFactory trustDbFactory = TrustDbFactory.this;
            synchronized (trustDbFactory) {
                if (TrustDbFactory.this.deferredCloseTimerTask != this) {
                    this.logger.debug("run: Aborting, because this is not the current instance, anymore.");
                    return;
                }
                if (TrustDbFactory.this.proxies.isEmpty() && TrustDbFactory.this.trustDb != null) {
                    this.logger.debug("run: Closing *real* TrustDb instance.");
                    TrustDbFactory.this.trustDb.close();
                    TrustDbFactory.this.trustDb = null;
                }
                TrustDbFactory.this.deferredCloseTimerTask = null;
            }
        }
    }
}

