/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.repo.sync;

import co.codewizards.cloudstore.core.dto.ChangeSetDto;
import co.codewizards.cloudstore.core.dto.DeleteModificationDto;
import co.codewizards.cloudstore.core.dto.DirectoryDto;
import co.codewizards.cloudstore.core.dto.FileChunkDto;
import co.codewizards.cloudstore.core.dto.ModificationDto;
import co.codewizards.cloudstore.core.dto.NormalFileDto;
import co.codewizards.cloudstore.core.dto.RepoFileDtoTreeNode;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.progress.SubProgressMonitor;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.repo.sync.RepoToRepoSync;
import co.codewizards.cloudstore.core.repo.transport.CollisionException;
import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.HashUtil;
import java.net.URL;
import org.subshare.core.LocalRepoStorage;
import org.subshare.core.LocalRepoStorageFactoryRegistry;
import org.subshare.core.dto.CryptoChangeSetDto;
import org.subshare.core.dto.SsDeleteModificationDto;
import org.subshare.core.dto.SsFileChunkDto;
import org.subshare.core.dto.SsNormalFileDto;
import org.subshare.core.repo.sync.PaddingUtil;
import org.subshare.core.repo.transport.CryptreeClientFileRepoTransport;
import org.subshare.core.repo.transport.CryptreeRepoTransport;
import org.subshare.core.repo.transport.CryptreeRestRepoTransport;

public class SsRepoToRepoSync
extends RepoToRepoSync {
    private Boolean metaOnly;
    private boolean firstSyncUp;

    protected SsRepoToRepoSync(File localRoot, URL remoteRoot) {
        super(localRoot, remoteRoot);
    }

    protected void syncUp(ProgressMonitor monitor) {
        if (this.isMetaOnly()) {
            return;
        }
        if (this.firstSyncUp) {
            this.updateLastCryptoKeySyncToRemoteRepo(monitor);
            this.firstSyncUp = false;
        }
        super.syncUp(monitor);
    }

    private void updateLastCryptoKeySyncToRemoteRepo(ProgressMonitor monitor) {
        CryptoChangeSetDto cryptoChangeSetDto;
        Long revision = ((CryptreeRestRepoTransport)this.remoteRepoTransport).getLastCryptoKeySyncFromRemoteRepoRemoteRepositoryRevisionSynced();
        if (revision != null && !(cryptoChangeSetDto = ((CryptreeClientFileRepoTransport)this.localRepoTransport).getCryptoChangeSetDto(revision)).isEmpty()) {
            ((CryptreeRestRepoTransport)this.remoteRepoTransport).putCryptoChangeSetDto(cryptoChangeSetDto);
        }
    }

    private boolean isMetaOnly() {
        if (this.metaOnly == null) {
            try (LocalRepoTransaction transaction = this.localRepoManager.beginReadTransaction();){
                LocalRepoStorage lrs = LocalRepoStorageFactoryRegistry.getInstance().getLocalRepoStorageFactoryOrFail().getLocalRepoStorageOrCreate(transaction);
                this.metaOnly = lrs.isMetaOnly();
            }
        }
        return this.metaOnly;
    }

    public void sync(ProgressMonitor monitor) {
        this.firstSyncUp = true;
        AssertUtil.assertNotNull((Object)monitor, (String)"monitor");
        monitor.beginTask("Synchronising...", 251);
        try {
            super.sync((ProgressMonitor)new SubProgressMonitor(monitor, 201));
            this.syncUp((ProgressMonitor)new SubProgressMonitor(monitor, 50));
        }
        finally {
            monitor.done();
        }
    }

    protected void applyDeleteModification(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, DeleteModificationDto deleteModificationDto) {
        if (toRepoTransport instanceof CryptreeRestRepoTransport) {
            SsDeleteModificationDto dto = (SsDeleteModificationDto)deleteModificationDto;
            ((CryptreeRestRepoTransport)toRepoTransport).delete(dto);
        } else {
            super.applyDeleteModification(fromRepoTransport, toRepoTransport, deleteModificationDto);
        }
    }

    protected void beginPutFile(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, RepoFileDtoTreeNode repoFileDtoTreeNode, String path, NormalFileDto fromNormalFileDto) throws CollisionException {
        if (toRepoTransport instanceof CryptreeRepoTransport) {
            ((CryptreeRepoTransport)toRepoTransport).beginPutFile(path, (SsNormalFileDto)fromNormalFileDto);
        } else {
            super.beginPutFile(fromRepoTransport, toRepoTransport, repoFileDtoTreeNode, path, fromNormalFileDto);
        }
    }

    protected byte[] getFileData(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, RepoFileDtoTreeNode repoFileDtoTreeNode, String path, FileChunkDto fileChunkDto) {
        byte[] fileDataNoPadding;
        SsFileChunkDto fcDto = (SsFileChunkDto)fileChunkDto;
        byte[] fileData = fromRepoTransport.getFileData(path, fileChunkDto.getOffset(), fileChunkDto.getLength());
        if (fileData == null) {
            return null;
        }
        if (toRepoTransport instanceof CryptreeRestRepoTransport) {
            fileDataNoPadding = fileData;
            fileData = PaddingUtil.addPadding(fileData, SsRepoToRepoSync.assertNotNegative(fcDto.getLengthWithPadding()) - fcDto.getLength());
        } else if (fromRepoTransport instanceof CryptreeRestRepoTransport) {
            fileDataNoPadding = fileData = PaddingUtil.removePadding(fileData);
        } else {
            throw new IllegalStateException("WTF?!");
        }
        if (fileDataNoPadding.length != fileChunkDto.getLength()) {
            return null;
        }
        if (fcDto.getLength() > 0 && !HashUtil.sha1((byte[])fileDataNoPadding).equals(fileChunkDto.getSha1())) {
            return null;
        }
        return fileData;
    }

    protected static int assertNotNegative(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value < 0");
        }
        return value;
    }

    protected void putFileData(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, RepoFileDtoTreeNode repoFileDtoTreeNode, String path, FileChunkDto fileChunkDto, byte[] fileData) {
        super.putFileData(fromRepoTransport, toRepoTransport, repoFileDtoTreeNode, path, fileChunkDto, fileData);
    }

    protected void endPutFile(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, RepoFileDtoTreeNode repoFileDtoTreeNode, String path, NormalFileDto fromNormalFileDto) {
        if (toRepoTransport instanceof CryptreeRestRepoTransport) {
            ((CryptreeRestRepoTransport)toRepoTransport).endPutFile(path, fromNormalFileDto);
        } else if (toRepoTransport instanceof CryptreeClientFileRepoTransport) {
            ((CryptreeClientFileRepoTransport)toRepoTransport).endPutFile(path, (SsNormalFileDto)fromNormalFileDto);
        } else {
            super.endPutFile(fromRepoTransport, toRepoTransport, repoFileDtoTreeNode, path, fromNormalFileDto);
        }
    }

    protected void makeDirectory(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, RepoFileDtoTreeNode repoFileDtoTreeNode, String path, DirectoryDto directoryDto) {
        super.makeDirectory(fromRepoTransport, toRepoTransport, repoFileDtoTreeNode, path, directoryDto);
    }

    protected void sync(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, ChangeSetDto changeSetDto, ProgressMonitor monitor) {
        if (this.isMetaOnly()) {
            if (fromRepoTransport instanceof CryptreeRestRepoTransport) {
                for (ModificationDto modificationDto : changeSetDto.getModificationDtos()) {
                    if (!(modificationDto instanceof DeleteModificationDto)) continue;
                    this.applyDeleteModification(fromRepoTransport, toRepoTransport, (DeleteModificationDto)modificationDto);
                }
            }
            return;
        }
        super.sync(fromRepoTransport, toRepoTransport, changeSetDto, monitor);
    }

    protected void sync(RepoTransport fromRepoTransport, RepoTransport toRepoTransport, RepoFileDtoTreeNode repoFileDtoTree, Class<?>[] repoFileDtoClassesIncl, Class<?>[] repoFileDtoClassesExcl, boolean filesInProgressOnly, ProgressMonitor monitor) {
        if (this.isMetaOnly()) {
            return;
        }
        super.sync(fromRepoTransport, toRepoTransport, repoFileDtoTree, (Class[])repoFileDtoClassesIncl, (Class[])repoFileDtoClassesExcl, filesInProgressOnly, monitor);
    }
}

