/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.auth.SignatureException;
import co.codewizards.cloudstore.core.config.Config;
import co.codewizards.cloudstore.core.dto.ConfigPropSetDto;
import co.codewizards.cloudstore.core.dto.RepoFileDto;
import co.codewizards.cloudstore.core.dto.jaxb.ConfigPropSetDtoIo;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.ISO8601;
import co.codewizards.cloudstore.core.util.PropertiesUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.local.dto.RepoFileDtoConverter;
import co.codewizards.cloudstore.local.persistence.Directory;
import co.codewizards.cloudstore.local.persistence.RemoteRepository;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryDao;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import co.codewizards.cloudstore.local.persistence.RepoFileDao;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.jdo.JDOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.AccessDeniedException;
import org.subshare.core.DataKey;
import org.subshare.core.GrantAccessDeniedException;
import org.subshare.core.ReadAccessDeniedException;
import org.subshare.core.ReadUserIdentityAccessDeniedException;
import org.subshare.core.WriteAccessDeniedException;
import org.subshare.core.crypto.CryptoConfigUtil;
import org.subshare.core.dto.CollisionPrivateDto;
import org.subshare.core.dto.CryptoKeyPart;
import org.subshare.core.dto.CryptoKeyRole;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.dto.PlainHistoCryptoRepoFileDto;
import org.subshare.core.dto.SignatureDto;
import org.subshare.core.dto.SsRepoFileDto;
import org.subshare.core.repo.local.CollisionFilter;
import org.subshare.core.sign.Signable;
import org.subshare.core.sign.Signature;
import org.subshare.core.sign.WriteProtected;
import org.subshare.core.user.UserRepoKey;
import org.subshare.crypto.CipherOperationMode;
import org.subshare.local.CryptreeContext;
import org.subshare.local.CryptreeNodeUtil;
import org.subshare.local.PlainCryptoKey;
import org.subshare.local.PlainCryptoKeyFactory;
import org.subshare.local.UserRepoKeyPublicKeyHelper;
import org.subshare.local.dto.CollisionDtoConverter;
import org.subshare.local.dto.CollisionPrivateDtoConverter;
import org.subshare.local.dto.HistoCryptoRepoFileDtoConverter;
import org.subshare.local.persistence.Collision;
import org.subshare.local.persistence.CollisionDao;
import org.subshare.local.persistence.CollisionPrivate;
import org.subshare.local.persistence.CollisionPrivateDao;
import org.subshare.local.persistence.CryptoConfigPropSet;
import org.subshare.local.persistence.CryptoConfigPropSetDao;
import org.subshare.local.persistence.CryptoKey;
import org.subshare.local.persistence.CryptoKeyDao;
import org.subshare.local.persistence.CryptoKeyDeactivation;
import org.subshare.local.persistence.CryptoLink;
import org.subshare.local.persistence.CryptoLinkDao;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.CryptoRepoFileDao;
import org.subshare.local.persistence.CurrentHistoCryptoRepoFile;
import org.subshare.local.persistence.CurrentHistoCryptoRepoFileDao;
import org.subshare.local.persistence.HistoCryptoRepoFile;
import org.subshare.local.persistence.HistoCryptoRepoFileDao;
import org.subshare.local.persistence.HistoFrame;
import org.subshare.local.persistence.HistoFrameDao;
import org.subshare.local.persistence.InvitationUserRepoKeyPublicKey;
import org.subshare.local.persistence.Permission;
import org.subshare.local.persistence.PermissionDao;
import org.subshare.local.persistence.PermissionSet;
import org.subshare.local.persistence.PermissionSetDao;
import org.subshare.local.persistence.PermissionSetInheritance;
import org.subshare.local.persistence.PlainHistoCryptoRepoFile;
import org.subshare.local.persistence.PlainHistoCryptoRepoFileDao;
import org.subshare.local.persistence.PreliminaryDeletion;
import org.subshare.local.persistence.PreliminaryDeletionDao;
import org.subshare.local.persistence.RepositoryOwner;
import org.subshare.local.persistence.UserIdentityLink;
import org.subshare.local.persistence.UserIdentityLinkDao;
import org.subshare.local.persistence.UserRepoKeyPublicKey;
import org.subshare.local.persistence.UserRepoKeyPublicKeyDao;
import org.subshare.local.persistence.UserRepoKeyPublicKeyReplacementRequestDao;

public class CryptreeNode {
    private static final Logger logger = LoggerFactory.getLogger(CryptreeNode.class);
    private static final Map<CryptoKeyRole, Class<? extends PlainCryptoKeyFactory>> cryptoKeyRole2PlainCryptoKeyFactory;
    private final CryptreeContext context;
    private CryptreeNode parent;
    private RepoFile repoFile;
    private CryptoRepoFile cryptoRepoFile;
    private PermissionSet permissionSet;
    private RepoFileDtoConverter repoFileDtoConverter;
    private final List<CryptreeNode> children = new ArrayList<CryptreeNode>(0);
    private boolean childrenLoaded = false;
    private final Set<Permission> permissionsBeingCheckedNow = new HashSet<Permission>();
    private final Set<Permission> permissionsAlreadyCheckedOk = new HashSet<Permission>();

    public CryptreeNode(CryptreeContext context, RepoFile repoFile) {
        this(context, repoFile, null);
    }

    public CryptreeNode(CryptreeContext context, CryptoRepoFile cryptoRepoFile) {
        this(context, null, cryptoRepoFile);
    }

    private CryptreeNode(CryptreeContext context, RepoFile repoFile, CryptoRepoFile cryptoRepoFile) {
        this(null, null, context, repoFile, cryptoRepoFile);
    }

    public CryptreeNode(CryptreeNode parent, CryptreeNode child, CryptreeContext context, RepoFile repoFile, CryptoRepoFile cryptoRepoFile) {
        if (parent == null && child == null && context == null) {
            throw new IllegalArgumentException("parent == null && child == null && context == null");
        }
        if (repoFile == null && cryptoRepoFile == null) {
            throw new IllegalArgumentException("repoFile == null && cryptoRepoFile == null");
        }
        this.parent = parent;
        this.context = context != null ? context : (parent != null ? parent.getContext() : child.getContext());
        this.repoFile = repoFile != null ? repoFile : cryptoRepoFile.getRepoFile();
        this.cryptoRepoFile = cryptoRepoFile;
        if (child != null) {
            this.children.add(child);
        }
    }

    public CryptreeContext getContext() {
        return this.context;
    }

    public RepoFile getRepoFile() {
        if (this.repoFile == null) {
            this.repoFile = this.getCryptoRepoFile().getRepoFile();
            if (this.repoFile == null) {
                this.getRepoFileDto();
            } else {
                this.context.registerCryptreeNode(this.repoFile, this);
            }
        }
        return this.repoFile;
    }

    public RepoFileDto getRepoFileDto() throws AccessDeniedException {
        CryptoRepoFile cryptoRepoFile = this.getCryptoRepoFile();
        if (cryptoRepoFile == null) {
            return null;
        }
        PlainCryptoKey plainCryptoKey = this.getPlainCryptoKeyForDecrypting(cryptoRepoFile.getCryptoKey());
        if (plainCryptoKey == null) {
            throw new ReadAccessDeniedException(String.format("The CryptoRepoFile with cryptoRepoFileId=%s could not be decrypted! Access rights missing?!", cryptoRepoFile.getCryptoRepoFileId()));
        }
        byte[] plainRepoFileDtoData = (byte[])AssertUtil.assertNotNull((Object)CryptreeNodeUtil.decrypt(cryptoRepoFile.getRepoFileDtoData(), plainCryptoKey), (String)"decrypt(...)");
        RepoFileDto repoFileDto = (RepoFileDto)this.context.repoFileDtoIo.deserializeWithGz(plainRepoFileDtoData);
        return repoFileDto;
    }

    public RepoFileDto getHistoCryptoRepoFileRepoFileDto(HistoCryptoRepoFile histoCryptoRepoFile) throws AccessDeniedException {
        AssertUtil.assertNotNull((Object)((Object)histoCryptoRepoFile), (String)"histoCryptoRepoFile");
        PlainCryptoKey plainCryptoKey = this.getPlainCryptoKeyForDecrypting(histoCryptoRepoFile.getCryptoKey());
        if (plainCryptoKey == null) {
            throw new ReadAccessDeniedException(String.format("The HistoCryptoRepoFile with histoCryptoRepoFileId=%s could not be decrypted! Access rights missing?!", histoCryptoRepoFile.getHistoCryptoRepoFileId()));
        }
        byte[] plainRepoFileDtoData = (byte[])AssertUtil.assertNotNull((Object)CryptreeNodeUtil.decrypt(histoCryptoRepoFile.getRepoFileDtoData(), plainCryptoKey), (String)"decrypt(...)");
        RepoFileDto repoFileDto = (RepoFileDto)this.context.repoFileDtoIo.deserializeWithGz(plainRepoFileDtoData);
        return repoFileDto;
    }

    public RepoFileDto getRepoFileDtoOnServer() throws AccessDeniedException {
        CurrentHistoCryptoRepoFile currentHistoCryptoRepoFile = this.getCurrentHistoCryptoRepoFile();
        if (currentHistoCryptoRepoFile == null) {
            return null;
        }
        HistoCryptoRepoFile histoCryptoRepoFile = currentHistoCryptoRepoFile.getHistoCryptoRepoFile();
        AssertUtil.assertNotNull((Object)((Object)histoCryptoRepoFile), (String)"currentHistoCryptoRepoFile.histoCryptoRepoFile");
        PlainCryptoKey plainCryptoKey = this.getPlainCryptoKeyForDecrypting(histoCryptoRepoFile.getCryptoKey());
        if (plainCryptoKey == null) {
            throw new ReadAccessDeniedException(String.format("The HistoCryptoRepoFile with cryptoRepoFileId=%s could not be decrypted! Access rights missing?!", histoCryptoRepoFile.getCryptoRepoFile().getCryptoRepoFileId()));
        }
        byte[] plainRepoFileDtoData = (byte[])AssertUtil.assertNotNull((Object)CryptreeNodeUtil.decrypt(histoCryptoRepoFile.getRepoFileDtoData(), plainCryptoKey), (String)"decrypt(...)");
        RepoFileDto repoFileDto = (RepoFileDto)this.context.repoFileDtoIo.deserializeWithGz(plainRepoFileDtoData);
        return repoFileDto;
    }

    public CryptoRepoFile getCryptoRepoFile() {
        if (this.cryptoRepoFile == null) {
            if (this.repoFile == null) {
                throw new IllegalStateException("repoFile == null && cryptoRepoFile == null");
            }
            CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)this.context.transaction.getDao(CryptoRepoFileDao.class));
            this.cryptoRepoFile = cryptoRepoFileDao.getCryptoRepoFile(this.repoFile);
            CryptreeNode parent = this.getParent();
            if (parent != null && this.cryptoRepoFile == null) {
                this.cryptoRepoFile = cryptoRepoFileDao.getChildCryptoRepoFile(parent.getCryptoRepoFile(), this.repoFile.getName());
            }
            if (this.cryptoRepoFile != null) {
                this.context.registerCryptreeNode(this.cryptoRepoFile, this);
            }
        }
        return this.cryptoRepoFile;
    }

    public CryptoRepoFile getCryptoRepoFileOrCreate(boolean update) {
        CryptoRepoFile cryptoRepoFile = this.getCryptoRepoFile();
        if (cryptoRepoFile == null || update) {
            CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)this.context.transaction.getDao(CryptoRepoFileDao.class));
            if (cryptoRepoFile == null) {
                cryptoRepoFile = new CryptoRepoFile();
                cryptoRepoFile.setSignature((Signature)new SignatureDto(new Date(0L), new Uid(0L, 0L), new byte[]{7}));
            } else {
                cryptoRepoFile.setDeleted(null);
                cryptoRepoFile.setDeletedByIgnoreRule(false);
                this.deletePreliminaryDeletions();
            }
            cryptoRepoFile.setRepoFile((RepoFile)AssertUtil.assertNotNull((Object)this.repoFile, (String)"repoFile"));
            cryptoRepoFile.setDirectory(this.repoFile instanceof Directory);
            this.cryptoRepoFile = cryptoRepoFile = (CryptoRepoFile)cryptoRepoFileDao.makePersistent(cryptoRepoFile);
            PlainCryptoKey plainCryptoKey = this.getActivePlainCryptoKeyOrCreate(CryptoKeyRole.dataKey, CipherOperationMode.ENCRYPT);
            CryptoKey cryptoKey = ((PlainCryptoKey)AssertUtil.assertNotNull((Object)plainCryptoKey, (String)"plainCryptoKey")).getCryptoKey();
            cryptoRepoFile.setCryptoKey((CryptoKey)((Object)AssertUtil.assertNotNull((Object)((Object)cryptoKey), (String)"plainCryptoKey.cryptoKey")));
            CryptreeNode parent = this.getParent();
            cryptoRepoFile.setParent(parent == null ? null : parent.getCryptoRepoFile());
            byte[] repoFileDtoData = this.createRepoFileDtoDataForCryptoRepoFile(false);
            cryptoRepoFile.setRepoFileDtoData((byte[])AssertUtil.assertNotNull((Object)CryptreeNodeUtil.encrypt(repoFileDtoData, plainCryptoKey), (String)"encrypt(...)"));
            cryptoRepoFile.setLastSyncFromRepositoryId(null);
            this.sign(cryptoRepoFile);
            this.context.transaction.flush();
            this.updateCryptoConfigPropSetIfConfigFile();
        }
        return cryptoRepoFile;
    }

    public CryptoConfigPropSet updateCryptoConfigPropSetIfConfigFile() {
        CryptoRepoFile cryptoRepoFile = (CryptoRepoFile)((Object)AssertUtil.assertNotNull((Object)((Object)this.getCryptoRepoFile()), (String)"cryptoRepoFile"));
        String localName = cryptoRepoFile.getLocalName();
        if (!Config.PROPERTIES_FILE_NAME_FOR_DIRECTORY.equals(localName)) {
            return null;
        }
        CryptreeNode parent = (CryptreeNode)AssertUtil.assertNotNull((Object)this.getParent(), (String)"parent");
        CryptoRepoFile parentCrf = parent.getCryptoRepoFileOrCreate(false);
        CryptoConfigPropSetDao ccpsDao = (CryptoConfigPropSetDao)((Object)this.context.transaction.getDao(CryptoConfigPropSetDao.class));
        CryptoConfigPropSet cryptoConfigPropSet = ccpsDao.getCryptoConfigPropSet(parentCrf);
        if (cryptoConfigPropSet == null) {
            cryptoConfigPropSet = new CryptoConfigPropSet(parentCrf);
        }
        PlainCryptoKey plainCryptoKey = parent.getActivePlainCryptoKeyOrCreate(CryptoKeyRole.dataKey, CipherOperationMode.ENCRYPT);
        CryptoKey cryptoKey = ((PlainCryptoKey)AssertUtil.assertNotNull((Object)plainCryptoKey, (String)"plainCryptoKey")).getCryptoKey();
        cryptoConfigPropSet.setCryptoKey((CryptoKey)((Object)AssertUtil.assertNotNull((Object)((Object)cryptoKey), (String)"plainCryptoKey.cryptoKey")));
        byte[] plainData = this.createConfigPropSetDtoDataFromFile();
        cryptoConfigPropSet.setConfigPropSetDtoData(plainData == null ? null : CryptreeNodeUtil.encrypt(plainData, plainCryptoKey));
        cryptoConfigPropSet.setLastSyncFromRepositoryId(null);
        parent.sign(cryptoConfigPropSet);
        cryptoConfigPropSet = (CryptoConfigPropSet)ccpsDao.makePersistent(cryptoConfigPropSet);
        this.context.transaction.flush();
        return cryptoConfigPropSet;
    }

    private byte[] createConfigPropSetDtoDataFromFile() {
        ConfigPropSetDto configPropSetDto = this.createConfigPropSetDtoFromFile();
        if (configPropSetDto == null) {
            return null;
        }
        return new ConfigPropSetDtoIo().serializeWithGz((Object)configPropSetDto);
    }

    private ConfigPropSetDto createConfigPropSetDtoFromFile() {
        Properties properties;
        if (this.getCryptoRepoFile().getDeleted() != null) {
            return null;
        }
        RepoFile repoFile = (RepoFile)AssertUtil.assertNotNull((Object)this.getRepoFile(), (String)"repoFile");
        File configFile = repoFile.getFile(this.context.transaction.getLocalRepoManager().getLocalRoot());
        if (!configFile.isFile()) {
            logger.warn("createConfigPropSetDtoFromFile: configFile not existing (deleted after local-sync?!): {}", (Object)configFile);
            return null;
        }
        try {
            properties = PropertiesUtil.load((File)configFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ConfigPropSetDto(properties);
    }

    public CurrentHistoCryptoRepoFile getCurrentHistoCryptoRepoFile() {
        CryptoRepoFile cryptoRepoFile = this.getCryptoRepoFile();
        if (cryptoRepoFile == null) {
            return null;
        }
        CurrentHistoCryptoRepoFileDao chcrfDao = (CurrentHistoCryptoRepoFileDao)((Object)this.context.transaction.getDao(CurrentHistoCryptoRepoFileDao.class));
        CurrentHistoCryptoRepoFile currentHistoCryptoRepoFile = chcrfDao.getCurrentHistoCryptoRepoFile(cryptoRepoFile);
        return currentHistoCryptoRepoFile;
    }

    public HistoCryptoRepoFile createHistoCryptoRepoFileIfNeeded() {
        CryptoRepoFile cryptoRepoFile = this.getCryptoRepoFileOrCreate(false);
        AssertUtil.assertNotNull((Object)((Object)cryptoRepoFile), (String)"cryptoRepoFile");
        CurrentHistoCryptoRepoFileDao chcrfDao = (CurrentHistoCryptoRepoFileDao)((Object)this.context.transaction.getDao(CurrentHistoCryptoRepoFileDao.class));
        HistoCryptoRepoFileDao hcrfDao = (HistoCryptoRepoFileDao)((Object)this.context.transaction.getDao(HistoCryptoRepoFileDao.class));
        HistoFrameDao hfDao = (HistoFrameDao)((Object)this.context.transaction.getDao(HistoFrameDao.class));
        HistoFrame histoFrame = hfDao.getUnsealedHistoFrameOrFail(this.context.localRepositoryId);
        CurrentHistoCryptoRepoFile currentHistoCryptoRepoFile = chcrfDao.getCurrentHistoCryptoRepoFile(cryptoRepoFile);
        if (currentHistoCryptoRepoFile == null) {
            currentHistoCryptoRepoFile = new CurrentHistoCryptoRepoFile();
            currentHistoCryptoRepoFile.setCryptoRepoFile(cryptoRepoFile);
        }
        HistoCryptoRepoFile previousHistoCryptoRepoFile = currentHistoCryptoRepoFile.getHistoCryptoRepoFile();
        HistoCryptoRepoFile histoCryptoRepoFile = null;
        Collection<HistoCryptoRepoFile> histoCryptoRepoFiles = hcrfDao.getHistoCryptoRepoFiles(cryptoRepoFile);
        for (HistoCryptoRepoFile hcrf : histoCryptoRepoFiles) {
            if (!histoFrame.equals((Object)hcrf.getHistoFrame())) continue;
            histoCryptoRepoFile = hcrf;
        }
        if (histoCryptoRepoFile == null) {
            histoCryptoRepoFile = new HistoCryptoRepoFile();
            histoCryptoRepoFile.setCryptoRepoFile(cryptoRepoFile);
            histoCryptoRepoFile.setPreviousHistoCryptoRepoFile(previousHistoCryptoRepoFile);
            histoCryptoRepoFile.setHistoFrame(histoFrame);
            Date deleted = cryptoRepoFile.getDeleted();
            histoCryptoRepoFile.setDeleted(deleted);
            histoCryptoRepoFile.setDeletedByIgnoreRule(cryptoRepoFile.isDeletedByIgnoreRule());
            PlainCryptoKey plainCryptoKey = this.getActivePlainCryptoKeyOrCreate(CryptoKeyRole.dataKey, CipherOperationMode.ENCRYPT);
            CryptoKey cryptoKey = ((PlainCryptoKey)AssertUtil.assertNotNull((Object)plainCryptoKey, (String)"plainCryptoKey")).getCryptoKey();
            histoCryptoRepoFile.setCryptoKey((CryptoKey)((Object)AssertUtil.assertNotNull((Object)((Object)cryptoKey), (String)"plainCryptoKey.cryptoKey")));
            if (!cryptoKey.equals((Object)cryptoRepoFile.getCryptoKey())) {
                throw new IllegalStateException(String.format("cryptoKey != cryptoRepoFile.cryptoKey :: %s != %s", new Object[]{cryptoKey, cryptoRepoFile.getCryptoKey()}));
            }
            byte[] repoFileDtoData = deleted != null ? this.context.repoFileDtoIo.serializeWithGz(AssertUtil.assertNotNull((Object)this.getRepoFileDto(), (String)"getRepoFileDto()")) : this.createRepoFileDtoDataForCryptoRepoFile(true);
            histoCryptoRepoFile.setRepoFileDtoData((byte[])AssertUtil.assertNotNull((Object)CryptreeNodeUtil.encrypt(repoFileDtoData, plainCryptoKey), (String)"encrypt(...)"));
            histoCryptoRepoFile.setLastSyncFromRepositoryId(null);
            this.sign(histoCryptoRepoFile);
            histoCryptoRepoFile = (HistoCryptoRepoFile)hcrfDao.makePersistent(histoCryptoRepoFile);
        }
        currentHistoCryptoRepoFile.setHistoCryptoRepoFile(histoCryptoRepoFile);
        currentHistoCryptoRepoFile.setLastSyncFromRepositoryId(null);
        this.sign(currentHistoCryptoRepoFile);
        chcrfDao.makePersistent(currentHistoCryptoRepoFile);
        this.updatePlainHistoCryptoRepoFile(histoCryptoRepoFile);
        this.context.transaction.flush();
        return histoCryptoRepoFile;
    }

    public Collision createCollisionIfNeeded(CryptoRepoFile duplicateCryptoRepoFile, String localPath, boolean expectedSealedStatus) {
        LocalRepoTransaction tx = this.context.transaction;
        CryptoRepoFile cryptoRepoFile = this.getCryptoRepoFile();
        CollisionDao cDao = (CollisionDao)((Object)tx.getDao(CollisionDao.class));
        HistoCryptoRepoFileDao hcrfDao = (HistoCryptoRepoFileDao)((Object)tx.getDao(HistoCryptoRepoFileDao.class));
        Collection<HistoCryptoRepoFile> histoCryptoRepoFiles = hcrfDao.getHistoCryptoRepoFiles(cryptoRepoFile);
        HistoCryptoRepoFile localHistoCryptoRepoFile = this.getLastHistoCryptoRepoFile(histoCryptoRepoFiles, false);
        HistoCryptoRepoFile remoteHistoCryptoRepoFile = this.getLastHistoCryptoRepoFile(histoCryptoRepoFiles, true);
        if (localHistoCryptoRepoFile != null) {
            if (localHistoCryptoRepoFile.getHistoFrame().getSealed() != null && !expectedSealedStatus) {
                IllegalStateException x = new IllegalStateException(String.format("Why is the local HistoFrame already sealed?!???!!! cryptoRepoFile=%s duplicateCryptoRepoFile=%s localPath=%s localHistoCryptoRepoFile=%s remoteHistoCryptoRepoFile=%s", new Object[]{cryptoRepoFile, duplicateCryptoRepoFile, localPath, localHistoCryptoRepoFile, remoteHistoCryptoRepoFile}));
                logger.warn("createCollisionIfNeeded: " + x.toString(), (Throwable)x);
            }
            if (localHistoCryptoRepoFile.getHistoFrame().getSealed() == null && expectedSealedStatus) {
                throw new IllegalStateException("Why is the local HistoFrame not yet sealed?!???!!!");
            }
        }
        HistoCryptoRepoFile histoCryptoRepoFile1 = localHistoCryptoRepoFile;
        HistoCryptoRepoFile histoCryptoRepoFile2 = remoteHistoCryptoRepoFile;
        if (histoCryptoRepoFile1 == null) {
            histoCryptoRepoFile1 = histoCryptoRepoFile2;
            histoCryptoRepoFile2 = null;
        }
        AssertUtil.assertNotNull((Object)((Object)histoCryptoRepoFile1), (String)"histoCryptoRepoFile1", (String)"cryptoRepoFile=%s duplicateCryptoRepoFile=%s localPath=%s localHistoCryptoRepoFile=%s remoteHistoCryptoRepoFile=%s", (Object[])new Object[]{cryptoRepoFile, duplicateCryptoRepoFile, localPath, localHistoCryptoRepoFile, remoteHistoCryptoRepoFile});
        if (duplicateCryptoRepoFile != null) {
            if (duplicateCryptoRepoFile.getCryptoRepoFileId().equals((Object)CryptreeNode.getCryptoRepoFileId(histoCryptoRepoFile1))) {
                histoCryptoRepoFile1 = histoCryptoRepoFile2;
                histoCryptoRepoFile2 = null;
            } else if (histoCryptoRepoFile2 == null || duplicateCryptoRepoFile.getCryptoRepoFileId().equals((Object)CryptreeNode.getCryptoRepoFileId(histoCryptoRepoFile2))) {
                histoCryptoRepoFile2 = null;
            } else {
                if (histoCryptoRepoFile1.getSignature().getSignatureCreated().before(histoCryptoRepoFile2.getSignature().getSignatureCreated())) {
                    histoCryptoRepoFile1 = histoCryptoRepoFile2;
                }
                histoCryptoRepoFile2 = null;
            }
            if (duplicateCryptoRepoFile.getCryptoRepoFileId().equals((Object)CryptreeNode.getCryptoRepoFileId(histoCryptoRepoFile1))) {
                throw new IllegalStateException("duplicateCryptoRepoFile matches histoCryptoRepoFile1!\nduplicateCryptoRepoFile=" + (Object)((Object)duplicateCryptoRepoFile) + "\nhistoCryptoRepoFile1=" + (Object)((Object)histoCryptoRepoFile1) + "\nhistoCryptoRepoFile2=" + (Object)((Object)histoCryptoRepoFile2));
            }
        } else if (histoCryptoRepoFile2 == null) {
            IllegalStateException x = new IllegalStateException(String.format("duplicateCryptoRepoFile and histoCryptoRepoFile2 are both null!!! cryptoRepoFile=%s localPath=%s localHistoCryptoRepoFile=%s remoteHistoCryptoRepoFile=%s", new Object[]{cryptoRepoFile, localPath, localHistoCryptoRepoFile, remoteHistoCryptoRepoFile}));
            logger.warn("createCollisionIfNeeded: " + x.toString(), (Throwable)x);
            return null;
        }
        AssertUtil.assertNotNull((Object)((Object)histoCryptoRepoFile1), (String)"histoCryptoRepoFile1");
        Uid duplicateCryptoRepoFileId = duplicateCryptoRepoFile == null ? null : duplicateCryptoRepoFile.getCryptoRepoFileId();
        Collision collision = cDao.getCollision(histoCryptoRepoFile1, histoCryptoRepoFile2, duplicateCryptoRepoFileId);
        if (collision == null) {
            collision = new Collision();
            collision.setHistoCryptoRepoFile1(histoCryptoRepoFile1);
            collision.setHistoCryptoRepoFile2(histoCryptoRepoFile2);
            collision.setDuplicateCryptoRepoFileId(duplicateCryptoRepoFileId);
            this.putCollisionPrivateDto(collision, new CollisionPrivateDto());
            collision = (Collision)cDao.makePersistent(collision);
            logger.info("createCollisionIfNeeded: localPath='{}' histoCryptoRepoFile1={} histoCryptoRepoFile2={} duplicateCryptoRepoFileId={} localRevision={}", new Object[]{localPath, histoCryptoRepoFile1, histoCryptoRepoFile2, duplicateCryptoRepoFileId, collision.getLocalRevision()});
        }
        this.updateCollisionPrivate(collision);
        this.context.transaction.flush();
        return collision;
    }

    public void putCollisionPrivateDto(Collision collision, CollisionPrivateDto collisionPrivateDto) {
        AssertUtil.assertNotNull((Object)((Object)collision), (String)"collision");
        AssertUtil.assertNotNull((Object)collisionPrivateDto, (String)"collisionPrivateDto");
        if (collisionPrivateDto.getCollisionId() == null) {
            collisionPrivateDto.setCollisionId(collision.getCollisionId());
        } else if (!collisionPrivateDto.getCollisionId().equals((Object)collision.getCollisionId())) {
            throw new IllegalArgumentException("collisionPrivateDto.collisionId != collision.collisionId");
        }
        PlainCryptoKey plainCryptoKey = this.getActivePlainCryptoKeyOrCreate(CryptoKeyRole.dataKey, CipherOperationMode.ENCRYPT);
        CryptoKey cryptoKey = ((PlainCryptoKey)AssertUtil.assertNotNull((Object)plainCryptoKey, (String)"plainCryptoKey")).getCryptoKey();
        collision.setCryptoKey((CryptoKey)((Object)AssertUtil.assertNotNull((Object)((Object)cryptoKey), (String)"plainCryptoKey.cryptoKey")));
        byte[] data = this.context.collisionPrivateDtoIo.serializeWithGz((Object)collisionPrivateDto);
        collision.setCollisionPrivateDtoData((byte[])AssertUtil.assertNotNull((Object)CryptreeNodeUtil.encrypt(data, plainCryptoKey), (String)"encrypt(...)"));
        this.sign(collision);
        this.updateCollisionPrivate(collision);
    }

    public CollisionPrivateDto getCollisionPrivateDto(Collision collision) {
        AssertUtil.assertNotNull((Object)((Object)collision), (String)"collision");
        PlainCryptoKey plainCryptoKey = this.getPlainCryptoKeyForDecrypting(collision.getCryptoKey());
        if (plainCryptoKey == null) {
            throw new ReadAccessDeniedException(String.format("The Collision with collisionId=%s could not be decrypted! Access rights missing?!", collision.getCollisionId()));
        }
        byte[] plainDtoData = (byte[])AssertUtil.assertNotNull((Object)CryptreeNodeUtil.decrypt(collision.getCollisionPrivateDtoData(), plainCryptoKey), (String)"decrypt(...)");
        CollisionPrivateDto collisionPrivateDto = (CollisionPrivateDto)this.context.collisionPrivateDtoIo.deserializeWithGz(plainDtoData);
        return collisionPrivateDto;
    }

    private static Uid getCryptoRepoFileId(HistoCryptoRepoFile histoCryptoRepoFile) {
        if (histoCryptoRepoFile == null) {
            return null;
        }
        return histoCryptoRepoFile.getCryptoRepoFile().getCryptoRepoFileId();
    }

    private HistoCryptoRepoFile getLastHistoCryptoRepoFile(Collection<HistoCryptoRepoFile> histoCryptoRepoFiles, boolean remote) {
        AssertUtil.assertNotNull(histoCryptoRepoFiles, (String)"histoCryptoRepoFiles");
        UUID localRepositoryId = this.context.transaction.getLocalRepoManager().getRepositoryId();
        HistoCryptoRepoFile result = null;
        for (HistoCryptoRepoFile histoCryptoRepoFile : histoCryptoRepoFiles) {
            HistoFrame histoFrame = histoCryptoRepoFile.getHistoFrame();
            if (!remote ? !localRepositoryId.equals(histoFrame.getFromRepositoryId()) : localRepositoryId.equals(histoFrame.getFromRepositoryId())) continue;
            if (result != null && result.getSignature().getSignatureCreated().compareTo(histoCryptoRepoFile.getSignature().getSignatureCreated()) >= 0) continue;
            result = histoCryptoRepoFile;
        }
        return result;
    }

    public CollisionPrivate updateCollisionPrivate(Collision collision) {
        AssertUtil.assertNotNull((Object)((Object)collision), (String)"collision");
        if (!this.getCryptoRepoFile().equals((Object)collision.getHistoCryptoRepoFile1().getCryptoRepoFile())) {
            throw new IllegalArgumentException("this.cryptoRepoFile != collision.histoCryptoRepoFile1.cryptoRepoFile");
        }
        CollisionPrivateDao cpDao = (CollisionPrivateDao)((Object)this.getContext().transaction.getDao(CollisionPrivateDao.class));
        CollisionPrivate cp = cpDao.getCollisionPrivate(collision);
        CollisionPrivateDto collisionPrivateDto = this.tryDecryptCollisionPrivateDto(collision);
        if (collisionPrivateDto == null) {
            if (cp != null) {
                cpDao.deletePersistent(cp);
            }
        } else {
            cp = CollisionPrivateDtoConverter.create(this.getContext().transaction).putCollisionPrivateDto(collision, collisionPrivateDto);
        }
        this.updatePlainHistoCryptoRepoFile(collision.getHistoCryptoRepoFile1());
        if (collision.getHistoCryptoRepoFile2() != null) {
            this.getContext().getCryptreeNodeOrCreate(collision.getHistoCryptoRepoFile2().getCryptoRepoFile().getCryptoRepoFileId()).updatePlainHistoCryptoRepoFile(collision.getHistoCryptoRepoFile2());
        }
        return cp;
    }

    public PlainHistoCryptoRepoFile updatePlainHistoCryptoRepoFile(HistoCryptoRepoFile histoCryptoRepoFile) {
        AssertUtil.assertNotNull((Object)((Object)histoCryptoRepoFile), (String)"histoCryptoRepoFile");
        PlainHistoCryptoRepoFileDao phcrfDao = (PlainHistoCryptoRepoFileDao)((Object)this.getContext().transaction.getDao(PlainHistoCryptoRepoFileDao.class));
        PlainHistoCryptoRepoFile phcrf = phcrfDao.getPlainHistoCryptoRepoFile(histoCryptoRepoFile);
        if (phcrf == null) {
            phcrf = new PlainHistoCryptoRepoFile();
            phcrf.setHistoCryptoRepoFile(histoCryptoRepoFile);
        }
        phcrf.setPlainHistoCryptoRepoFileDto(this.createPlainHistoCryptoRepoFileDto(histoCryptoRepoFile));
        phcrf = (PlainHistoCryptoRepoFile)phcrfDao.makePersistent(phcrf);
        return phcrf;
    }

    private PlainHistoCryptoRepoFileDto createPlainHistoCryptoRepoFileDto(HistoCryptoRepoFile histoCryptoRepoFile) {
        AssertUtil.assertNotNull((Object)((Object)histoCryptoRepoFile), (String)"histoCryptoRepoFile");
        HistoCryptoRepoFileDtoConverter converter = HistoCryptoRepoFileDtoConverter.create(this.getContext().transaction);
        PlainHistoCryptoRepoFileDto plainHistoCryptoRepoFileDto = new PlainHistoCryptoRepoFileDto();
        plainHistoCryptoRepoFileDto.setHistoCryptoRepoFileDto(converter.toHistoCryptoRepoFileDto(histoCryptoRepoFile));
        Uid cryptoRepoFileId = histoCryptoRepoFile.getCryptoRepoFile().getCryptoRepoFileId();
        plainHistoCryptoRepoFileDto.setCryptoRepoFileId(cryptoRepoFileId);
        CryptoRepoFile parentCryptoRepoFile = histoCryptoRepoFile.getCryptoRepoFile().getParent();
        plainHistoCryptoRepoFileDto.setParentCryptoRepoFileId(parentCryptoRepoFile == null ? null : parentCryptoRepoFile.getCryptoRepoFileId());
        RepoFileDto repoFileDto = this.tryDecryptHistoCryptoRepoFile(histoCryptoRepoFile);
        plainHistoCryptoRepoFileDto.setRepoFileDto(repoFileDto);
        if (histoCryptoRepoFile.getDeleted() != null) {
            plainHistoCryptoRepoFileDto.setAction(PlainHistoCryptoRepoFileDto.Action.DELETE);
        } else if (histoCryptoRepoFile.getPreviousHistoCryptoRepoFile() == null || histoCryptoRepoFile.getPreviousHistoCryptoRepoFile().getDeleted() != null) {
            plainHistoCryptoRepoFileDto.setAction(PlainHistoCryptoRepoFileDto.Action.ADD);
        } else {
            plainHistoCryptoRepoFileDto.setAction(PlainHistoCryptoRepoFileDto.Action.MODIFY);
        }
        this.populateCollisionDtos(plainHistoCryptoRepoFileDto, histoCryptoRepoFile);
        return plainHistoCryptoRepoFileDto;
    }

    private void populateCollisionDtos(PlainHistoCryptoRepoFileDto plainHistoCryptoRepoFileDto, HistoCryptoRepoFile histoCryptoRepoFile) {
        AssertUtil.assertNotNull((Object)((Object)histoCryptoRepoFile), (String)"histoCryptoRepoFile");
        CollisionDao cDao = (CollisionDao)((Object)this.getContext().transaction.getDao(CollisionDao.class));
        CollisionPrivateDao cpDao = (CollisionPrivateDao)((Object)this.getContext().transaction.getDao(CollisionPrivateDao.class));
        CollisionDtoConverter collisionDtoConverter = CollisionDtoConverter.create(this.getContext().transaction);
        CollisionPrivateDtoConverter cpDtoConverter = CollisionPrivateDtoConverter.create(this.getContext().transaction);
        CollisionFilter collisionFilter = new CollisionFilter();
        collisionFilter.setHistoCryptoRepoFileId(histoCryptoRepoFile.getHistoCryptoRepoFileId());
        Collection<Collision> collisions = cDao.getCollisions(collisionFilter);
        for (Collision collision : collisions) {
            plainHistoCryptoRepoFileDto.getCollisionDtos().add(collisionDtoConverter.toCollisionDto(collision));
            CollisionPrivate collisionPrivate = cpDao.getCollisionPrivate(collision);
            if (collisionPrivate == null) continue;
            plainHistoCryptoRepoFileDto.getCollisionPrivateDtos().add(cpDtoConverter.toCollisionPrivateDto(collisionPrivate));
        }
    }

    private RepoFileDto tryDecryptHistoCryptoRepoFile(HistoCryptoRepoFile histoCryptoRepoFile) {
        AssertUtil.assertNotNull((Object)((Object)histoCryptoRepoFile), (String)"histoCryptoRepoFile");
        RepoFileDto repoFileDto = null;
        try {
            repoFileDto = this.getHistoCryptoRepoFileRepoFileDto(histoCryptoRepoFile);
        }
        catch (ReadAccessDeniedException x) {
            if (logger.isDebugEnabled()) {
                logger.info("tryDecryptHistoCryptoRepoFile: " + (Object)((Object)x), (Throwable)x);
            }
            logger.info("tryDecryptHistoCryptoRepoFile: " + (Object)((Object)x));
        }
        return repoFileDto;
    }

    private CollisionPrivateDto tryDecryptCollisionPrivateDto(Collision collision) {
        AssertUtil.assertNotNull((Object)((Object)collision), (String)"collision");
        CollisionPrivateDto collisionPrivateDto = null;
        try {
            collisionPrivateDto = this.getCollisionPrivateDto(collision);
        }
        catch (ReadAccessDeniedException x) {
            if (logger.isDebugEnabled()) {
                logger.info("tryDecryptCollisionPrivateDto: " + (Object)((Object)x), (Throwable)x);
            }
            logger.info("tryDecryptCollisionPrivateDto: " + (Object)((Object)x));
        }
        return collisionPrivateDto;
    }

    private void grantReadPermission(UserRepoKey.PublicKey publicKey) {
        AssertUtil.assertNotNull((Object)publicKey, (String)"publicKey");
        CryptoLinkDao cryptoLinkDao = (CryptoLinkDao)((Object)this.context.transaction.getDao(CryptoLinkDao.class));
        Collection<CryptoLink> cryptoLinks = cryptoLinkDao.getActiveCryptoLinks(this.getCryptoRepoFileOrCreate(false), CryptoKeyRole.clearanceKey, CryptoKeyPart.privateKey);
        if (this.containsFromUserRepoKeyId(cryptoLinks, Collections.singleton(publicKey.getUserRepoKeyId()))) {
            return;
        }
        PlainCryptoKey plainCryptoKey = this.getActivePlainCryptoKeyOrCreate(CryptoKeyRole.clearanceKey, CipherOperationMode.DECRYPT);
        CryptreeNodeUtil.createCryptoLink(this, this.getUserRepoKeyPublicKeyOrCreate(publicKey), plainCryptoKey);
    }

    private RepoFileDtoConverter getRepoFileDtoConverter() {
        if (this.repoFileDtoConverter == null) {
            this.repoFileDtoConverter = RepoFileDtoConverter.create((LocalRepoTransaction)this.context.transaction);
        }
        this.repoFileDtoConverter.setExcludeLocalIds(false);
        this.repoFileDtoConverter.setExcludeMutableData(false);
        return this.repoFileDtoConverter;
    }

    private byte[] createRepoFileDtoDataForCryptoRepoFile(boolean forHisto) {
        RepoFileDtoConverter repoFileDtoConverter = this.getRepoFileDtoConverter();
        repoFileDtoConverter.setExcludeLocalIds(true);
        repoFileDtoConverter.setExcludeMutableData(!forHisto);
        RepoFileDto repoFileDto = repoFileDtoConverter.toRepoFileDto(this.repoFile, forHisto ? Integer.MAX_VALUE : 0);
        ((SsRepoFileDto)repoFileDto).setParentName(null);
        if (((SsRepoFileDto)repoFileDto).getSignature() != null) {
            throw new IllegalStateException("repoFileDto.signature != null");
        }
        if (this.cryptoRepoFile.getLocalName() == null || this.repoFile.getParent() != null) {
            this.cryptoRepoFile.setLocalName(repoFileDto.getName());
        } else {
            repoFileDto.setName(this.cryptoRepoFile.getLocalName());
        }
        return this.context.repoFileDtoIo.serializeWithGz((Object)repoFileDto);
    }

    private void revokeReadPermission(Set<Uid> userRepoKeyIds) {
        AssertUtil.assertNotNull(userRepoKeyIds, (String)"userRepoKeyIds");
        if (userRepoKeyIds.isEmpty()) {
            return;
        }
        CryptoRepoFile cryptoRepoFile = this.getCryptoRepoFile();
        if (cryptoRepoFile == null) {
            return;
        }
        CryptoLinkDao cryptoLinkDao = (CryptoLinkDao)((Object)this.context.transaction.getDao(CryptoLinkDao.class));
        Collection<CryptoLink> cryptoLinks = cryptoLinkDao.getActiveCryptoLinks(cryptoRepoFile, CryptoKeyRole.clearanceKey, CryptoKeyPart.privateKey);
        if (!this.containsFromUserRepoKeyId(cryptoLinks, userRepoKeyIds)) {
            return;
        }
        HashSet<CryptoKey> processedCryptoKeys = new HashSet<CryptoKey>();
        for (CryptoLink cryptoLink : cryptoLinks) {
            this.deactivateCryptoKeyAndDescendants(cryptoLink.getToCryptoKey(), processedCryptoKeys);
        }
        this.context.transaction.flush();
        PlainCryptoKey clearanceKeyPlainCryptoKey = null;
        for (CryptoLink cryptoLink : cryptoLinks) {
            UserRepoKeyPublicKey fromUserRepoKeyPublicKey = cryptoLink.getFromUserRepoKeyPublicKey();
            Uid fromUserRepoKeyId = fromUserRepoKeyPublicKey == null ? null : fromUserRepoKeyPublicKey.getUserRepoKeyId();
            if (fromUserRepoKeyId == null || userRepoKeyIds.contains(fromUserRepoKeyId)) continue;
            if (clearanceKeyPlainCryptoKey == null) {
                clearanceKeyPlainCryptoKey = this.getActivePlainCryptoKeyOrCreate(CryptoKeyRole.clearanceKey, CipherOperationMode.DECRYPT);
            }
            if (fromUserRepoKeyPublicKey != null && !cryptoLinkDao.getActiveCryptoLinks(cryptoRepoFile, CryptoKeyRole.clearanceKey, CryptoKeyPart.privateKey, fromUserRepoKeyPublicKey).isEmpty()) continue;
            CryptreeNodeUtil.createCryptoLink(this, fromUserRepoKeyPublicKey, clearanceKeyPlainCryptoKey);
        }
        if (clearanceKeyPlainCryptoKey != null) {
            this.createBacklinkKeyForFile();
        }
        this.createSubdirKeyAndBacklinkKeyIfNeededChildrenRecursively();
    }

    private void createBacklinkKeyForFile() {
        if (!this.isDirectory()) {
            this.getActivePlainCryptoKeyOrCreate(CryptoKeyRole.backlinkKey, CipherOperationMode.DECRYPT);
        }
    }

    private void deactivateCryptoKeyAndDescendants(CryptoKey cryptoKey, Set<CryptoKey> processedCryptoKeys) {
        if (!processedCryptoKeys.add(cryptoKey)) {
            return;
        }
        if (cryptoKey.getCryptoKeyDeactivation() == null) {
            this.deactivateCryptoKey(cryptoKey);
        }
        for (CryptoLink cryptoLink : cryptoKey.getOutCryptoLinks()) {
            this.deactivateCryptoKeyAndDescendants(cryptoLink.getToCryptoKey(), processedCryptoKeys);
        }
    }

    private void deactivateCryptoKey(CryptoKey cryptoKey) {
        CryptoKeyDeactivation cryptoKeyDeactivation = new CryptoKeyDeactivation();
        cryptoKeyDeactivation.setCryptoKey(cryptoKey);
        this.sign(cryptoKeyDeactivation);
        cryptoKey.setCryptoKeyDeactivation(cryptoKeyDeactivation);
        cryptoKey.setLastSyncFromRepositoryId(null);
    }

    private void createSubdirKeyAndBacklinkKeyIfNeededChildrenRecursively() {
        if (!this.isDirectory()) {
            return;
        }
        this.getActivePlainCryptoKeyOrCreate(CryptoKeyRole.subdirKey, CipherOperationMode.DECRYPT);
        this.getActivePlainCryptoKeyOrCreate(CryptoKeyRole.backlinkKey, CipherOperationMode.DECRYPT);
        for (CryptreeNode child : this.getChildren()) {
            child.createSubdirKeyAndBacklinkKeyIfNeededChildrenRecursively();
        }
    }

    private boolean containsFromUserRepoKeyId(Collection<CryptoLink> cryptoLinks, Set<Uid> fromUserRepoKeyIds) {
        AssertUtil.assertNotNull(cryptoLinks, (String)"cryptoLinks");
        AssertUtil.assertNotNull(fromUserRepoKeyIds, (String)"fromUserRepoKeyIds");
        for (CryptoLink cryptoLink : cryptoLinks) {
            UserRepoKeyPublicKey fromUserRepoKeyPublicKey = cryptoLink.getFromUserRepoKeyPublicKey();
            Uid fromUserRepoKeyId = fromUserRepoKeyPublicKey == null ? null : fromUserRepoKeyPublicKey.getUserRepoKeyId();
            if (fromUserRepoKeyId == null || !fromUserRepoKeyIds.contains(fromUserRepoKeyId)) continue;
            return true;
        }
        return false;
    }

    public Collection<CryptreeNode> getChildren() {
        if (!this.childrenLoaded) {
            if (this.cryptoRepoFile != null) {
                CryptoRepoFileDao dao = (CryptoRepoFileDao)((Object)this.context.transaction.getDao(CryptoRepoFileDao.class));
                Collection<CryptoRepoFile> childCryptoRepoFiles = dao.getChildCryptoRepoFiles(this.cryptoRepoFile);
                for (CryptoRepoFile childCryptoRepoFile : childCryptoRepoFiles) {
                    this.children.add(this.context.getCryptreeNodeOrCreate(this, null, null, childCryptoRepoFile));
                }
            } else if (this.repoFile != null) {
                RepoFileDao dao = (RepoFileDao)this.context.transaction.getDao(RepoFileDao.class);
                Collection childRepoFiles = dao.getChildRepoFiles(this.repoFile);
                for (RepoFile childRepoFile : childRepoFiles) {
                    this.children.add(this.context.getCryptreeNodeOrCreate(this, null, childRepoFile, null));
                }
            } else {
                throw new IllegalStateException("repoFile == null && cryptoRepoFile == null");
            }
            this.childrenLoaded = true;
        }
        return Collections.unmodifiableList(this.children);
    }

    protected boolean isDirectory() {
        if (this.repoFile != null) {
            return this.repoFile instanceof Directory;
        }
        return this.cryptoRepoFile.isDirectory();
    }

    protected PlainCryptoKey getActivePlainCryptoKey(CryptoKeyRole toCryptoKeyRole, CipherOperationMode cipherOperationMode) {
        CryptoKeyPart[] toCryptoKeyParts;
        AssertUtil.assertNotNull((Object)toCryptoKeyRole, (String)"toCryptoKeyRole");
        AssertUtil.assertNotNull((Object)cipherOperationMode, (String)"cipherOperationMode");
        logger.debug("getActivePlainCryptoKey: cryptoRepoFile={} repoFile={} toCryptoKeyRole={} cipherOperationMode={}", new Object[]{this.cryptoRepoFile, this.repoFile, toCryptoKeyRole, cipherOperationMode});
        CryptoLinkDao cryptoLinkDao = (CryptoLinkDao)((Object)this.context.transaction.getDao(CryptoLinkDao.class));
        for (CryptoKeyPart toCryptoKeyPart : toCryptoKeyParts = toCryptoKeyRole.getCryptoKeyParts(cipherOperationMode)) {
            Collection<CryptoLink> cryptoLinks = cryptoLinkDao.getActiveCryptoLinks(this.getCryptoRepoFile(), toCryptoKeyRole, toCryptoKeyPart);
            PlainCryptoKey plainCryptoKey = this.getPlainCryptoKey(cryptoLinks, toCryptoKeyPart);
            if (plainCryptoKey == null) continue;
            return plainCryptoKey;
        }
        return null;
    }

    public PlainCryptoKey getPlainCryptoKeyForDecrypting(CryptoKey cryptoKey) {
        AssertUtil.assertNotNull((Object)((Object)cryptoKey), (String)"cryptoKey");
        logger.debug("getPlainCryptoKeyForDecrypting: cryptoRepoFile={} repoFile={} cryptoKey={}", new Object[]{this.cryptoRepoFile, this.repoFile, cryptoKey});
        PlainCryptoKey plainCryptoKey = this.getPlainCryptoKey(cryptoKey.getInCryptoLinks(), this.getCryptoKeyPartForDecrypting(cryptoKey));
        return plainCryptoKey;
    }

    private PlainCryptoKey getPlainCryptoKey(Collection<CryptoLink> cryptoLinks, CryptoKeyPart toCryptoKeyPart) {
        AssertUtil.assertNotNull(cryptoLinks, (String)"cryptoLinks");
        AssertUtil.assertNotNull((Object)toCryptoKeyPart, (String)"toCryptoKeyPart");
        for (CryptoLink cryptoLink : cryptoLinks) {
            if (toCryptoKeyPart != cryptoLink.getToCryptoKeyPart()) continue;
            UserRepoKeyPublicKey fromUserRepoKeyPublicKey = cryptoLink.getFromUserRepoKeyPublicKey();
            if (fromUserRepoKeyPublicKey != null) {
                logger.debug("getPlainCryptoKey: >>> cryptoRepoFile={} repoFile={} cryptoLink={} fromUserRepoKeyPublicKey={}", new Object[]{this.cryptoRepoFile, this.repoFile, cryptoLink, fromUserRepoKeyPublicKey});
                Uid userRepoKeyId = fromUserRepoKeyPublicKey.getUserRepoKeyId();
                UserRepoKey userRepoKey = this.context.userRepoKeyRing.getUserRepoKey(userRepoKeyId);
                if (userRepoKey != null) {
                    logger.debug("getPlainCryptoKey: <<< cryptoRepoFile={} repoFile={} cryptoLink={} fromUserRepoKeyPublicKey={}: DECRYPTED!", new Object[]{this.cryptoRepoFile, this.repoFile, cryptoLink, fromUserRepoKeyPublicKey});
                    byte[] plain = CryptreeNodeUtil.decryptLarge(cryptoLink.getToCryptoKeyData(), userRepoKey);
                    return new PlainCryptoKey(cryptoLink.getToCryptoKey(), cryptoLink.getToCryptoKeyPart(), plain);
                }
                logger.debug("getPlainCryptoKey: <<< cryptoRepoFile={} repoFile={} cryptoLink={} fromUserRepoKeyPublicKey={}: FAILED TO DECRYPT!", new Object[]{this.cryptoRepoFile, this.repoFile, cryptoLink, fromUserRepoKeyPublicKey});
                continue;
            }
            if (cryptoLink.getFromCryptoKey() != null) continue;
            logger.debug("getPlainCryptoKey: *** cryptoRepoFile={} repoFile={} cryptoLink={}: PLAIN!", new Object[]{this.cryptoRepoFile, this.repoFile, cryptoLink});
            return new PlainCryptoKey(cryptoLink.getToCryptoKey(), cryptoLink.getToCryptoKeyPart(), cryptoLink.getToCryptoKeyData());
        }
        for (CryptoLink cryptoLink : cryptoLinks) {
            CryptoKey fromCryptoKey;
            if (toCryptoKeyPart != cryptoLink.getToCryptoKeyPart() || (fromCryptoKey = cryptoLink.getFromCryptoKey()) == null) continue;
            logger.debug("getPlainCryptoKey: >>> cryptoRepoFile={} repoFile={} cryptoLink={} fromCryptoKey={}", new Object[]{this.cryptoRepoFile, this.repoFile, cryptoLink, fromCryptoKey});
            PlainCryptoKey plainFromCryptoKey = this.getPlainCryptoKey(fromCryptoKey.getInCryptoLinks(), this.getCryptoKeyPartForDecrypting(fromCryptoKey));
            if (plainFromCryptoKey != null) {
                logger.debug("getPlainCryptoKey: <<< cryptoRepoFile={} repoFile={} cryptoLink={} fromCryptoKey={}: DECRYPTED!", new Object[]{this.cryptoRepoFile, this.repoFile, cryptoLink, fromCryptoKey});
                byte[] plain = CryptreeNodeUtil.decrypt(cryptoLink.getToCryptoKeyData(), plainFromCryptoKey);
                return new PlainCryptoKey(cryptoLink.getToCryptoKey(), cryptoLink.getToCryptoKeyPart(), plain);
            }
            logger.debug("getPlainCryptoKey: <<< cryptoRepoFile={} repoFile={} cryptoLink={} fromCryptoKey={}: FAILED TO DECRYPT!", new Object[]{this.cryptoRepoFile, this.repoFile, cryptoLink, fromCryptoKey});
        }
        return null;
    }

    private CryptoKeyPart getCryptoKeyPartForDecrypting(CryptoKey cryptoKey) {
        switch (cryptoKey.getCryptoKeyType()) {
            case asymmetric: {
                return CryptoKeyPart.privateKey;
            }
            case symmetric: {
                return CryptoKeyPart.sharedSecret;
            }
        }
        throw new IllegalStateException("Unknown cryptoKey.cryptoKeyType: " + cryptoKey.getCryptoKeyType());
    }

    protected PlainCryptoKey getActivePlainCryptoKeyOrCreate(CryptoKeyRole toCryptoKeyRole, CipherOperationMode cipherOperationMode) {
        AssertUtil.assertNotNull((Object)toCryptoKeyRole, (String)"toCryptoKeyRole");
        AssertUtil.assertNotNull((Object)cipherOperationMode, (String)"cipherOperationMode");
        PlainCryptoKey plainCryptoKey = this.getActivePlainCryptoKey(toCryptoKeyRole, cipherOperationMode);
        if (plainCryptoKey == null) {
            PlainCryptoKeyFactory factory;
            Class<? extends PlainCryptoKeyFactory> clazz = cryptoKeyRole2PlainCryptoKeyFactory.get(toCryptoKeyRole);
            AssertUtil.assertNotNull(clazz, (String)String.format("cryptoKeyRole2PlainCryptoKeyFactory[%s]", toCryptoKeyRole));
            try {
                factory = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Creating new instance of class %s failed: %s", clazz.getName(), e), e);
            }
            factory.setCryptreeNode(this);
            factory.setCipherOperationMode(cipherOperationMode);
            plainCryptoKey = factory.createPlainCryptoKey();
            AssertUtil.assertNotNull((Object)plainCryptoKey, (String)(clazz.getName() + ".createPlainCryptoKey()"));
            if (plainCryptoKey.getCryptoKey().getCryptoKeyRole() != toCryptoKeyRole) {
                throw new IllegalStateException(String.format("plainCryptoKey.cryptoKey.cryptoKeyRole != toCryptoKeyRole :: %s != %s", plainCryptoKey.getCryptoKey().getCryptoKeyRole(), toCryptoKeyRole));
            }
            CryptoKeyDao cryptoKeyDao = (CryptoKeyDao)((Object)this.context.transaction.getDao(CryptoKeyDao.class));
            CryptoKey cryptoKey = (CryptoKey)cryptoKeyDao.makePersistent(plainCryptoKey.getCryptoKey());
            plainCryptoKey = new PlainCryptoKey(cryptoKey, plainCryptoKey.getCryptoKeyPart(), plainCryptoKey.getCipherParameters());
        }
        return plainCryptoKey;
    }

    public DataKey getDataKeyOrFail() {
        CryptoRepoFile cryptoRepoFile = this.getCryptoRepoFile();
        AssertUtil.assertNotNull((Object)((Object)cryptoRepoFile), (String)"cryptoRepoFile");
        return this.getDataKeyOrFail(cryptoRepoFile.getCryptoKey());
    }

    public DataKey getDataKeyOrFail(Uid cryptoKeyId) {
        AssertUtil.assertNotNull((Object)cryptoKeyId, (String)"cryptoKeyId");
        CryptoKeyDao cryptoKeyDao = (CryptoKeyDao)((Object)this.context.transaction.getDao(CryptoKeyDao.class));
        CryptoKey cryptoKey = cryptoKeyDao.getCryptoKeyOrFail(cryptoKeyId);
        return this.getDataKeyOrFail(cryptoKey);
    }

    protected DataKey getDataKeyOrFail(CryptoKey cryptoKey) {
        AssertUtil.assertNotNull((Object)((Object)cryptoKey), (String)"cryptoKey");
        PlainCryptoKey plainCryptoKey = this.getPlainCryptoKeyForDecrypting(cryptoKey);
        if (plainCryptoKey == null) {
            throw new ReadAccessDeniedException(String.format("Cannot decrypt dataKey for cryptoKeyID=%s (cryptoRepoFileId=%s)!", cryptoKey.getCryptoKeyId(), cryptoKey.getCryptoRepoFile().getCryptoRepoFileId()));
        }
        AssertUtil.assertNotNull((Object)((Object)plainCryptoKey.getCryptoKey()), (String)"plainCryptoKey.cryptoKey");
        if (CryptoKeyRole.dataKey != plainCryptoKey.getCryptoKey().getCryptoKeyRole()) {
            throw new IllegalStateException("CryptoKeyRole.dataKey != plainCryptoKey.getCryptoKey().getCryptoKeyRole()");
        }
        if (CryptoKeyPart.sharedSecret != plainCryptoKey.getCryptoKeyPart()) {
            throw new IllegalStateException("CryptoKeyPart.sharedSecret != plainCryptoKey.getCryptoKeyPart()");
        }
        return new DataKey(cryptoKey.getCryptoKeyId(), plainCryptoKey.getKeyParameterOrFail());
    }

    public CryptreeNode getParent() {
        if (this.parent == null) {
            CryptoRepoFile parentCryptoRepoFile;
            if (this.repoFile != null && JDOHelper.isDeleted((Object)this.repoFile)) {
                this.getCryptoRepoFile();
                AssertUtil.assertNotNull((Object)((Object)this.cryptoRepoFile), (String)"cryptoRepoFile");
            }
            RepoFile parentRepoFile = this.repoFile == null || JDOHelper.isDeleted((Object)this.repoFile) ? null : this.repoFile.getParent();
            CryptoRepoFile cryptoRepoFile = parentCryptoRepoFile = this.cryptoRepoFile == null ? null : this.cryptoRepoFile.getParent();
            if (parentRepoFile != null || parentCryptoRepoFile != null) {
                this.parent = this.context.getCryptreeNodeOrCreate(null, this, parentRepoFile, parentCryptoRepoFile);
            }
        }
        return this.parent;
    }

    public UserRepoKeyPublicKey getUserRepoKeyPublicKeyOrCreate(UserRepoKey userRepoKey) {
        AssertUtil.assertNotNull((Object)userRepoKey, (String)"userRepoKey");
        return this.getUserRepoKeyPublicKeyOrCreate((UserRepoKey.PublicKey)userRepoKey.getPublicKey());
    }

    public UserRepoKeyPublicKey getUserRepoKeyPublicKeyOrCreate(UserRepoKey.PublicKey publicKey) {
        AssertUtil.assertNotNull((Object)publicKey, (String)"publicKey");
        return new UserRepoKeyPublicKeyHelper(this.getContext()).getUserRepoKeyPublicKeyOrCreate(publicKey);
    }

    public void grantPermission(PermissionType permissionType, UserRepoKey.PublicKey publicKey) {
        UserRepoKeyPublicKey userRepoKeyPublicKey;
        CryptreeNode parent;
        AssertUtil.assertNotNull((Object)permissionType, (String)"permissionType");
        AssertUtil.assertNotNull((Object)publicKey, (String)"publicKey");
        if (this.isOwner(publicKey.getUserRepoKeyId())) {
            return;
        }
        if (PermissionType.readUserIdentity == permissionType && (parent = this.getParent()) != null) {
            parent.grantPermission(permissionType, publicKey);
            return;
        }
        if (permissionType == PermissionType.read || permissionType == PermissionType.write || permissionType == PermissionType.grant) {
            this.grantReadPermission(publicKey);
        }
        if (PermissionType.read == permissionType) {
            return;
        }
        Uid ownerUserRepoKeyId = this.context.getRepositoryOwnerOrFail().getUserRepoKeyPublicKey().getUserRepoKeyId();
        if (ownerUserRepoKeyId.equals((Object)publicKey.getUserRepoKeyId())) {
            return;
        }
        if (PermissionType.grant == permissionType) {
            this.grantPermission(PermissionType.write, publicKey);
            this.grantPermission(PermissionType.readUserIdentity, publicKey);
        }
        PermissionSet permissionSet = this.getPermissionSetOrCreate();
        PermissionDao dao = (PermissionDao)((Object)this.context.transaction.getDao(PermissionDao.class));
        Collection<Permission> permissions = dao.getNonRevokedPermissions(permissionSet, permissionType, userRepoKeyPublicKey = this.getUserRepoKeyPublicKeyOrCreate(publicKey));
        if (permissions.isEmpty()) {
            Permission permission = new Permission();
            permission.setPermissionSet(permissionSet);
            permission.setPermissionType(permissionType);
            permission.setUserRepoKeyPublicKey(userRepoKeyPublicKey);
            this.sign(permission);
            permission = (Permission)dao.makePersistent(permission);
            this.assertPermissionOk(permission);
        }
        if (PermissionType.grant == permissionType) {
            this.ensureParentHasAsymmetricActiveSubdirKey();
        }
        if (PermissionType.readUserIdentity == permissionType) {
            this.createUserIdentityLinksVisibleFor(userRepoKeyPublicKey);
        }
    }

    public void setPermissionsInherited(boolean inherited) {
        if (inherited == this.isPermissionsInherited()) {
            return;
        }
        PermissionSet permissionSet = this.getPermissionSetOrCreate();
        if (inherited) {
            PermissionSetInheritance permissionSetInheritance = new PermissionSetInheritance();
            permissionSetInheritance.setPermissionSet(permissionSet);
            this.sign(permissionSetInheritance);
            permissionSet.getPermissionSetInheritances().add(permissionSetInheritance);
        } else {
            boolean currentUserIsOwner;
            RepositoryOwner repositoryOwner = this.context.getRepositoryOwnerOrFail();
            UserRepoKey.PublicKey ownerPublicKey = repositoryOwner.getUserRepoKeyPublicKey().getPublicKey();
            this.grantReadPermission(ownerPublicKey);
            boolean bl = currentUserIsOwner = this.context.userRepoKeyRing.getUserRepoKey(ownerPublicKey.getUserRepoKeyId()) != null;
            if (!currentUserIsOwner) {
                logger.warn("This is not yet cleanly implemented and likely causes an error.", (Throwable)new UnsupportedOperationException("NYI"));
            }
            for (PermissionSetInheritance permissionSetInheritance : permissionSet.getPermissionSetInheritances()) {
                if (permissionSetInheritance.getRevoked() != null) continue;
                permissionSetInheritance.setRevoked(new Date());
                this.sign(permissionSetInheritance);
            }
            HashSet<CryptoKey> processedCryptoKeys = new HashSet<CryptoKey>();
            Collection<CryptoKey> subdirKeys = ((CryptoKeyDao)((Object)this.context.transaction.getDao(CryptoKeyDao.class))).getActiveCryptoKeys(this.getCryptoRepoFileOrCreate(false), CryptoKeyRole.subdirKey);
            for (CryptoKey subdirKey : subdirKeys) {
                this.deactivateCryptoKeyAndDescendants(subdirKey, processedCryptoKeys);
            }
            this.createSubdirKeyAndBacklinkKeyIfNeededChildrenRecursively();
        }
    }

    public boolean isPermissionsInherited() {
        PermissionSet permissionSet = this.getPermissionSet();
        if (permissionSet == null) {
            return true;
        }
        for (PermissionSetInheritance permissionSetInheritance : permissionSet.getPermissionSetInheritances()) {
            if (permissionSetInheritance.getRevoked() != null) continue;
            return true;
        }
        return false;
    }

    private void ensureParentHasAsymmetricActiveSubdirKey() {
        CryptoRepoFile parentCryptoRepoFile;
        CryptreeNode parent = this.getParent();
        CryptoRepoFile cryptoRepoFile = parentCryptoRepoFile = parent == null ? null : parent.getCryptoRepoFileOrCreate(false);
        if (parentCryptoRepoFile == null) {
            return;
        }
        CryptoKeyDao cryptoKeyDao = (CryptoKeyDao)((Object)this.context.transaction.getDao(CryptoKeyDao.class));
        Collection<CryptoKey> activeSubdirKeys = cryptoKeyDao.getActiveCryptoKeys(parentCryptoRepoFile, CryptoKeyRole.subdirKey);
        boolean hasAsymmetryActiveSubdirKey = false;
        block4: for (CryptoKey activeSubdirKey : activeSubdirKeys) {
            switch (activeSubdirKey.getCryptoKeyType()) {
                case asymmetric: {
                    hasAsymmetryActiveSubdirKey = true;
                    continue block4;
                }
                case symmetric: {
                    this.deactivateCryptoKey(activeSubdirKey);
                    continue block4;
                }
            }
            throw new IllegalStateException("Unknown CryptoKeyType: " + activeSubdirKey.getCryptoKeyType());
        }
        if (!hasAsymmetryActiveSubdirKey) {
            parent.getActivePlainCryptoKeyOrCreate(CryptoKeyRole.subdirKey, CipherOperationMode.DECRYPT);
        }
    }

    public void revokePermission(PermissionType permissionType, Set<Uid> userRepoKeyIds) {
        PermissionSet permissionSet;
        AssertUtil.assertNotNull((Object)permissionType, (String)"permissionType");
        AssertUtil.assertNotNull(userRepoKeyIds, (String)"userRepoKeyIds");
        if (PermissionType.readUserIdentity == permissionType) {
            CryptreeNode parent = this.getParent();
            if (parent != null) {
                parent.revokePermission(permissionType, userRepoKeyIds);
                return;
            }
            this.revokeGrantPermissionOfAllCryptoRepoFiles(userRepoKeyIds);
        }
        if (PermissionType.read == permissionType) {
            this.revokePermission(PermissionType.write, userRepoKeyIds);
            this.revokeReadPermission(userRepoKeyIds);
            return;
        }
        if (PermissionType.write == permissionType) {
            this.revokePermission(PermissionType.grant, userRepoKeyIds);
        }
        if ((permissionSet = this.getPermissionSet()) == null) {
            return;
        }
        PermissionDao dao = (PermissionDao)((Object)this.context.transaction.getDao(PermissionDao.class));
        Collection<Permission> permissions = dao.getNonRevokedPermissions(permissionSet, permissionType, userRepoKeyIds);
        for (Permission permission : permissions) {
            this.permissionsAlreadyCheckedOk.remove((Object)permission);
            permission.setRevoked(new Date());
            this.sign(permission);
            this.assertPermissionOk(permission);
        }
        if (PermissionType.readUserIdentity == permissionType && this.existsAtLeastOneUserIdentityLinkFor(userRepoKeyIds)) {
            new UserRepoKeyPublicKeyHelper(this.getContext()).removeUserIdentityLinksAfterRevokingReadUserIdentityPermission();
        }
    }

    public Set<PermissionType> getGrantedPermissionTypes(Uid userRepoKeyId) {
        AssertUtil.assertNotNull((Object)userRepoKeyId, (String)"userRepoKeyId");
        EnumSet<PermissionType> result = EnumSet.noneOf(PermissionType.class);
        if (this.isOwner(userRepoKeyId)) {
            result.addAll(Arrays.asList(PermissionType.values()));
        } else {
            PermissionSet permissionSet;
            PermissionDao pDao = (PermissionDao)((Object)this.context.transaction.getDao(PermissionDao.class));
            if (!pDao.getNonRevokedPermissions(PermissionType.readUserIdentity, userRepoKeyId).isEmpty()) {
                result.add(PermissionType.readUserIdentity);
            }
            if ((permissionSet = this.getPermissionSet()) != null) {
                if (!pDao.getNonRevokedPermissions(permissionSet, PermissionType.grant, userRepoKeyId).isEmpty()) {
                    result.add(PermissionType.grant);
                }
                if (!pDao.getNonRevokedPermissions(permissionSet, PermissionType.write, userRepoKeyId).isEmpty()) {
                    result.add(PermissionType.write);
                }
            }
            if (this.hasReadPermissionHere(userRepoKeyId)) {
                result.add(PermissionType.read);
            }
        }
        return result;
    }

    private boolean hasReadPermissionHereOrInherited(Uid userRepoKeyId) {
        CryptreeNode parent;
        if (this.hasReadPermissionHere(userRepoKeyId)) {
            return true;
        }
        if (this.isPermissionsInherited() && (parent = this.getParent()) != null) {
            return parent.hasReadPermissionHereOrInherited(userRepoKeyId);
        }
        return false;
    }

    private boolean hasReadPermissionHere(Uid userRepoKeyId) {
        CryptoLinkDao cryptoLinkDao;
        Collection<CryptoLink> cryptoLinks;
        UserRepoKeyPublicKeyDao urkpkDao;
        UserRepoKeyPublicKey userRepoKeyPublicKey;
        CryptoRepoFile cryptoRepoFile = this.getCryptoRepoFile();
        return cryptoRepoFile != null && (userRepoKeyPublicKey = (urkpkDao = (UserRepoKeyPublicKeyDao)((Object)this.context.transaction.getDao(UserRepoKeyPublicKeyDao.class))).getUserRepoKeyPublicKey(userRepoKeyId)) != null && !(cryptoLinks = (cryptoLinkDao = (CryptoLinkDao)((Object)this.context.transaction.getDao(CryptoLinkDao.class))).getActiveCryptoLinks(cryptoRepoFile, CryptoKeyRole.clearanceKey, CryptoKeyPart.privateKey, userRepoKeyPublicKey)).isEmpty();
    }

    private void createUserIdentityLinksVisibleFor(UserRepoKeyPublicKey userRepoKeyPublicKey) {
    }

    private boolean existsAtLeastOneUserIdentityLinkFor(Set<Uid> userRepoKeyIds) {
        AssertUtil.assertNotNull(userRepoKeyIds, (String)"userRepoKeyIds");
        UserRepoKeyPublicKeyDao urkpkDao = (UserRepoKeyPublicKeyDao)((Object)this.getContext().transaction.getDao(UserRepoKeyPublicKeyDao.class));
        UserIdentityLinkDao uilDao = (UserIdentityLinkDao)((Object)this.getContext().transaction.getDao(UserIdentityLinkDao.class));
        for (Uid userRepoKeyId : userRepoKeyIds) {
            UserRepoKeyPublicKey forUserRepoKeyPublicKey = urkpkDao.getUserRepoKeyPublicKeyOrFail(userRepoKeyId);
            Collection<UserIdentityLink> userIdentityLinks = uilDao.getUserIdentityLinksFor(forUserRepoKeyPublicKey);
            if (userIdentityLinks.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void revokeGrantPermissionOfAllCryptoRepoFiles(Set<Uid> userRepoKeyIds) {
        AssertUtil.assertNotNull(userRepoKeyIds, (String)"userRepoKeyIds");
        PermissionDao dao = (PermissionDao)((Object)this.context.transaction.getDao(PermissionDao.class));
        HashSet<CryptoRepoFile> cryptoRepoFiles = new HashSet<CryptoRepoFile>();
        Collection<Permission> permissions = dao.getNonRevokedPermissions(PermissionType.grant, userRepoKeyIds);
        for (Permission permission : permissions) {
            cryptoRepoFiles.add(permission.getPermissionSet().getCryptoRepoFile());
        }
        for (CryptoRepoFile cryptoRepoFile : cryptoRepoFiles) {
            this.getContext().getCryptreeNodeOrCreate(cryptoRepoFile.getCryptoRepoFileId()).revokePermission(PermissionType.grant, userRepoKeyIds);
        }
    }

    public void assertHasPermission(boolean anyCryptoRepoFile, Uid userRepoKeyId, PermissionType permissionType, Date timestamp) throws AccessDeniedException {
        AssertUtil.assertNotNull((Object)userRepoKeyId, (String)"userRepoKeyId");
        AssertUtil.assertNotNull((Object)permissionType, (String)"permissionType");
        AssertUtil.assertNotNull((Object)timestamp, (String)"timestamp");
        if (this.isOwner(userRepoKeyId)) {
            return;
        }
        String additionalExceptionMsg = null;
        UserRepoKeyPublicKey userRepoKeyPublicKey = ((UserRepoKeyPublicKeyDao)((Object)this.context.transaction.getDao(UserRepoKeyPublicKeyDao.class))).getUserRepoKeyPublicKeyOrFail(userRepoKeyId);
        if (userRepoKeyPublicKey instanceof InvitationUserRepoKeyPublicKey) {
            InvitationUserRepoKeyPublicKey invUserRepoKeyPublicKey = (InvitationUserRepoKeyPublicKey)userRepoKeyPublicKey;
            if (timestamp.compareTo(invUserRepoKeyPublicKey.getValidTo()) <= 0) {
                UserRepoKeyPublicKeyReplacementRequestDao dao = (UserRepoKeyPublicKeyReplacementRequestDao)((Object)this.context.transaction.getDao(UserRepoKeyPublicKeyReplacementRequestDao.class));
                if (dao.getUserRepoKeyPublicKeyReplacementRequestsForOldKey(invUserRepoKeyPublicKey).isEmpty()) {
                    this.throwAccessDeniedException(permissionType, "There is no UserRepoKeyPublicKeyReplacementRequest for " + (Object)((Object)invUserRepoKeyPublicKey));
                }
                Uid signingUserRepoKeyId = invUserRepoKeyPublicKey.getSignature().getSigningUserRepoKeyId();
                this.assertHasPermission(anyCryptoRepoFile, signingUserRepoKeyId, permissionType, invUserRepoKeyPublicKey.getSignature().getSignatureCreated());
                return;
            }
            additionalExceptionMsg = String.format("userRepoKeyPublicKey is an InvitationUserRepoKeyPublicKey, but it expired on '%s', which is before the given timestamp '%s'!", ISO8601.formatDate((Date)invUserRepoKeyPublicKey.getValidTo()), ISO8601.formatDate((Date)timestamp));
        }
        HashSet<Permission> permissions = new HashSet<Permission>();
        if (PermissionType.read == permissionType) {
            long timeDifferenceToNow = Math.abs(System.currentTimeMillis() - timestamp.getTime());
            if (timeDifferenceToNow > 300000L) {
                throw new UnsupportedOperationException("assertHasPermission(...) does not yet support permissionType 'read' combined with a timestamp that is not *now*!");
            }
            if (this.hasReadPermissionHereOrInherited(userRepoKeyId)) {
                return;
            }
        } else {
            this.collectPermissions(permissions, anyCryptoRepoFile, permissionType, userRepoKeyId, timestamp);
            Set<Permission> permissionsIndicatingBackdatedSignature = this.extractPermissionsIndicatingBackdatedSignature(permissions);
            if (!permissions.isEmpty()) {
                return;
            }
            if (!permissionsIndicatingBackdatedSignature.isEmpty()) {
                String exceptionMsg = String.format("Found '%s' permission(s) for userRepoKeyId=%s and timestamp=%s, but it (or they) indicates backdating outside of allowed range!", permissionType, userRepoKeyId, timestamp);
                this.throwAccessDeniedException(permissionType, exceptionMsg);
            }
        }
        String exceptionMsg = String.format("No '%s' permission found for userRepoKeyId=%s and timestamp=%s!", permissionType, userRepoKeyId, ISO8601.formatDate((Date)timestamp)) + (StringUtil.isEmpty((String)additionalExceptionMsg) ? "" : " " + additionalExceptionMsg);
        this.throwAccessDeniedException(permissionType, exceptionMsg);
    }

    private void throwAccessDeniedException(PermissionType permissionType, String exceptionMessage) throws AccessDeniedException {
        switch (permissionType) {
            case grant: {
                throw new GrantAccessDeniedException(exceptionMessage);
            }
            case write: {
                throw new WriteAccessDeniedException(exceptionMessage);
            }
            case read: {
                throw new ReadAccessDeniedException(exceptionMessage);
            }
            case readUserIdentity: {
                throw new ReadUserIdentityAccessDeniedException(exceptionMessage);
            }
        }
        throw new IllegalArgumentException("Unknown permissionType: " + permissionType);
    }

    private boolean isOwner(Uid userRepoKeyId) {
        AssertUtil.assertNotNull((Object)userRepoKeyId, (String)"userRepoKeyId");
        return userRepoKeyId.equals((Object)this.context.getRepositoryOwnerOrFail().getUserRepoKeyPublicKey().getUserRepoKeyId());
    }

    private void collectPermissions(Set<Permission> permissions, boolean anyCryptoRepoFile, PermissionType permissionType, Uid userRepoKeyId, Date timestamp) {
        CryptreeNode parent;
        PermissionSet permissionSet;
        AssertUtil.assertNotNull((Object)permissionType, (String)"permissionType");
        AssertUtil.assertNotNull((Object)userRepoKeyId, (String)"userRepoKeyId");
        AssertUtil.assertNotNull((Object)timestamp, (String)"timestamp");
        switch (permissionType) {
            case grant: 
            case write: {
                break;
            }
            case readUserIdentity: {
                anyCryptoRepoFile = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("PermissionType unknown or not allowed here: " + permissionType);
            }
        }
        PermissionSet permissionSet2 = permissionSet = anyCryptoRepoFile ? null : this.getPermissionSet();
        if (anyCryptoRepoFile || permissionSet != null) {
            PermissionDao dao = (PermissionDao)((Object)this.context.transaction.getDao(PermissionDao.class));
            HashSet<Permission> ps = anyCryptoRepoFile ? new HashSet<Permission>(dao.getValidPermissions(permissionType, userRepoKeyId, timestamp)) : new HashSet<Permission>(dao.getValidPermissions(permissionSet, permissionType, userRepoKeyId, timestamp));
            ps.removeAll(this.permissionsBeingCheckedNow);
            if (!ps.isEmpty()) {
                for (Permission permission : ps) {
                    this.assertPermissionOk(permission);
                }
            }
            permissions.addAll(ps);
        }
        if (!anyCryptoRepoFile && (permissionSet == null || permissionSet.isPermissionsInherited(timestamp)) && (parent = this.getParent()) != null) {
            parent.collectPermissions(permissions, anyCryptoRepoFile, permissionType, userRepoKeyId, timestamp);
        }
    }

    private Set<Permission> extractPermissionsIndicatingBackdatedSignature(Set<Permission> permissions) {
        HashSet<Permission> result = new HashSet<Permission>(permissions);
        Date backdatingOldestPermissionValidTo = null;
        if (this.getContext().isOnServer) {
            Iterator<Permission> it = permissions.iterator();
            while (it.hasNext()) {
                Permission permission = it.next();
                if (permission.getValidTo() == null) continue;
                if (backdatingOldestPermissionValidTo == null) {
                    File file = this.getContext().transaction.getLocalRepoManager().getLocalRoot();
                    backdatingOldestPermissionValidTo = new Date(System.currentTimeMillis() - CryptoConfigUtil.getBackdatingMaxPermissionValidToAge((File)file));
                }
                if (!permission.getValidTo().before(backdatingOldestPermissionValidTo)) continue;
                result.add(permission);
                it.remove();
            }
        }
        return result;
    }

    private void assertPermissionOk(Permission permission) throws SignatureException, AccessDeniedException {
        AssertUtil.assertNotNull((Object)((Object)permission), (String)"permission");
        if (this.permissionsAlreadyCheckedOk.contains((Object)permission)) {
            return;
        }
        if (!this.permissionsBeingCheckedNow.add(permission)) {
            throw new IllegalStateException("Circular permission check! " + (Object)((Object)permission));
        }
        try {
            this.assertSignatureOk(permission);
            this.permissionsAlreadyCheckedOk.add(permission);
        }
        finally {
            this.permissionsBeingCheckedNow.remove((Object)permission);
        }
    }

    public void assertSignatureOk(WriteProtected entity) throws SignatureException, AccessDeniedException {
        AssertUtil.assertNotNull((Object)entity, (String)"entity");
        Uid crfIdControllingPermissions = entity.getCryptoRepoFileIdControllingPermissions();
        if (crfIdControllingPermissions == null) {
            this.assertSignatureOk((Signable)entity, true, entity.getPermissionTypeRequiredForWrite());
        } else if (crfIdControllingPermissions.equals((Object)this.getCryptoRepoFile().getCryptoRepoFileId())) {
            this.assertSignatureOk((Signable)entity, false, entity.getPermissionTypeRequiredForWrite());
        } else {
            CryptreeNode cryptreeNode = this.context.getCryptreeNodeOrCreate(crfIdControllingPermissions);
            cryptreeNode.assertSignatureOk((Signable)entity, false, entity.getPermissionTypeRequiredForWrite());
        }
    }

    public void assertSignatureOk(Signable signable, boolean anyCryptoRepoFile, PermissionType requiredPermissionType) throws SignatureException, AccessDeniedException {
        AssertUtil.assertNotNull((Object)signable, (String)"signable");
        this.context.signableVerifier.verify(signable);
        if (requiredPermissionType != null) {
            Uid signingUserRepoKeyId = signable.getSignature().getSigningUserRepoKeyId();
            this.assertHasPermission(anyCryptoRepoFile, signingUserRepoKeyId, requiredPermissionType, signable.getSignature().getSignatureCreated());
        }
    }

    public PermissionSet getPermissionSet() {
        if (this.permissionSet == null) {
            PermissionSetDao dao = (PermissionSetDao)((Object)this.context.transaction.getDao(PermissionSetDao.class));
            this.permissionSet = dao.getPermissionSet(this.getCryptoRepoFileOrCreate(false));
            if (this.permissionSet != null) {
                this.assertSignatureOk(this.permissionSet);
            }
        }
        return this.permissionSet;
    }

    public PermissionSet getPermissionSetOrCreate() {
        PermissionSet permissionSet = this.getPermissionSet();
        if (permissionSet == null) {
            permissionSet = new PermissionSet();
            permissionSet.setCryptoRepoFile((CryptoRepoFile)((Object)AssertUtil.assertNotNull((Object)((Object)this.getCryptoRepoFile()), (String)"getCryptoRepoFile()")));
            this.sign(permissionSet);
            PermissionSetDao dao = (PermissionSetDao)((Object)this.context.transaction.getDao(PermissionSetDao.class));
            this.permissionSet = permissionSet = (PermissionSet)dao.makePersistent(permissionSet);
            this.setPermissionsInherited(true);
        }
        return permissionSet;
    }

    public void sign(WriteProtected writeProtected) throws AccessDeniedException {
        UserRepoKey userRepoKey;
        AssertUtil.assertNotNull((Object)writeProtected, (String)"writeProtectedEntity");
        Uid crfIdControllingPermissions = writeProtected.getCryptoRepoFileIdControllingPermissions();
        if (crfIdControllingPermissions == null) {
            userRepoKey = this.getUserRepoKeyOrFail(true, writeProtected.getPermissionTypeRequiredForWrite());
        } else if (crfIdControllingPermissions.equals((Object)this.getCryptoRepoFile().getCryptoRepoFileId())) {
            userRepoKey = this.getUserRepoKeyOrFail(false, writeProtected.getPermissionTypeRequiredForWrite());
        } else {
            CryptreeNode cryptreeNode = this.context.getCryptreeNodeOrCreate(crfIdControllingPermissions);
            userRepoKey = cryptreeNode.getUserRepoKeyOrFail(false, writeProtected.getPermissionTypeRequiredForWrite());
        }
        this.context.getSignableSigner(userRepoKey).sign((Signable)writeProtected);
    }

    public UserRepoKey getUserRepoKey(boolean anyCryptoRepoFile, PermissionType permissionType) {
        AssertUtil.assertNotNull((Object)permissionType, (String)"permissionType");
        switch (permissionType) {
            case grant: 
            case write: {
                break;
            }
            default: {
                throw new IllegalArgumentException("PermissionType unknown or not allowed here: " + permissionType);
            }
        }
        Date now = new Date();
        for (UserRepoKey userRepoKey : this.context.userRepoKeyRing.getPermanentUserRepoKeys(this.context.serverRepositoryId)) {
            boolean owner = this.isOwner(userRepoKey.getUserRepoKeyId());
            HashSet<Permission> permissions = new HashSet<Permission>();
            if (!owner) {
                this.collectPermissions(permissions, anyCryptoRepoFile, permissionType, userRepoKey.getUserRepoKeyId(), now);
            }
            if (!owner && permissions.isEmpty()) continue;
            this.getUserRepoKeyPublicKeyOrCreate(userRepoKey);
            return userRepoKey;
        }
        return null;
    }

    private UserRepoKey getUserRepoKeyOrFail(boolean anyCryptoRepoFile, PermissionType permissionType) {
        UserRepoKey userRepoKey = this.getUserRepoKey(anyCryptoRepoFile, permissionType);
        if (userRepoKey == null) {
            String message = String.format("No '%s' permission for any UserRepoKey of the current UserRepoKeyRing for: %s", permissionType, this.repoFile != null ? this.repoFile.getPath() : this.cryptoRepoFile);
            switch (permissionType) {
                case grant: {
                    throw new GrantAccessDeniedException(message);
                }
                case read: {
                    throw new ReadAccessDeniedException(message);
                }
                case write: {
                    throw new WriteAccessDeniedException(message);
                }
            }
            throw new IllegalArgumentException("Unknown PermissionType: " + permissionType);
        }
        return userRepoKey;
    }

    public void clearCryptoRepoFileDeleted() {
        CryptoRepoFile cryptoRepoFile = this.getCryptoRepoFile();
        AssertUtil.assertNotNull((Object)((Object)cryptoRepoFile), (String)"cryptoRepoFile");
        this.deletePreliminaryDeletions();
        if (cryptoRepoFile.getDeleted() != null) {
            cryptoRepoFile.setDeleted(null);
            cryptoRepoFile.setDeletedByIgnoreRule(false);
            cryptoRepoFile.setLastSyncFromRepositoryId(null);
            this.sign(cryptoRepoFile);
            this.updateCryptoConfigPropSetIfConfigFile();
        }
    }

    protected void deletePreliminaryDeletions() {
        CryptoRepoFile cryptoRepoFile = this.getCryptoRepoFile();
        AssertUtil.assertNotNull((Object)((Object)cryptoRepoFile), (String)"cryptoRepoFile");
        PreliminaryDeletionDao pdDao = (PreliminaryDeletionDao)((Object)this.getContext().transaction.getDao(PreliminaryDeletionDao.class));
        PreliminaryDeletion preliminaryDeletion = pdDao.getPreliminaryDeletion(cryptoRepoFile);
        if (preliminaryDeletion != null) {
            pdDao.deletePersistent(preliminaryDeletion);
        }
    }

    public ConfigPropSetDto getParentConfigPropSetDtoIfNeeded() {
        Uid id = this.context.getCryptoRepoFileIdForRemotePathPrefixOrFail();
        if (!id.equals((Object)this.getCryptoRepoFile().getCryptoRepoFileId())) {
            throw new IllegalStateException("cryptoRepoFileIdForRemotePathPrefix != cryptoRepoFile.cryptoRepoFileId :: " + id + " != " + this.getCryptoRepoFile().getCryptoRepoFileId());
        }
        List<CryptoConfigPropSet> cryptoConfigPropSets = this.getCryptoConfigPropSetsAbove();
        if (!this.isCryptoConfigPropSetModifiedAfterLastSync(cryptoConfigPropSets)) {
            return null;
        }
        Properties mergedProperties = null;
        for (CryptoConfigPropSet cryptoConfigPropSet : cryptoConfigPropSets) {
            ConfigPropSetDto configPropSetDto = this.getConfigPropSetDto(cryptoConfigPropSet);
            if (configPropSetDto == null) continue;
            Properties properties = configPropSetDto.toProperties();
            if (mergedProperties == null) {
                mergedProperties = properties;
                continue;
            }
            mergedProperties.putAll((Map<?, ?>)properties);
        }
        return mergedProperties == null ? new ConfigPropSetDto() : new ConfigPropSetDto(mergedProperties);
    }

    private ConfigPropSetDto getConfigPropSetDto(CryptoConfigPropSet cryptoConfigPropSet) {
        AssertUtil.assertNotNull((Object)((Object)cryptoConfigPropSet), (String)"cryptoConfigPropSet");
        PlainCryptoKey plainCryptoKey = this.getPlainCryptoKeyForDecrypting(cryptoConfigPropSet.getCryptoKey());
        if (plainCryptoKey == null) {
            throw new ReadAccessDeniedException(String.format("The CryptoConfigPropSet with cryptoRepoFileId=%s could not be decrypted! Access rights missing?!", cryptoConfigPropSet.getCryptoRepoFileId()));
        }
        byte[] encryptedData = cryptoConfigPropSet.getConfigPropSetDtoData();
        if (encryptedData == null || encryptedData.length == 0) {
            return null;
        }
        byte[] plainData = CryptreeNodeUtil.decrypt(encryptedData, plainCryptoKey);
        return (ConfigPropSetDto)new ConfigPropSetDtoIo().deserializeWithGz(plainData);
    }

    private boolean isCryptoConfigPropSetModifiedAfterLastSync(List<CryptoConfigPropSet> cryptoConfigPropSets) {
        AssertUtil.assertNotNull(cryptoConfigPropSets, (String)"cryptoConfigPropSets");
        RemoteRepository remoteRepository = ((RemoteRepositoryDao)this.context.transaction.getDao(RemoteRepositoryDao.class)).getRemoteRepositoryOrFail(this.context.remoteRepositoryId);
        for (CryptoConfigPropSet cryptoConfigPropSet : cryptoConfigPropSets) {
            if (cryptoConfigPropSet.getLocalRevision() <= remoteRepository.getLocalRevision()) continue;
            return true;
        }
        return false;
    }

    private List<CryptoConfigPropSet> getCryptoConfigPropSetsAbove() {
        CryptoConfigPropSetDao ccpsDao = (CryptoConfigPropSetDao)((Object)this.context.transaction.getDao(CryptoConfigPropSetDao.class));
        ArrayList<CryptoConfigPropSet> result = new ArrayList<CryptoConfigPropSet>();
        CryptoRepoFile cryptoRepoFile = (CryptoRepoFile)((Object)AssertUtil.assertNotNull((Object)((Object)this.getCryptoRepoFile()), (String)"cryptoRepoFile"));
        while ((cryptoRepoFile = cryptoRepoFile.getParent()) != null) {
            CryptoConfigPropSet cryptoConfigPropSet = ccpsDao.getCryptoConfigPropSet(cryptoRepoFile);
            if (cryptoConfigPropSet == null) continue;
            result.add(cryptoConfigPropSet);
        }
        Collections.reverse(result);
        return result;
    }

    static {
        HashMap<CryptoKeyRole, Class<PlainCryptoKeyFactory.DataKeyPlainCryptoKeyFactory>> m = new HashMap<CryptoKeyRole, Class<PlainCryptoKeyFactory.DataKeyPlainCryptoKeyFactory>>(5);
        m.put(CryptoKeyRole.clearanceKey, PlainCryptoKeyFactory.ClearanceKeyPlainCryptoKeyFactory.class);
        m.put(CryptoKeyRole.subdirKey, PlainCryptoKeyFactory.SubdirKeyPlainCryptoKeyFactory.class);
        m.put(CryptoKeyRole.fileKey, PlainCryptoKeyFactory.FileKeyPlainCryptoKeyFactory.class);
        m.put(CryptoKeyRole.backlinkKey, PlainCryptoKeyFactory.BacklinkKeyPlainCryptoKeyFactory.class);
        m.put(CryptoKeyRole.dataKey, PlainCryptoKeyFactory.DataKeyPlainCryptoKeyFactory.class);
        cryptoKeyRole2PlainCryptoKeyFactory = Collections.unmodifiableMap(m);
    }
}

