/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.io;

import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.io.InStream;
import co.codewizards.cloudstore.core.io.OutStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamUtil {
    private StreamUtil() {
    }

    public static IInputStream castStream(InputStream in) {
        if (in instanceof IInputStream) {
            return (IInputStream)((Object)in);
        }
        if (in == null) {
            return null;
        }
        return new InStream(in);
    }

    public static InputStream castStream(IInputStream in) {
        if (in instanceof InputStream) {
            return (InputStream)((Object)in);
        }
        if (in == null) {
            return null;
        }
        return new InStream.InverseInStream(in);
    }

    public static IOutputStream castStream(OutputStream out) {
        if (out instanceof IOutputStream) {
            return (IOutputStream)((Object)out);
        }
        if (out == null) {
            return null;
        }
        return new OutStream(out);
    }

    public static OutputStream castStream(IOutputStream out) {
        if (out instanceof OutputStream) {
            return (OutputStream)((Object)out);
        }
        if (out == null) {
            return null;
        }
        return new OutStream.InverseOutStream(out);
    }
}

