/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp;

import co.codewizards.cloudstore.core.bean.AbstractBean;
import co.codewizards.cloudstore.core.bean.PropertyBase;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.io.Serializable;

public class PgpUserId
extends AbstractBean<Property>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String email;

    public PgpUserId() {
    }

    public PgpUserId(String userIdStr) {
        if (!StringUtil.isEmpty((String)userIdStr)) {
            userIdStr = userIdStr.trim();
            int lastLt = userIdStr.lastIndexOf(60);
            int lastGt = userIdStr.lastIndexOf(62);
            if (lastLt < 0) {
                int lastSpace = userIdStr.lastIndexOf(32);
                if (lastSpace < 0) {
                    String email = lastGt < 0 ? userIdStr : userIdStr.substring(0, lastGt);
                    this.email = email.trim();
                } else {
                    String email = lastGt < 0 ? userIdStr.substring(lastSpace + 1) : userIdStr.substring(lastSpace + 1, lastGt);
                    this.email = email.trim();
                }
            } else {
                String email = lastGt < 0 ? userIdStr.substring(lastLt + 1) : userIdStr.substring(lastLt + 1, lastGt);
                String fullName = userIdStr.substring(0, lastLt);
                this.email = email.trim();
                this.name = fullName.trim();
            }
        }
    }

    public PgpUserId(PgpUserId other) {
        if (other != null) {
            this.name = other.getName();
            this.email = other.getEmail();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.setPropertyValue(PropertyEnum.name, name);
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.setPropertyValue(PropertyEnum.email, email);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String name = StringUtil.trim((String)this.getName());
        String email = StringUtil.trim((String)this.getEmail());
        if (!StringUtil.isEmpty((String)name)) {
            sb.append(name);
        }
        if (!StringUtil.isEmpty((String)email)) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append('<').append(email).append('>');
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return StringUtil.isEmpty((String)StringUtil.trim((String)this.getName())) && StringUtil.isEmpty((String)StringUtil.trim((String)this.getEmail()));
    }

    public static enum PropertyEnum implements Property
    {
        name,
        email;

    }

    public static interface Property
    extends PropertyBase {
    }
}

