/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.persistence;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.Directory;
import co.codewizards.cloudstore.local.persistence.Repository;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.annotations.Discriminator;
import javax.jdo.annotations.DiscriminatorStrategy;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.Join;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.state.StateManager;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.SUPERCLASS_TABLE)
@Discriminator(strategy=DiscriminatorStrategy.VALUE_MAP, value="LocalRepository")
public class LocalRepository
extends Repository
implements Persistable {
    @Persistent(nullValue=NullValue.EXCEPTION)
    private Directory root;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private byte[] privateKey;
    @Join
    private Set<String> aliases;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public LocalRepository() {
    }

    public LocalRepository(UUID repositoryId) {
        super(repositoryId);
    }

    public Directory getRoot() {
        return LocalRepository.dnGetroot(this);
    }

    public void setRoot(Directory root) {
        if (!Util.equal((Object)LocalRepository.dnGetroot(this), (Object)root)) {
            LocalRepository.dnSetroot(this, root);
        }
    }

    public byte[] getPrivateKey() {
        return LocalRepository.dnGetprivateKey(this);
    }

    public void setPrivateKey(byte[] privateKey) {
        if (!Util.equal((byte[])LocalRepository.dnGetprivateKey(this), (byte[])privateKey)) {
            LocalRepository.dnSetprivateKey(this, privateKey);
        }
    }

    public Set<String> getAliases() {
        if (LocalRepository.dnGetaliases(this) == null) {
            LocalRepository.dnSetaliases(this, new HashSet());
        }
        return LocalRepository.dnGetaliases(this);
    }

    @Override
    public void jdoPreStore() {
        super.jdoPreStore();
        PersistenceManager pm = (PersistenceManager)AssertUtil.assertNotNull((Object)JDOHelper.getPersistenceManager((Object)this), (String)"JDOHelper.getPersistenceManager(this)");
        Iterator iterator = pm.getExtent(LocalRepository.class).iterator();
        if (iterator.hasNext()) {
            LocalRepository persistentInstance = (LocalRepository)iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalStateException("There are multiple LocalRepository entities in the database.");
            }
            if (persistentInstance != null && !persistentInstance.equals(this)) {
                throw new IllegalStateException("Cannot persist a 2nd LocalRepository!");
            }
        }
    }

    static {
        dnFieldNames = LocalRepository.__dnFieldNamesInit();
        dnFieldTypes = LocalRepository.__dnFieldTypesInit();
        dnFieldFlags = LocalRepository.__dnFieldFlagsInit();
        dnInheritedFieldCount = LocalRepository.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = LocalRepository.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)LocalRepository.___dn$loadClass("co.codewizards.cloudstore.local.persistence.LocalRepository"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new LocalRepository());
    }

    @Override
    public boolean dnIsDetached() {
        return false;
    }

    @Override
    public Persistable dnNewInstance(StateManager sm) {
        LocalRepository result = new LocalRepository();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    @Override
    public Persistable dnNewInstance(StateManager sm, Object obj) {
        LocalRepository result = new LocalRepository();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    @Override
    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.aliases = (Set)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 1: {
                this.privateKey = (byte[])this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 2: {
                this.root = (Directory)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    @Override
    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.aliases);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.privateKey);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.root);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(LocalRepository obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.aliases = obj.aliases;
                break;
            }
            case 1: {
                this.privateKey = obj.privateKey;
                break;
            }
            case 2: {
                this.root = obj.root;
                break;
            }
            default: {
                super.dnCopyField(obj, index);
            }
        }
    }

    @Override
    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof LocalRepository)) {
            throw new IllegalArgumentException("object is not an object of type co.codewizards.cloudstore.local.persistence.LocalRepository");
        }
        LocalRepository other = (LocalRepository)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"aliases", "privateKey", "root"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{LocalRepository.___dn$loadClass("java.util.Set"), LocalRepository.___dn$loadClass("[B"), LocalRepository.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Directory")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{10, 26, 10};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Repository.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 3 + Repository.dnGetManagedFieldCount();
    }

    private static Class __dnPersistableSuperclassInit() {
        return LocalRepository.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Repository");
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        LocalRepository o = (LocalRepository)super.clone();
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static Set dnGetaliases(LocalRepository objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return (Set)objPC.dnStateManager.getObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.aliases);
        }
        return objPC.aliases;
    }

    private static void dnSetaliases(LocalRepository objPC, Set val) {
        if (objPC.dnStateManager == null) {
            objPC.aliases = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.aliases, (Object)val);
        }
    }

    private static byte[] dnGetprivateKey(LocalRepository objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return (byte[])objPC.dnStateManager.getObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.privateKey);
        }
        return objPC.privateKey;
    }

    private static void dnSetprivateKey(LocalRepository objPC, byte[] val) {
        if (objPC.dnStateManager == null) {
            objPC.privateKey = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.privateKey, (Object)val);
        }
    }

    private static Directory dnGetroot(LocalRepository objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return (Directory)objPC.dnStateManager.getObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.root);
        }
        return objPC.root;
    }

    private static void dnSetroot(LocalRepository objPC, Directory val) {
        if (objPC.dnStateManager == null) {
            objPC.root = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2 + dnInheritedFieldCount, (Object)objPC.root, (Object)val);
        }
    }
}

