/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.invitation.accept.source;

import co.codewizards.cloudstore.core.Severity;
import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.io.ByteArrayOutputStream;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.ls.client.LocalServerClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.RowConstraints;
import javafx.stage.Window;
import org.subshare.core.file.DataFileFilter;
import org.subshare.core.file.EncryptedDataFile;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpDecoder;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.PgpKeyValidity;
import org.subshare.gui.IconSize;
import org.subshare.gui.filetree.FileTreePane;
import org.subshare.gui.invitation.accept.AcceptInvitationData;
import org.subshare.gui.invitation.accept.source.CheckInvitationFileResult;
import org.subshare.gui.invitation.accept.source.ImportSigningKeyProblemSolver;
import org.subshare.gui.invitation.accept.source.ProblemSolver;
import org.subshare.gui.ls.PgpLs;
import org.subshare.gui.severity.SeverityImageRegistry;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.util.PlatformUtil;
import org.subshare.gui.wizard.WizardPageContentGridPane;

public class AcceptInvitationSourcePane
extends WizardPageContentGridPane {
    private final AcceptInvitationData acceptInvitationData;
    private static final AtomicInteger nextThreadId = new AtomicInteger();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(final Runnable r) {
            return new Thread(AcceptInvitationSourcePane.class.getSimpleName() + '@' + nextThreadId.getAndIncrement() + ".executorServiceThread"){

                @Override
                public void run() {
                    r.run();
                }
            };
        }
    });
    private static List<Class<? extends ProblemSolver>> problemSolverClasses = Arrays.asList(ImportSigningKeyProblemSolver.class);
    @FXML
    private FileTreePane fileTreePane;
    @FXML
    private HBox statusMessageBox;
    private final RowConstraints statusMessageBoxRowConstraints = new RowConstraints(0.0, 0.0, 0.0);
    @FXML
    private Label statusMessageLabel;
    @FXML
    private Button solveProblemButton;
    private ProblemSolver problemSolver;
    private final ObjectProperty<CheckInvitationFileResult> checkInvitationFileResult = new SimpleObjectProperty<CheckInvitationFileResult>((Object)this, "checkInvitationFileResult"){

        public void set(CheckInvitationFileResult newValue) {
            PlatformUtil.assertFxApplicationThread();
            super.set((Object)newValue);
            AcceptInvitationSourcePane.this.problemSolver = AcceptInvitationSourcePane.this.determineProblemSolver();
            AcceptInvitationSourcePane.this.updateStatusMessageBox();
        }
    };

    public AcceptInvitationSourcePane(AcceptInvitationData acceptInvitationData) {
        this.acceptInvitationData = (AcceptInvitationData)AssertUtil.assertNotNull((Object)acceptInvitationData, (String)"acceptInvitationData");
        FxmlUtil.loadDynamicComponentFxml(AcceptInvitationSourcePane.class, this);
        this.fileTreePane.fileFilterProperty().set((Object)new DataFileFilter().setAcceptContentType("application/vnd.subshare.encrypted"));
        this.fileTreePane.getSelectedFiles().addListener(observable -> this.onSelectedFilesChanged());
        this.getRowConstraints().add((Object)new RowConstraints());
        this.getRowConstraints().add((Object)new RowConstraints());
        this.getRowConstraints().add((Object)this.statusMessageBoxRowConstraints);
        this.onSelectedFilesChanged();
        this.updateStatusMessageBox();
    }

    private void updateStatusMessageBox() {
        CheckInvitationFileResult cifResult = (CheckInvitationFileResult)this.checkInvitationFileResult.get();
        Severity severity = cifResult == null ? Severity.INFO : cifResult.getSeverity();
        String msg = cifResult == null ? null : cifResult.getMessage();
        String lt = cifResult == null ? null : cifResult.getLongText();
        Image severityImage = SeverityImageRegistry.getInstance().getImage(severity, IconSize._24x24);
        this.statusMessageLabel.setGraphic((Node)(severityImage == null ? null : new ImageView(severityImage)));
        this.statusMessageLabel.setText(msg);
        this.statusMessageLabel.setTooltip(StringUtil.isEmpty((String)lt) ? null : new Tooltip(lt));
        this.statusMessageBox.setVisible(!StringUtil.isEmpty((String)msg));
        this.statusMessageBoxRowConstraints.setMinHeight(StringUtil.isEmpty((String)msg) ? 0.0 : -1.0);
        this.statusMessageBoxRowConstraints.setMaxHeight(StringUtil.isEmpty((String)msg) ? 0.0 : -1.0);
        this.statusMessageBoxRowConstraints.setPrefHeight(StringUtil.isEmpty((String)msg) ? 0.0 : -1.0);
        if (this.problemSolver == null) {
            this.statusMessageBox.getChildren().remove((Object)this.solveProblemButton);
        } else {
            this.statusMessageBox.getChildren().add((Object)this.solveProblemButton);
        }
    }

    protected List<ProblemSolver> createProblemSolvers() {
        ArrayList<ProblemSolver> problemSolvers = new ArrayList<ProblemSolver>(problemSolverClasses.size());
        for (Class<? extends ProblemSolver> problemSolverClass : problemSolverClasses) {
            ProblemSolver problemSolver;
            try {
                problemSolver = problemSolverClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            problemSolver.setInvitationFile(this.getSelectedFile());
            problemSolver.setCheckInvitationFileResult(this.getCheckInvitationFileResult());
            problemSolvers.add(problemSolver);
        }
        Collections.sort(problemSolvers, new Comparator<ProblemSolver>(){

            @Override
            public int compare(ProblemSolver o1, ProblemSolver o2) {
                int res = -1 * Integer.compare(o1.getPriority(), o2.getPriority());
                if (res != 0) {
                    return res;
                }
                res = o1.getClass().getName().compareTo(o2.getClass().getName());
                return res;
            }
        });
        return problemSolvers;
    }

    protected ProblemSolver determineProblemSolver() {
        if (this.getSelectedFile() == null || this.getCheckInvitationFileResult() == null) {
            return null;
        }
        for (ProblemSolver problemSolver : this.createProblemSolvers()) {
            if (!problemSolver.canSolveProblem()) continue;
            return problemSolver;
        }
        return null;
    }

    @Override
    protected boolean isComplete() {
        return this.acceptInvitationData.getInvitationFile() != null;
    }

    protected void onSelectedFilesChanged() {
        File file = this.getSelectedFile();
        if (file != null && !file.isFile()) {
            file = null;
        }
        this.checkSelectedFileAsync(file);
    }

    protected File getSelectedFile() {
        Iterator selectedFilesIterator = this.fileTreePane.getSelectedFiles().iterator();
        return selectedFilesIterator.hasNext() ? (File)selectedFilesIterator.next() : null;
    }

    protected void checkSelectedFileAsync(File file) {
        this.acceptInvitationData.setInvitationFile(null);
        this.updateComplete();
        if (file == null) {
            this.setCheckInvitationFileResult(null);
            return;
        }
        this.setCheckInvitationFileResult(new CheckInvitationFileResult(CheckInvitationFileResult.Type.OK, Severity.INFO, "Checking the selected file...", null));
        this.executorService.submit(() -> {
            try {
                if (!file.equals(this.getSelectedFile())) {
                    return;
                }
                CheckInvitationFileResult checkInvitationFileResult = this.checkSelectedFile(file);
                Platform.runLater(() -> {
                    if (!file.equals(this.getSelectedFile())) {
                        return;
                    }
                    if (CheckInvitationFileResult.Type.ERROR_GENERAL.compareTo(checkInvitationFileResult.getType()) > 0) {
                        this.acceptInvitationData.setInvitationFile(file);
                    }
                    this.setCheckInvitationFileResult(checkInvitationFileResult);
                    this.updateComplete();
                });
            }
            catch (Exception x) {
                Platform.runLater(() -> {
                    if (!file.equals(this.getSelectedFile())) {
                        return;
                    }
                    this.setCheckInvitationFileResult(new CheckInvitationFileResult(CheckInvitationFileResult.Type.ERROR_GENERAL, Severity.ERROR, "Failed to decrypt the selected file!", x.getLocalizedMessage()));
                });
            }
        });
    }

    public CheckInvitationFileResult getCheckInvitationFileResult() {
        return (CheckInvitationFileResult)this.checkInvitationFileResult.get();
    }

    public void setCheckInvitationFileResult(CheckInvitationFileResult checkInvitationFileResult) {
        this.checkInvitationFileResult.set((Object)checkInvitationFileResult);
    }

    private CheckInvitationFileResult checkSelectedFile(File file) throws Exception {
        LocalServerClient lsc = LocalServerClient.getInstance();
        Pgp pgp = PgpLs.getPgpOrFail();
        try (InputStream in = StreamUtil.castStream((IInputStream)file.createInputStream());){
            EncryptedDataFile encryptedDataFile = new EncryptedDataFile(in);
            byte[] defaultData = encryptedDataFile.getDefaultData();
            if (defaultData == null) {
                throw new IllegalArgumentException("No 'defaultData' item found in file!");
            }
            Object defaultDataIn = lsc.invokeConstructor(ByteArrayInputStream.class, new Object[]{defaultData});
            Object decryptedOut = lsc.invokeConstructor(ByteArrayOutputStream.class, new Object[0]);
            PgpDecoder decoder = (PgpDecoder)lsc.invoke((Object)pgp, "createDecoder", new Object[]{defaultDataIn, decryptedOut});
            decoder.setFailOnMissingSignPgpKey(false);
            decoder.decode();
            byte[] decrypted = (byte[])lsc.invoke(decryptedOut, "toByteArray", new Object[0]);
            ZipInputStream zin = new ZipInputStream((InputStream)new ByteArrayInputStream(decrypted));
            this.readManifest(zin);
            if (decoder.getPgpSignature() != null) {
                PgpKeyId pgpKeyId = (PgpKeyId)AssertUtil.assertNotNull((Object)decoder.getPgpSignature().getPgpKeyId(), (String)"pgpSignature.pgpKeyId");
                PgpKey pgpKey = (PgpKey)AssertUtil.assertNotNull((Object)pgp.getPgpKey(pgpKeyId), (String)("pgp.getPgpKey(" + pgpKeyId + ")"));
                String primaryUserId = pgpKey.getUserIds().isEmpty() ? "<<unknown>>" : (String)pgpKey.getUserIds().get(0);
                PgpKeyValidity keyValidity = pgp.getKeyValidity(pgpKey);
                switch (keyValidity) {
                    case EXPIRED: {
                        CheckInvitationFileResult checkInvitationFileResult = new CheckInvitationFileResult(CheckInvitationFileResult.Type.SIGNING_KEY_EXPIRED, Severity.ERROR, "Signing key expired!", String.format("The key '%s' (%s), which was used to sign this invitation, already expired!", pgpKeyId.toHumanString(), primaryUserId));
                        return checkInvitationFileResult;
                    }
                    case REVOKED: {
                        CheckInvitationFileResult checkInvitationFileResult = new CheckInvitationFileResult(CheckInvitationFileResult.Type.SIGNING_KEY_REVOKED, Severity.ERROR, "Signing key revoked!", String.format("The key '%s' (%s), which was used to sign this invitation, was revoked!", pgpKeyId.toHumanString(), primaryUserId));
                        return checkInvitationFileResult;
                    }
                    case NOT_TRUSTED: {
                        CheckInvitationFileResult checkInvitationFileResult = new CheckInvitationFileResult(CheckInvitationFileResult.Type.SIGNING_KEY_NOT_TRUSTED, Severity.ERROR, "Signing key not trusted!", String.format("The key '%s' (%s), which was used to sign this invitation, is not trusted!", pgpKeyId.toHumanString(), primaryUserId));
                        return checkInvitationFileResult;
                    }
                    case DISABLED: {
                        CheckInvitationFileResult checkInvitationFileResult = new CheckInvitationFileResult(CheckInvitationFileResult.Type.SIGNING_KEY_DISABLED, Severity.ERROR, "Signing key disabled!", String.format("The key '%s' (%s), which was used to sign this invitation, is disabled!", pgpKeyId.toHumanString(), primaryUserId));
                        return checkInvitationFileResult;
                    }
                    case MARGINAL: {
                        CheckInvitationFileResult checkInvitationFileResult = new CheckInvitationFileResult(CheckInvitationFileResult.Type.SIGNING_KEY_MARGINALLY_TRUSTED, Severity.INFO, "Signing key only marginally trusted!", String.format("The key '%s' (%s), which was used to sign this invitation, is only marginally trusted!", pgpKeyId.toHumanString(), primaryUserId));
                        return checkInvitationFileResult;
                    }
                    case FULL: 
                    case ULTIMATE: {
                        CheckInvitationFileResult checkInvitationFileResult = new CheckInvitationFileResult(CheckInvitationFileResult.Type.OK, Severity.INFO);
                        return checkInvitationFileResult;
                    }
                }
                CheckInvitationFileResult checkInvitationFileResult = new CheckInvitationFileResult(CheckInvitationFileResult.Type.SIGNING_KEY_UNKNOWN_VALIDITY, Severity.WARNING, String.format("Unknown key-validity: %s", keyValidity), null);
                return checkInvitationFileResult;
            }
            if (decoder.getSignPgpKeyIds().isEmpty()) {
                CheckInvitationFileResult checkInvitationFileResult = new CheckInvitationFileResult(CheckInvitationFileResult.Type.ERROR_SIGNATURE_MISSING, Severity.ERROR, "The invitation is not signed!", "The invitation token is not signed at all! A signature is required.");
                return checkInvitationFileResult;
            }
            CheckInvitationFileResult checkInvitationFileResult = new CheckInvitationFileResult(CheckInvitationFileResult.Type.SIGNING_KEY_MISSING, Severity.WARNING, "Signature could not be verified!", String.format("The invitation token is signed by the PGP keys %s, but none of these PGP keys is in our key ring.\n\nIt is probably included in the invitation, but we cannot check this, now (not implemented, yet, sorry).", decoder.getSignPgpKeyIds()));
            return checkInvitationFileResult;
        }
    }

    private Properties readManifest(ZipInputStream zin) throws IOException {
        AssertUtil.assertNotNull((Object)zin, (String)"zin");
        ZipEntry ze = zin.getNextEntry();
        if (ze == null) {
            throw new IllegalArgumentException(String.format("userRepoInvitationData is not valid: It lacks the '%s' as very first zip-entry (there is no first ZipEntry)!", "MANIFEST.properties"));
        }
        if (!"MANIFEST.properties".equals(ze.getName())) {
            throw new IllegalArgumentException(String.format("userRepoInvitationData is not valid: The very first zip-entry is not '%s' (it is '%s' instead)!", "MANIFEST.properties", ze.getName()));
        }
        Properties properties = new Properties();
        properties.load(zin);
        String contentType = properties.getProperty("contentType");
        if (!"application/vnd.subshare.user-repo-invitation".equals(contentType)) {
            throw new IllegalArgumentException(String.format("userRepoInvitationData is not valid: The manifest indicates the content-type '%s', but '%s' is expected!", contentType, "application/vnd.subshare.user-repo-invitation"));
        }
        return properties;
    }

    public void requestFocus() {
        super.requestFocus();
        this.fileTreePane.requestFocus();
    }

    @FXML
    private void solveProblemButtonClicked(ActionEvent event) {
        AssertUtil.assertNotNull((Object)this.problemSolver, (String)"problemSolver");
        this.problemSolver.setWindow((Window)AssertUtil.assertNotNull((Object)this.getScene().getWindow(), (String)"scene.window"));
        this.problemSolver.solveProblem();
        this.onSelectedFilesChanged();
    }
}

