/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.createkey.userid;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.Callback;
import org.subshare.core.pgp.CreatePgpKeyParam;
import org.subshare.core.pgp.PgpUserId;
import org.subshare.gui.pgp.createkey.FxPgpUserId;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.wizard.WizardPageContentGridPane;

public class UserIdPane
extends WizardPageContentGridPane {
    private final CreatePgpKeyParam createPgpKeyParam;
    @FXML
    private TableView<FxPgpUserId> userIdsTableView;
    @FXML
    private TableColumn<FxPgpUserId, String> nameTableColumn;
    @FXML
    private TableColumn<FxPgpUserId, String> emailTableColumn;
    private final PropertyChangeListener pgpUserIdsPropertyChangeListener = event -> Platform.runLater(() -> this.updateEmailsTableViewItems());

    public UserIdPane(CreatePgpKeyParam createPgpKeyParam) {
        this.createPgpKeyParam = (CreatePgpKeyParam)AssertUtil.assertNotNull((Object)createPgpKeyParam, (String)"createPgpKeyParam");
        FxmlUtil.loadDynamicComponentFxml(UserIdPane.class, this);
        for (PgpUserId pgpUserId : createPgpKeyParam.getUserIds()) {
            pgpUserId.addPropertyChangeListener(this.pgpUserIdsPropertyChangeListener);
        }
        this.userIdsTableView.setItems(FXCollections.observableList((List)((List)Util.cast((Object)createPgpKeyParam.getUserIds()))));
        this.userIdsTableView.getItems().addListener(observable -> this.updateComplete());
        this.nameTableColumn.setCellFactory((Callback)Util.cast((Object)TextFieldTableCell.forTableColumn()));
        this.emailTableColumn.setCellFactory((Callback)Util.cast((Object)TextFieldTableCell.forTableColumn()));
        this.updateEmailsTableViewItems();
    }

    private void updateEmailsTableViewItems() {
        ObservableList items = this.userIdsTableView.getItems();
        ArrayList<FxPgpUserId> itemsToRemove = new ArrayList<FxPgpUserId>();
        Iterator it = items.iterator();
        while (it.hasNext()) {
            FxPgpUserId fxPgpUserId = (FxPgpUserId)((Object)it.next());
            if (!it.hasNext() || !fxPgpUserId.isEmpty()) continue;
            fxPgpUserId.removePropertyChangeListener(this.pgpUserIdsPropertyChangeListener);
            itemsToRemove.add(fxPgpUserId);
        }
        items.removeAll(itemsToRemove);
        if (items.isEmpty() || !((FxPgpUserId)((Object)items.get(items.size() - 1))).isEmpty()) {
            FxPgpUserId fxPgpUserId = new FxPgpUserId();
            fxPgpUserId.addPropertyChangeListener(this.pgpUserIdsPropertyChangeListener);
            items.add((Object)fxPgpUserId);
        }
    }

    @Override
    protected boolean isComplete() {
        int nonEmptyPgpUserIdCount = 0;
        for (PgpUserId pgpUserId : this.createPgpKeyParam.getUserIds()) {
            if (pgpUserId.isEmpty()) continue;
            ++nonEmptyPgpUserIdCount;
        }
        boolean complete = nonEmptyPgpUserIdCount > 0;
        return complete;
    }

    public void requestFocus() {
        super.requestFocus();
        this.userIdsTableView.requestFocus();
    }
}

