/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.dto.split;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.DebugUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.dto.CollisionDto;
import org.subshare.core.dto.CryptoChangeSetDto;
import org.subshare.core.dto.CryptoConfigPropSetDto;
import org.subshare.core.dto.CryptoKeyDto;
import org.subshare.core.dto.CryptoKeyRole;
import org.subshare.core.dto.CryptoLinkDto;
import org.subshare.core.dto.CryptoRepoFileDto;
import org.subshare.core.dto.CurrentHistoCryptoRepoFileDto;
import org.subshare.core.dto.DeletedCollisionDto;
import org.subshare.core.dto.HistoCryptoRepoFileDto;
import org.subshare.core.dto.HistoFrameDto;
import org.subshare.core.dto.PermissionDto;
import org.subshare.core.dto.PermissionSetDto;
import org.subshare.core.dto.PermissionSetInheritanceDto;
import org.subshare.core.dto.UserIdentityDto;
import org.subshare.core.dto.UserIdentityLinkDto;
import org.subshare.core.dto.UserRepoKeyPublicKeyDto;
import org.subshare.core.dto.UserRepoKeyPublicKeyReplacementRequestDeletionDto;
import org.subshare.core.dto.UserRepoKeyPublicKeyReplacementRequestDto;

public class CryptoChangeSetDtoSplitter {
    private static final Logger logger = LoggerFactory.getLogger(CryptoChangeSetDtoSplitter.class);
    public static final String CONFIG_KEY_MAX_CRYPTO_CHANGE_SET_DTO_SIZE = "maxCryptoChangeSetDtoSize";
    public static final int DEFAULT_MAX_CRYPTO_CHANGE_SET_DTO_SIZE = 1000;
    private final int maxCryptoChangeSetDtoSize;
    private boolean destroyInput;
    private final CryptoChangeSetDto inCryptoChangeSetDto;
    private List<CryptoChangeSetDto> outCryptoChangeSetDtos;
    private CryptoChangeSetDto outCryptoChangeSetDto;
    private Set<Uid> cryptoRepoFileIdsProcessed;
    private Set<Uid> cryptoKeyIdsProcessed;
    private Set<Uid> cryptoLinkIdsProcessed;
    private Set<Uid> currentHistoCryptoRepoFileIdsProcessed;
    private CryptoRepoFileDto rootCryptoRepoFileDto;
    private Map<Uid, CurrentHistoCryptoRepoFileDto> cryptoRepoFileId2CurrentHistoCryptoRepoFileDto;
    private Map<Uid, CryptoRepoFileDto> cryptoRepoFileId2CryptoRepoFileDto;
    private Map<Uid, CryptoKeyDto> cryptoKeyId2CryptoKeyDto;
    private Map<Uid, List<CryptoLinkDto>> toCryptoKeyId2CryptoLinkDtos;
    private Set<Uid> histoFrameIdsProcessed;
    private Set<Uid> histoCryptoRepoFileIdsProcessed;
    private Map<Uid, HistoFrameDto> histoFrameId2HistoFrameDto;
    private Map<Uid, HistoCryptoRepoFileDto> histoCryptoRepoFileId2HistoCryptoRepoFileDto;

    protected CryptoChangeSetDtoSplitter(CryptoChangeSetDto inCryptoChangeSetDto) {
        this.inCryptoChangeSetDto = (CryptoChangeSetDto)AssertUtil.assertNotNull((Object)inCryptoChangeSetDto, (String)"inCryptoChangeSetDto");
        this.maxCryptoChangeSetDtoSize = ConfigImpl.getInstance().getPropertyAsInt(CONFIG_KEY_MAX_CRYPTO_CHANGE_SET_DTO_SIZE, 1000);
    }

    public static CryptoChangeSetDtoSplitter createInstance(CryptoChangeSetDto inCryptoChangeSetDto) {
        return new CryptoChangeSetDtoSplitter(inCryptoChangeSetDto);
    }

    public CryptoChangeSetDtoSplitter split() {
        this.outCryptoChangeSetDtos = new ArrayList<CryptoChangeSetDto>();
        this.cryptoRepoFileIdsProcessed = new HashSet<Uid>();
        this.cryptoKeyIdsProcessed = new HashSet<Uid>();
        this.cryptoLinkIdsProcessed = new HashSet<Uid>();
        this.buildCryptoRepoFileId2CryptoRepoFileDto();
        this.buildCryptoKeyId2CryptoKeyDto();
        this.buildToCryptoKeyId2CryptoLinkDtos();
        this.addOutRepositoryOwnerDto();
        this.addOutUserRepoKeyPublicKeyDtos();
        this.addOutUserRepoKeyPublicKeyReplacementRequestDtos();
        this.addOutPermissionSetDtos();
        this.addOutPermissionDtos();
        this.addOutPermissionSetInheritanceDtos();
        this.addOutUserIdentityDtos();
        this.addOutUserIdentityLinkDtos();
        this.addOutRootCryptoRepoFileDto();
        if (this.outCryptoChangeSetDtos.size() > 1) {
            throw new IllegalStateException("More than one out-CryptoChangeSetDto for the essentials!");
        }
        if (this.outCryptoChangeSetDto != null && !this.outCryptoChangeSetDto.isEmpty()) {
            this.outCryptoChangeSetDto = null;
        }
        this.rootCryptoRepoFileDto = null;
        this.addOutCryptoRepoFileDtos();
        this.addOutCryptoLinkDtos();
        this.addOutCryptoKeyDtos();
        this.cryptoRepoFileIdsProcessed = null;
        this.cryptoKeyIdsProcessed = null;
        this.cryptoLinkIdsProcessed = null;
        this.cryptoRepoFileId2CryptoRepoFileDto = null;
        this.cryptoKeyId2CryptoKeyDto = null;
        this.toCryptoKeyId2CryptoLinkDtos = null;
        this.histoFrameIdsProcessed = new HashSet<Uid>();
        this.histoCryptoRepoFileIdsProcessed = new HashSet<Uid>();
        this.currentHistoCryptoRepoFileIdsProcessed = new HashSet<Uid>();
        this.buildHistoFrameId2HistoFrameDto();
        this.buildHistoCryptoRepoFileId2HistoCryptoRepoFileDto();
        this.buildCryptoRepoFileId2CurrentHistoCryptoRepoFileDto();
        this.addOutHistoFrameDtos();
        this.addOutCurrentHistoCryptoRepoFileDtos();
        this.addOutHistoCryptoRepoFileDtos();
        this.histoFrameIdsProcessed = null;
        this.histoCryptoRepoFileIdsProcessed = null;
        this.currentHistoCryptoRepoFileIdsProcessed = null;
        this.histoFrameId2HistoFrameDto = null;
        this.histoCryptoRepoFileId2HistoCryptoRepoFileDto = null;
        this.cryptoRepoFileId2CurrentHistoCryptoRepoFileDto = null;
        this.addOutCollisionDtos();
        this.addOutDeletedCollisionDtos();
        this.addOutCryptoConfigPropSetDtos();
        this.addOutUserRepoKeyPublicKeyReplacementRequestDeletionDtos();
        this.deleteEmptyOutCryptoChangeSetDto();
        this.updateMultiPartCount();
        if (this.destroyInput && !this.inCryptoChangeSetDto.isEmpty()) {
            throw new IllegalStateException("inCryptoChangeSetDto is not empty!");
        }
        return this;
    }

    private void addOutRootCryptoRepoFileDto() {
        if (this.rootCryptoRepoFileDto != null) {
            this.prepareOutCryptoChangeSetDto();
            this.addOutCryptoRepoFileDto(this.rootCryptoRepoFileDto);
        }
    }

    private void addOutRepositoryOwnerDto() {
        if (this.inCryptoChangeSetDto.getRepositoryOwnerDto() != null) {
            this.prepareOutCryptoChangeSetDto();
            this.outCryptoChangeSetDto.setRepositoryOwnerDto(this.inCryptoChangeSetDto.getRepositoryOwnerDto());
        }
        if (this.destroyInput) {
            this.inCryptoChangeSetDto.setRepositoryOwnerDto(null);
        }
    }

    private void addOutPermissionSetDtos() {
        for (PermissionSetDto dto : this.inCryptoChangeSetDto.getPermissionSetDtos()) {
            this.prepareOutCryptoChangeSetDto();
            this.addOutPermissionSetDto(dto);
        }
        if (this.destroyInput) {
            this.inCryptoChangeSetDto.setPermissionSetDtos(null);
        }
    }

    private void addOutPermissionDtos() {
        for (PermissionDto dto : this.inCryptoChangeSetDto.getPermissionDtos()) {
            this.prepareOutCryptoChangeSetDto();
            this.addOutPermissionDto(dto);
        }
        if (this.destroyInput) {
            this.inCryptoChangeSetDto.setPermissionDtos(null);
        }
    }

    private void addOutPermissionSetInheritanceDtos() {
        for (PermissionSetInheritanceDto dto : this.inCryptoChangeSetDto.getPermissionSetInheritanceDtos()) {
            this.prepareOutCryptoChangeSetDto();
            this.addOutPermissionSetInheritanceDto(dto);
        }
        if (this.destroyInput) {
            this.inCryptoChangeSetDto.setPermissionSetInheritanceDtos(null);
        }
    }

    private void addOutUserRepoKeyPublicKeyReplacementRequestDtos() {
        for (UserRepoKeyPublicKeyReplacementRequestDto dto : this.inCryptoChangeSetDto.getUserRepoKeyPublicKeyReplacementRequestDtos()) {
            this.prepareOutCryptoChangeSetDto();
            this.addOutUserRepoKeyPublicKeyReplacementRequestDto(dto);
        }
        if (this.destroyInput) {
            this.inCryptoChangeSetDto.setUserRepoKeyPublicKeyReplacementRequestDtos(null);
        }
    }

    private void addOutUserIdentityDtos() {
        for (UserIdentityDto dto : this.inCryptoChangeSetDto.getUserIdentityDtos()) {
            this.prepareOutCryptoChangeSetDto();
            this.addOutUserIdentityDto(dto);
        }
        if (this.destroyInput) {
            this.inCryptoChangeSetDto.setUserIdentityDtos(null);
        }
    }

    private void addOutUserIdentityLinkDtos() {
        for (UserIdentityLinkDto dto : this.inCryptoChangeSetDto.getUserIdentityLinkDtos()) {
            this.prepareOutCryptoChangeSetDto();
            this.addOutUserIdentityLinkDto(dto);
        }
        if (this.destroyInput) {
            this.inCryptoChangeSetDto.setUserIdentityLinkDtos(null);
        }
    }

    private void addOutUserRepoKeyPublicKeyDtos() {
        for (UserRepoKeyPublicKeyDto dto : this.inCryptoChangeSetDto.getUserRepoKeyPublicKeyDtos()) {
            this.prepareOutCryptoChangeSetDto();
            this.outCryptoChangeSetDto.getUserRepoKeyPublicKeyDtos().add(dto);
        }
        if (this.destroyInput) {
            this.inCryptoChangeSetDto.setUserRepoKeyPublicKeyDtos(null);
        }
    }

    private void addOutCryptoRepoFileDtos() {
        for (CryptoRepoFileDto dto : this.inCryptoChangeSetDto.getCryptoRepoFileDtos()) {
            this.nextOrCurrentOutCryptoChangeSetDto();
            this.addOutCryptoRepoFileDto(dto);
        }
        if (this.destroyInput) {
            this.inCryptoChangeSetDto.setCryptoRepoFileDtos(null);
        }
    }

    private void addOutCryptoLinkDtos() {
        for (CryptoLinkDto dto : this.inCryptoChangeSetDto.getCryptoLinkDtos()) {
            this.nextOrCurrentOutCryptoChangeSetDto();
            this.addOutCryptoLinkDto(dto);
        }
        if (this.destroyInput) {
            this.inCryptoChangeSetDto.setCryptoLinkDtos(null);
        }
    }

    private void addOutCryptoKeyDtos() {
        for (CryptoKeyDto dto : this.inCryptoChangeSetDto.getCryptoKeyDtos()) {
            this.nextOrCurrentOutCryptoChangeSetDto();
            this.addOutCryptoKeyDto(dto);
        }
        if (this.destroyInput) {
            this.inCryptoChangeSetDto.setCryptoKeyDtos(null);
        }
    }

    private void addOutHistoCryptoRepoFileDtos() {
        for (HistoCryptoRepoFileDto dto : this.inCryptoChangeSetDto.getHistoCryptoRepoFileDtos()) {
            this.nextOrCurrentOutCryptoChangeSetDto();
            this.addOutHistoCryptoRepoFileDto(dto);
        }
        if (this.destroyInput) {
            this.inCryptoChangeSetDto.setHistoCryptoRepoFileDtos(null);
        }
    }

    private void addOutCurrentHistoCryptoRepoFileDtos() {
        for (CurrentHistoCryptoRepoFileDto dto : this.inCryptoChangeSetDto.getCurrentHistoCryptoRepoFileDtos()) {
            this.nextOrCurrentOutCryptoChangeSetDto();
            this.addOutCurrentHistoCryptoRepoFileDto(dto);
        }
        if (this.destroyInput) {
            this.inCryptoChangeSetDto.setCurrentHistoCryptoRepoFileDtos(null);
        }
    }

    private void addOutHistoFrameDtos() {
        for (HistoFrameDto dto : this.inCryptoChangeSetDto.getHistoFrameDtos()) {
            this.nextOrCurrentOutCryptoChangeSetDto();
            this.addOutHistoFrameDto(dto);
        }
        if (this.destroyInput) {
            this.inCryptoChangeSetDto.setHistoFrameDtos(null);
        }
    }

    private void addOutCollisionDtos() {
        for (CollisionDto dto : this.inCryptoChangeSetDto.getCollisionDtos()) {
            this.nextOrCurrentOutCryptoChangeSetDto();
            this.addOutCollisionDto(dto);
        }
        if (this.destroyInput) {
            this.inCryptoChangeSetDto.setCollisionDtos(null);
        }
    }

    private void addOutDeletedCollisionDtos() {
        for (DeletedCollisionDto dto : this.inCryptoChangeSetDto.getDeletedCollisionDtos()) {
            this.nextOrCurrentOutCryptoChangeSetDto();
            this.addOutDeletedCollisionDto(dto);
        }
        if (this.destroyInput) {
            this.inCryptoChangeSetDto.setDeletedCollisionDtos(null);
        }
    }

    private void addOutCryptoConfigPropSetDtos() {
        for (CryptoConfigPropSetDto dto : this.inCryptoChangeSetDto.getCryptoConfigPropSetDtos()) {
            this.nextOrCurrentOutCryptoChangeSetDto();
            this.addOutCryptoConfigPropSetDto(dto);
        }
        if (this.destroyInput) {
            this.inCryptoChangeSetDto.setCryptoConfigPropSetDtos(null);
        }
    }

    private void addOutUserRepoKeyPublicKeyReplacementRequestDeletionDtos() {
        for (UserRepoKeyPublicKeyReplacementRequestDeletionDto dto : this.inCryptoChangeSetDto.getUserRepoKeyPublicKeyReplacementRequestDeletionDtos()) {
            this.nextOrCurrentOutCryptoChangeSetDto();
            this.addOutUserRepoKeyPublicKeyReplacementRequestDeletionDto(dto);
        }
        if (this.destroyInput) {
            this.inCryptoChangeSetDto.setUserRepoKeyPublicKeyReplacementRequestDeletionDtos(null);
        }
    }

    private void addOutPermissionSetDto(PermissionSetDto dto) {
        AssertUtil.assertNotNull((Object)dto, (String)"dto");
        Uid cryptoRepoFileId = (Uid)AssertUtil.assertNotNull((Object)dto.getCryptoRepoFileId(), (String)"permissionSetDto.cryptoRepoFileId");
        CryptoRepoFileDto cryptoRepoFileDto = this.cryptoRepoFileId2CryptoRepoFileDto.get(cryptoRepoFileId);
        if (cryptoRepoFileDto != null) {
            this.addOutCryptoRepoFileDto(cryptoRepoFileDto);
        }
        this.outCryptoChangeSetDto.getPermissionSetDtos().add(dto);
    }

    private void addOutPermissionDto(PermissionDto dto) {
        AssertUtil.assertNotNull((Object)dto, (String)"dto");
        Uid cryptoRepoFileId = (Uid)AssertUtil.assertNotNull((Object)dto.getCryptoRepoFileId(), (String)"permissionDto.cryptoRepoFileId");
        CryptoRepoFileDto cryptoRepoFileDto = this.cryptoRepoFileId2CryptoRepoFileDto.get(cryptoRepoFileId);
        if (cryptoRepoFileDto != null) {
            this.addOutCryptoRepoFileDto(cryptoRepoFileDto);
        }
        this.outCryptoChangeSetDto.getPermissionDtos().add(dto);
    }

    private void addOutPermissionSetInheritanceDto(PermissionSetInheritanceDto dto) {
        AssertUtil.assertNotNull((Object)dto, (String)"dto");
        Uid cryptoRepoFileId = (Uid)AssertUtil.assertNotNull((Object)dto.getCryptoRepoFileId(), (String)"permissionSetInheritanceDto.cryptoRepoFileId");
        CryptoRepoFileDto cryptoRepoFileDto = this.cryptoRepoFileId2CryptoRepoFileDto.get(cryptoRepoFileId);
        if (cryptoRepoFileDto != null) {
            this.addOutCryptoRepoFileDto(cryptoRepoFileDto);
        }
        this.outCryptoChangeSetDto.getPermissionSetInheritanceDtos().add(dto);
    }

    private void addOutUserRepoKeyPublicKeyReplacementRequestDto(UserRepoKeyPublicKeyReplacementRequestDto dto) {
        AssertUtil.assertNotNull((Object)dto, (String)"dto");
        this.outCryptoChangeSetDto.getUserRepoKeyPublicKeyReplacementRequestDtos().add(dto);
    }

    private void addOutUserIdentityDto(UserIdentityDto dto) {
        AssertUtil.assertNotNull((Object)dto, (String)"dto");
        this.outCryptoChangeSetDto.getUserIdentityDtos().add(dto);
    }

    private void addOutUserIdentityLinkDto(UserIdentityLinkDto dto) {
        AssertUtil.assertNotNull((Object)dto, (String)"dto");
        this.outCryptoChangeSetDto.getUserIdentityLinkDtos().add(dto);
    }

    private void addOutCryptoRepoFileDto(CryptoRepoFileDto dto) {
        CryptoRepoFileDto parentDto;
        Uid parentCryptoRepoFileId;
        AssertUtil.assertNotNull((Object)dto, (String)"dto");
        Uid cryptoRepoFileId = (Uid)AssertUtil.assertNotNull((Object)dto.getCryptoRepoFileId(), (String)"cryptoRepoFileDto.cryptoRepoFileId");
        if (!this.cryptoRepoFileIdsProcessed.add(cryptoRepoFileId)) {
            return;
        }
        Uid cryptoKeyId = (Uid)AssertUtil.assertNotNull((Object)dto.getCryptoKeyId(), (String)"cryptoRepoFileDto.cryptoKeyId");
        CryptoKeyDto cryptoKeyDto = this.cryptoKeyId2CryptoKeyDto.get(cryptoKeyId);
        if (cryptoKeyDto != null) {
            this.addOutCryptoKeyDto(cryptoKeyDto);
        }
        if ((parentCryptoRepoFileId = dto.getParentCryptoRepoFileId()) != null && (parentDto = this.cryptoRepoFileId2CryptoRepoFileDto.get(parentCryptoRepoFileId)) != null) {
            this.addOutCryptoRepoFileDto(parentDto);
        }
        this.outCryptoChangeSetDto.getCryptoRepoFileDtos().add(dto);
    }

    private void addOutCryptoKeyDto(CryptoKeyDto dto) {
        List<CryptoLinkDto> cryptoLinkDtos;
        AssertUtil.assertNotNull((Object)dto, (String)"dto");
        Uid cryptoKeyId = (Uid)AssertUtil.assertNotNull((Object)dto.getCryptoKeyId(), (String)"cryptoKeyDto.cryptoKeyId");
        if (!this.cryptoKeyIdsProcessed.add(cryptoKeyId)) {
            return;
        }
        Uid cryptoRepoFileId = (Uid)AssertUtil.assertNotNull((Object)dto.getCryptoRepoFileId(), (String)"cryptoKeyDto.cryptoRepoFileId");
        CryptoRepoFileDto cryptoRepoFileDto = this.cryptoRepoFileId2CryptoRepoFileDto.get(cryptoRepoFileId);
        if (cryptoRepoFileDto != null) {
            this.addOutCryptoRepoFileDto(cryptoRepoFileDto);
        }
        if ((cryptoLinkDtos = this.toCryptoKeyId2CryptoLinkDtos.get(cryptoKeyId)) != null) {
            for (CryptoLinkDto cryptoLinkDto : cryptoLinkDtos) {
                if (this.isFromChildCryptoRepoFile(cryptoRepoFileId, cryptoLinkDto)) continue;
                this.addOutCryptoLinkDto(cryptoLinkDto);
            }
        }
        this.outCryptoChangeSetDto.getCryptoKeyDtos().add(dto);
    }

    private boolean isFromChildCryptoRepoFile(Uid cryptoRepoFileId, CryptoLinkDto cryptoLinkDto) {
        AssertUtil.assertNotNull((Object)cryptoRepoFileId, (String)"cryptoRepoFileId");
        AssertUtil.assertNotNull((Object)cryptoLinkDto, (String)"cryptoLinkDto");
        Uid fromCryptoKeyId = cryptoLinkDto.getFromCryptoKeyId();
        if (fromCryptoKeyId == null) {
            return false;
        }
        CryptoKeyDto fromCryptoKeyDto = this.cryptoKeyId2CryptoKeyDto.get(fromCryptoKeyId);
        if (fromCryptoKeyDto == null) {
            return false;
        }
        Uid fromCryptoRepoFileId = (Uid)AssertUtil.assertNotNull((Object)fromCryptoKeyDto.getCryptoRepoFileId(), (String)"fromCryptoKeyDto.cryptoRepoFileId");
        CryptoKeyRole fromCryptoKeyRole = (CryptoKeyRole)((Object)AssertUtil.assertNotNull((Object)((Object)fromCryptoKeyDto.getCryptoKeyRole()), (String)"fromCryptoKeyDto.cryptoKeyRole"));
        return CryptoKeyRole.backlinkKey == fromCryptoKeyRole && !cryptoRepoFileId.equals((Object)fromCryptoRepoFileId);
    }

    private void addOutCryptoLinkDto(CryptoLinkDto dto) {
        Uid toCryptoKeyId;
        CryptoKeyDto toCryptoKeyDto;
        CryptoKeyDto fromCryptoKeyDto;
        Uid fromCryptoKeyId;
        AssertUtil.assertNotNull((Object)dto, (String)"dto");
        Uid cryptoLinkId = (Uid)AssertUtil.assertNotNull((Object)dto.getCryptoLinkId(), (String)"cryptoLinkDto.cryptoLinkId");
        if (!this.cryptoLinkIdsProcessed.add(cryptoLinkId)) {
            return;
        }
        if (dto.getFromUserRepoKeyId() != null) {
            // empty if block
        }
        if ((fromCryptoKeyId = dto.getFromCryptoKeyId()) != null && (fromCryptoKeyDto = this.cryptoKeyId2CryptoKeyDto.get(fromCryptoKeyId)) != null) {
            this.addOutCryptoKeyDto(fromCryptoKeyDto);
        }
        if ((toCryptoKeyDto = this.cryptoKeyId2CryptoKeyDto.get(toCryptoKeyId = (Uid)AssertUtil.assertNotNull((Object)dto.getToCryptoKeyId(), (String)"cryptoLinkDto.toCryptoKeyId"))) != null) {
            this.addOutCryptoKeyDto(toCryptoKeyDto);
        }
        this.outCryptoChangeSetDto.getCryptoLinkDtos().add(dto);
    }

    private void addOutHistoCryptoRepoFileDto(HistoCryptoRepoFileDto dto) {
        HistoCryptoRepoFileDto previousDto;
        Uid previousHistoCryptoRepoFileId;
        CurrentHistoCryptoRepoFileDto currentHistoCryptoRepoFileDto;
        AssertUtil.assertNotNull((Object)dto, (String)"dto");
        Uid histoCryptoRepoFileId = (Uid)AssertUtil.assertNotNull((Object)dto.getHistoCryptoRepoFileId(), (String)"histoCryptoRepoFileDto.histoCryptoRepoFileId");
        if (!this.histoCryptoRepoFileIdsProcessed.add(histoCryptoRepoFileId)) {
            return;
        }
        Uid cryptoRepoFileId = (Uid)AssertUtil.assertNotNull((Object)dto.getCryptoRepoFileId(), (String)"histoCryptoRepoFileDto.cryptoRepoFileId");
        Uid histoFrameId = (Uid)AssertUtil.assertNotNull((Object)dto.getHistoFrameId(), (String)"histoCryptoRepoFileDto.histoFrameId");
        HistoFrameDto histoFrameDto = this.histoFrameId2HistoFrameDto.get(histoFrameId);
        if (histoFrameDto != null) {
            this.addOutHistoFrameDto(histoFrameDto);
        }
        if ((currentHistoCryptoRepoFileDto = this.cryptoRepoFileId2CurrentHistoCryptoRepoFileDto.get(cryptoRepoFileId)) != null) {
            this.addOutCurrentHistoCryptoRepoFileDto(currentHistoCryptoRepoFileDto);
        }
        if ((previousHistoCryptoRepoFileId = dto.getPreviousHistoCryptoRepoFileId()) != null && (previousDto = this.histoCryptoRepoFileId2HistoCryptoRepoFileDto.get(previousHistoCryptoRepoFileId)) != null) {
            this.addOutHistoCryptoRepoFileDto(previousDto);
        }
        this.outCryptoChangeSetDto.getHistoCryptoRepoFileDtos().add(dto);
    }

    private void addOutCurrentHistoCryptoRepoFileDto(CurrentHistoCryptoRepoFileDto dto) {
        AssertUtil.assertNotNull((Object)dto, (String)"dto");
        Uid cryptoRepoFileId = (Uid)AssertUtil.assertNotNull((Object)dto.getCryptoRepoFileId(), (String)"currentHistoCryptoRepoFileDto.cryptoRepoFileId");
        if (!this.currentHistoCryptoRepoFileIdsProcessed.add(cryptoRepoFileId)) {
            return;
        }
        Uid histoCryptoRepoFileId = (Uid)AssertUtil.assertNotNull((Object)dto.getHistoCryptoRepoFileId(), (String)"currentHistoCryptoRepoFileDto.histoCryptoRepoFileId");
        HistoCryptoRepoFileDto histoCryptoRepoFileDto = this.histoCryptoRepoFileId2HistoCryptoRepoFileDto.get(histoCryptoRepoFileId);
        if (histoCryptoRepoFileDto != null) {
            this.addOutHistoCryptoRepoFileDto(histoCryptoRepoFileDto);
        }
        this.outCryptoChangeSetDto.getCurrentHistoCryptoRepoFileDtos().add(dto);
    }

    private void addOutHistoFrameDto(HistoFrameDto dto) {
        AssertUtil.assertNotNull((Object)dto, (String)"dto");
        Uid histoFrameId = (Uid)AssertUtil.assertNotNull((Object)dto.getHistoFrameId(), (String)"histoFrameDto.histoFrameId");
        if (!this.histoFrameIdsProcessed.add(histoFrameId)) {
            return;
        }
        this.outCryptoChangeSetDto.getHistoFrameDtos().add(dto);
    }

    private void addOutCollisionDto(CollisionDto dto) {
        AssertUtil.assertNotNull((Object)dto, (String)"dto");
        this.outCryptoChangeSetDto.getCollisionDtos().add(dto);
    }

    private void addOutDeletedCollisionDto(DeletedCollisionDto dto) {
        AssertUtil.assertNotNull((Object)dto, (String)"dto");
        this.outCryptoChangeSetDto.getDeletedCollisionDtos().add(dto);
    }

    private void addOutCryptoConfigPropSetDto(CryptoConfigPropSetDto dto) {
        AssertUtil.assertNotNull((Object)dto, (String)"dto");
        this.outCryptoChangeSetDto.getCryptoConfigPropSetDtos().add(dto);
    }

    private void addOutUserRepoKeyPublicKeyReplacementRequestDeletionDto(UserRepoKeyPublicKeyReplacementRequestDeletionDto dto) {
        AssertUtil.assertNotNull((Object)dto, (String)"dto");
        this.outCryptoChangeSetDto.getUserRepoKeyPublicKeyReplacementRequestDeletionDtos().add(dto);
    }

    private void buildCryptoRepoFileId2CryptoRepoFileDto() {
        this.cryptoRepoFileId2CryptoRepoFileDto = null;
        HashMap<Uid, CryptoRepoFileDto> map = new HashMap<Uid, CryptoRepoFileDto>(this.inCryptoChangeSetDto.getCryptoRepoFileDtos().size());
        for (CryptoRepoFileDto dto : this.inCryptoChangeSetDto.getCryptoRepoFileDtos()) {
            map.put((Uid)AssertUtil.assertNotNull((Object)dto.getCryptoRepoFileId(), (String)"cryptoRepoFileDto.cryptoRepoFileId"), dto);
            if (dto.getParentCryptoRepoFileId() != null) continue;
            if (this.rootCryptoRepoFileDto != null) {
                throw new IllegalStateException("Multiple rootCryptoRepoFileDto?!!!");
            }
            this.rootCryptoRepoFileDto = dto;
        }
        this.cryptoRepoFileId2CryptoRepoFileDto = map;
        logger.info("buildCryptoRepoFileId2CryptoRepoFileDto: after indexing {} DTOs:", (Object)map.size());
        DebugUtil.logMemoryStats((Logger)logger);
    }

    private void buildCryptoKeyId2CryptoKeyDto() {
        this.cryptoKeyId2CryptoKeyDto = null;
        HashMap<Uid, CryptoKeyDto> map = new HashMap<Uid, CryptoKeyDto>(this.inCryptoChangeSetDto.getCryptoKeyDtos().size());
        for (CryptoKeyDto dto : this.inCryptoChangeSetDto.getCryptoKeyDtos()) {
            map.put((Uid)AssertUtil.assertNotNull((Object)dto.getCryptoKeyId(), (String)"cryptoKeyDto.cryptoKeyId"), dto);
        }
        this.cryptoKeyId2CryptoKeyDto = map;
        logger.info("buildCryptoKeyId2CryptoKeyDto: after indexing {} DTOs:", (Object)map.size());
        DebugUtil.logMemoryStats((Logger)logger);
    }

    private void buildToCryptoKeyId2CryptoLinkDtos() {
        this.toCryptoKeyId2CryptoLinkDtos = null;
        HashMap<Uid, List<CryptoLinkDto>> map = new HashMap<Uid, List<CryptoLinkDto>>();
        for (CryptoLinkDto dto : this.inCryptoChangeSetDto.getCryptoLinkDtos()) {
            Uid toCryptoKeyId = (Uid)AssertUtil.assertNotNull((Object)dto.getToCryptoKeyId(), (String)"cryptoLinkDto.toCryptoKeyId");
            LinkedList<CryptoLinkDto> list = (LinkedList<CryptoLinkDto>)map.get(toCryptoKeyId);
            if (list == null) {
                list = new LinkedList<CryptoLinkDto>();
                map.put(toCryptoKeyId, list);
            }
            list.add(dto);
        }
        this.toCryptoKeyId2CryptoLinkDtos = map;
        logger.info("buildToCryptoKeyId2CryptoLinkDtos: after indexing {} DTOs:", (Object)this.inCryptoChangeSetDto.getCryptoLinkDtos().size());
        DebugUtil.logMemoryStats((Logger)logger);
    }

    private void buildHistoFrameId2HistoFrameDto() {
        this.histoFrameId2HistoFrameDto = null;
        HashMap<Uid, HistoFrameDto> map = new HashMap<Uid, HistoFrameDto>();
        for (HistoFrameDto dto : this.inCryptoChangeSetDto.getHistoFrameDtos()) {
            map.put((Uid)AssertUtil.assertNotNull((Object)dto.getHistoFrameId(), (String)"histoFrameDto.histoFrameId"), dto);
        }
        this.histoFrameId2HistoFrameDto = map;
        logger.info("buildHistoFrameId2HistoFrameDto: after indexing {} DTOs:", (Object)map.size());
        DebugUtil.logMemoryStats((Logger)logger);
    }

    private void buildHistoCryptoRepoFileId2HistoCryptoRepoFileDto() {
        this.histoCryptoRepoFileId2HistoCryptoRepoFileDto = null;
        HashMap<Uid, HistoCryptoRepoFileDto> map = new HashMap<Uid, HistoCryptoRepoFileDto>();
        for (HistoCryptoRepoFileDto dto : this.inCryptoChangeSetDto.getHistoCryptoRepoFileDtos()) {
            map.put(dto.getHistoCryptoRepoFileId(), dto);
        }
        this.histoCryptoRepoFileId2HistoCryptoRepoFileDto = map;
        logger.info("buildHistoCryptoRepoFileId2HistoCryptoRepoFileDto: after indexing {} DTOs:", (Object)map.size());
        DebugUtil.logMemoryStats((Logger)logger);
    }

    private void buildCryptoRepoFileId2CurrentHistoCryptoRepoFileDto() {
        this.cryptoRepoFileId2CurrentHistoCryptoRepoFileDto = null;
        HashMap<Uid, CurrentHistoCryptoRepoFileDto> map = new HashMap<Uid, CurrentHistoCryptoRepoFileDto>();
        for (CurrentHistoCryptoRepoFileDto dto : this.inCryptoChangeSetDto.getCurrentHistoCryptoRepoFileDtos()) {
            Uid cryptoRepoFileId = (Uid)AssertUtil.assertNotNull((Object)dto.getCryptoRepoFileId(), (String)"currentHistoCryptoRepoFileDto.cryptoRepoFileId");
            CurrentHistoCryptoRepoFileDto old = map.put(cryptoRepoFileId, dto);
            if (old == null) continue;
            throw new IllegalStateException("Multiple CurrentHistoCryptoRepoFileDto for cryptoRepoFileId=" + cryptoRepoFileId);
        }
        this.cryptoRepoFileId2CurrentHistoCryptoRepoFileDto = map;
        logger.info("buildCryptoRepoFileId2CurrentHistoCryptoRepoFileDto: after indexing {} DTOs:", (Object)map.size());
        DebugUtil.logMemoryStats((Logger)logger);
    }

    public int getMaxCryptoChangeSetDtoSize() {
        return this.maxCryptoChangeSetDtoSize;
    }

    protected void nextOrCurrentOutCryptoChangeSetDto() {
        this.prepareOutCryptoChangeSetDto();
        if (this.maxCryptoChangeSetDtoSize > 0 && this.outCryptoChangeSetDto.size() >= (long)this.maxCryptoChangeSetDtoSize) {
            this.nextOutCryptoChangeSetDto();
        }
    }

    protected void nextOutCryptoChangeSetDto() {
        this.outCryptoChangeSetDto = null;
        this.prepareOutCryptoChangeSetDto();
    }

    protected void prepareOutCryptoChangeSetDto() {
        AssertUtil.assertNotNull(this.outCryptoChangeSetDtos, (String)"outCryptoChangeSetDtos");
        if (this.outCryptoChangeSetDto == null) {
            this.outCryptoChangeSetDto = new CryptoChangeSetDto();
            this.outCryptoChangeSetDto.setRevision(this.inCryptoChangeSetDto.getRevision());
            this.outCryptoChangeSetDto.setMultiPartIndex(this.outCryptoChangeSetDtos.size());
            this.outCryptoChangeSetDtos.add(this.outCryptoChangeSetDto);
        }
    }

    private void deleteEmptyOutCryptoChangeSetDto() {
        AssertUtil.assertNotNull(this.outCryptoChangeSetDtos, (String)"outCryptoChangeSetDtos");
        while (this.outCryptoChangeSetDto != null && this.outCryptoChangeSetDto.isEmpty()) {
            CryptoChangeSetDto removed = this.outCryptoChangeSetDtos.remove(this.outCryptoChangeSetDtos.size() - 1);
            if (this.outCryptoChangeSetDto != removed) {
                throw new IllegalStateException("outCryptoChangeSetDto != removed");
            }
            this.outCryptoChangeSetDto = this.outCryptoChangeSetDtos.isEmpty() ? null : this.outCryptoChangeSetDtos.get(this.outCryptoChangeSetDtos.size() - 1);
        }
    }

    private void updateMultiPartCount() {
        Uid multiPartId = new Uid();
        for (CryptoChangeSetDto cryptoChangeSetDto : this.outCryptoChangeSetDtos) {
            cryptoChangeSetDto.setMultiPartCount(this.outCryptoChangeSetDtos.size());
            cryptoChangeSetDto.setMultiPartId(multiPartId);
        }
    }

    public List<CryptoChangeSetDto> getOutCryptoChangeSetDtos() {
        return this.outCryptoChangeSetDtos;
    }

    public boolean isDestroyInput() {
        return this.destroyInput;
    }

    public CryptoChangeSetDtoSplitter setDestroyInput(boolean destroyInput) {
        this.destroyInput = destroyInput;
        return this;
    }
}

