/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.repo.listener;

import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.subshare.core.repo.listener.EntityModification;
import org.subshare.core.repo.listener.LocalRepoCommitEvent;
import org.subshare.core.repo.listener.LocalRepoCommitEventListener;
import org.subshare.core.repo.listener.LocalRepoCommitEventManager;

public class LocalRepoCommitEventManagerImpl
implements LocalRepoCommitEventManager {
    private final Map<UUID, ExecutorService> localRepositoryId2ExecutorService = new HashMap<UUID, ExecutorService>();
    private Map<UUID, List<LocalRepoCommitEventListener>> localRepositoryId2Listeners = new HashMap<UUID, List<LocalRepoCommitEventListener>>();

    protected LocalRepoCommitEventManagerImpl() {
    }

    public static LocalRepoCommitEventManager getInstance() {
        return Holder.instance;
    }

    public void fireLater(LocalRepoManager localRepoManager, List<EntityModification> modifications) {
        AssertUtil.assertNotNull((Object)localRepoManager, (String)"localRepoManager");
        AssertUtil.assertNotNull(modifications, (String)"modifications");
        UUID localRepositoryId = localRepoManager.getRepositoryId();
        final Iterator<LocalRepoCommitEventListener> globalListenerIterator = this.getListeners(null).iterator();
        final Iterator<LocalRepoCommitEventListener> specificListenerIterator = this.getListeners(localRepositoryId).iterator();
        if (!globalListenerIterator.hasNext() && !specificListenerIterator.hasNext()) {
            return;
        }
        final LocalRepoCommitEvent event = new LocalRepoCommitEvent(this, localRepoManager, modifications);
        this.getExecutorService(localRepositoryId).submit(new Runnable(){

            @Override
            public void run() {
                LocalRepoCommitEventListener listener;
                while (specificListenerIterator.hasNext()) {
                    listener = (LocalRepoCommitEventListener)specificListenerIterator.next();
                    if (listener == null) continue;
                    listener.postCommit(event);
                }
                while (globalListenerIterator.hasNext()) {
                    listener = (LocalRepoCommitEventListener)globalListenerIterator.next();
                    if (listener == null) continue;
                    listener.postCommit(event);
                }
            }
        });
    }

    @Override
    public void addLocalRepoCommitEventListener(LocalRepoCommitEventListener listener) {
        this.addLocalRepoCommitEventListener(null, listener);
    }

    @Override
    public void addLocalRepoCommitEventListener(UUID localRepositoryId, LocalRepoCommitEventListener listener) {
        AssertUtil.assertNotNull((Object)listener, (String)"listener");
        this.getListeners(localRepositoryId).add(listener);
    }

    @Override
    public void removeLocalRepoCommitEventListener(LocalRepoCommitEventListener listener) {
        this.removeLocalRepoCommitEventListener(null, listener);
    }

    @Override
    public void removeLocalRepoCommitEventListener(UUID localRepositoryId, LocalRepoCommitEventListener listener) {
        AssertUtil.assertNotNull((Object)listener, (String)"listener");
        this.getListeners(localRepositoryId).remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LocalRepoCommitEventListener> getListeners(UUID localRepositoryId) {
        Map<UUID, List<LocalRepoCommitEventListener>> map = this.localRepositoryId2Listeners;
        synchronized (map) {
            List<LocalRepoCommitEventListener> listeners = this.localRepositoryId2Listeners.get(localRepositoryId);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList<LocalRepoCommitEventListener>();
                this.localRepositoryId2Listeners.put(localRepositoryId, listeners);
            }
            return listeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutorService(final UUID localRepositoryId) {
        AssertUtil.assertNotNull((Object)localRepositoryId, (String)"localRepositoryId");
        Map<UUID, ExecutorService> map = this.localRepositoryId2ExecutorService;
        synchronized (map) {
            ExecutorService executorService = this.localRepositoryId2ExecutorService.get(localRepositoryId);
            if (executorService == null) {
                executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        return new Thread(r, "LocalRepoCommitEventManager_" + localRepositoryId);
                    }
                });
            }
            return executorService;
        }
    }

    private static final class Holder {
        public static final LocalRepoCommitEventManagerImpl instance = new LocalRepoCommitEventManagerImpl();

        private Holder() {
        }
    }
}

