/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.qtesla;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.qtesla.QTESLA;
import org.bouncycastle.pqc.crypto.qtesla.QTESLAKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.qtesla.QTESLAParameters;
import org.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;

public class QTESLAKeyPairGenerator {
    private SecureRandom random;
    private QTESLAParameters params;

    public void init(KeyGenerationParameters param) {
        QTESLAKeyGenerationParameters parameters = (QTESLAKeyGenerationParameters)param;
        this.random = parameters.getRandom();
        this.params = parameters.getParameters();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        byte[] secretKey;
        byte[] publicKey;
        if (this.params.k == 1) {
            publicKey = new byte[this.params.n * this.params.qLogarithm / 8 + 32];
            secretKey = new byte[this.params.n * 4 + 64];
            new QTESLA(this.random).generateKeyPair(publicKey, secretKey, this.params.n, this.params.w, this.params.q, this.params.qInverse, this.params.qLogarithm, this.params.generatorA, this.params.inverseNumberTheoreticTransform, this.params.xi, this.params.zeta, this.params.errorBound, this.params.secretBound);
        } else {
            publicKey = new byte[14880];
            secretKey = new byte[(this.params.k + 1) * this.params.n + 64];
            new QTESLA(this.random).generateKeyPair(publicKey, secretKey, this.params.n, this.params.k, this.params.w, this.params.q, this.params.qInverse, this.params.qLogarithm, this.params.generatorA, this.params.inverseNumberTheoreticTransform, this.params.xi, this.params.zeta, this.params.errorBound, this.params.secretBound);
        }
        System.err.println(publicKey.length + " " + secretKey.length);
        return new AsymmetricCipherKeyPair(new QTESLAPublicKeyParameters(publicKey), new QTESLAPrivateKeyParameters(secretKey));
    }
}

