/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp;

import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import java.util.Collections;
import java.util.Set;
import org.subshare.core.pgp.PgpAuthenticationCallback;
import org.subshare.core.pgp.PgpDecoder;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.PgpRegistry;
import org.subshare.core.pgp.PgpSignature;

public abstract class AbstractPgpDecoder
implements PgpDecoder {
    private IInputStream inputStream;
    private IOutputStream outputStream;
    private IInputStream signInputStream;
    private PgpKey decryptPgpKey;
    private PgpKey signPgpKey;
    private Set<PgpKeyId> signPgpKeyIds = Collections.emptySet();
    private PgpSignature pgpSignature;
    private boolean failOnMissingSignPgpKey = true;

    @Override
    public IInputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void setInputStream(IInputStream inputStream) {
        this.inputStream = inputStream;
    }

    protected IInputStream getInputStreamOrFail() {
        IInputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            throw new IllegalStateException("inputStream == null");
        }
        return inputStream;
    }

    @Override
    public IOutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void setOutputStream(IOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    protected IOutputStream getOutputStreamOrFail() {
        IOutputStream outputStream = this.getOutputStream();
        if (outputStream == null) {
            throw new IllegalStateException("outputStream == null");
        }
        return outputStream;
    }

    @Override
    public IInputStream getSignInputStream() {
        return this.signInputStream;
    }

    @Override
    public void setSignInputStream(IInputStream signInputStream) {
        this.signInputStream = signInputStream;
    }

    protected PgpAuthenticationCallback getPgpAuthenticationCallback() {
        PgpAuthenticationCallback pgpAuthenticationCallback = PgpRegistry.getInstance().getPgpAuthenticationCallback();
        return pgpAuthenticationCallback;
    }

    protected PgpAuthenticationCallback getPgpAuthenticationCallbackOrFail() {
        PgpAuthenticationCallback pgpAuthenticationCallback = this.getPgpAuthenticationCallback();
        if (pgpAuthenticationCallback == null) {
            throw new IllegalStateException("There is no PgpAuthenticationCallback assigned!");
        }
        return pgpAuthenticationCallback;
    }

    @Override
    public PgpKey getDecryptPgpKey() {
        return this.decryptPgpKey;
    }

    protected void setDecryptPgpKey(PgpKey decryptPgpKey) {
        this.decryptPgpKey = decryptPgpKey;
    }

    @Override
    public Set<PgpKeyId> getSignPgpKeyIds() {
        return this.signPgpKeyIds;
    }

    protected void setSignPgpKeyIds(Set<PgpKeyId> signPgpKeyIds) {
        this.signPgpKeyIds = signPgpKeyIds == null ? Collections.emptySet() : Collections.unmodifiableSet(signPgpKeyIds);
    }

    public PgpKey getSignPgpKey() {
        return this.signPgpKey;
    }

    protected void setSignPgpKey(PgpKey signPgpKey) {
        this.signPgpKey = signPgpKey;
    }

    @Override
    public boolean isFailOnMissingSignPgpKey() {
        return this.failOnMissingSignPgpKey;
    }

    @Override
    public void setFailOnMissingSignPgpKey(boolean failOnMissingSignPgpKey) {
        this.failOnMissingSignPgpKey = failOnMissingSignPgpKey;
    }

    @Override
    public PgpSignature getPgpSignature() {
        return this.pgpSignature;
    }

    public void setPgpSignature(PgpSignature pgpSignature) {
        this.pgpSignature = pgpSignature;
    }
}

