/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.histo;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.dto.NormalFileDto;
import co.codewizards.cloudstore.core.dto.RepoFileDto;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.util.List;
import javafx.scene.control.TreeItem;
import org.subshare.core.dto.CollisionPrivateDto;
import org.subshare.core.dto.HistoCryptoRepoFileDto;
import org.subshare.core.dto.PlainHistoCryptoRepoFileDto;

public class HistoCryptoRepoFileTreeItem
extends TreeItem<HistoCryptoRepoFileTreeItem> {
    private Boolean hasUnresolvedCollision;
    private final PlainHistoCryptoRepoFileDto plainHistoCryptoRepoFileDto;

    public HistoCryptoRepoFileTreeItem(PlainHistoCryptoRepoFileDto plainHistoCryptoRepoFileDto) {
        this.plainHistoCryptoRepoFileDto = (PlainHistoCryptoRepoFileDto)AssertUtil.assertNotNull((Object)plainHistoCryptoRepoFileDto, (String)"plainHistoCryptoRepoFileDto");
        AssertUtil.assertNotNull((Object)plainHistoCryptoRepoFileDto.getCryptoRepoFileId(), (String)"plainHistoCryptoRepoFileDto.cryptoRepoFileId");
        this.setValue((Object)this);
    }

    private HistoCryptoRepoFileTreeItem() {
        this.plainHistoCryptoRepoFileDto = null;
        this.setValue((Object)this);
    }

    public Uid getCryptoRepoFileId() {
        return this.plainHistoCryptoRepoFileDto.getCryptoRepoFileId();
    }

    public PlainHistoCryptoRepoFileDto getPlainHistoCryptoRepoFileDto() {
        return this.plainHistoCryptoRepoFileDto;
    }

    public HistoCryptoRepoFileDto getHistoCryptoRepoFileDto() {
        return this.plainHistoCryptoRepoFileDto.getHistoCryptoRepoFileDto();
    }

    public RepoFileDto getRepoFileDto() {
        return this.plainHistoCryptoRepoFileDto.getRepoFileDto();
    }

    public HistoCryptoRepoFileTreeItem getChildOrFail(String name) {
        HistoCryptoRepoFileTreeItem child = this.getChild(name);
        if (child == null) {
            throw new IllegalArgumentException(String.format("There is no child with name='%s'! children=%s", name, this.getChildren()));
        }
        return child;
    }

    public HistoCryptoRepoFileTreeItem getChild(String name) {
        AssertUtil.assertNotNull((Object)name, (String)"name");
        for (TreeItem c : this.getChildren()) {
            HistoCryptoRepoFileTreeItem child = (HistoCryptoRepoFileTreeItem)c;
            RepoFileDto repoFileDto = child.getPlainHistoCryptoRepoFileDto().getRepoFileDto();
            if (repoFileDto == null || !name.equals(repoFileDto.getName())) continue;
            return child;
        }
        return null;
    }

    public boolean hasCollision() {
        return !this.plainHistoCryptoRepoFileDto.getCollisionDtos().isEmpty();
    }

    public boolean hasUnresolvedCollision() {
        if (this.hasUnresolvedCollision == null) {
            this.hasUnresolvedCollision = this.determineHasUnresolvedCollision();
        }
        return this.hasUnresolvedCollision;
    }

    private boolean determineHasUnresolvedCollision() {
        List cpDtos = this.plainHistoCryptoRepoFileDto.getCollisionPrivateDtos();
        for (CollisionPrivateDto cpDto : cpDtos) {
            if (cpDto.getResolved() != null) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        RepoFileDto repoFileDto = this.plainHistoCryptoRepoFileDto.getRepoFileDto();
        return repoFileDto == null ? "<" + this.getCryptoRepoFileId() + ">" : (StringUtil.isEmpty((String)repoFileDto.getName()) ? "/" : repoFileDto.getName());
    }

    public Long getLength() {
        RepoFileDto repoFileDto = this.plainHistoCryptoRepoFileDto.getRepoFileDto();
        if (repoFileDto instanceof NormalFileDto && !PlainHistoCryptoRepoFileDto.Action.DELETE.equals((Object)this.plainHistoCryptoRepoFileDto.getAction())) {
            NormalFileDto normalFileDto = (NormalFileDto)repoFileDto;
            return normalFileDto.getLength();
        }
        return null;
    }

    public String toString() {
        return String.format("%s[name='%s']", ((Object)((Object)this)).getClass().getSimpleName(), this.getName());
    }

    public static class Root
    extends HistoCryptoRepoFileTreeItem {
    }
}

