/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.maintree;

import co.codewizards.cloudstore.core.bean.Bean;
import co.codewizards.cloudstore.core.bean.PropertyBase;
import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.subshare.core.repo.LocalRepo;
import org.subshare.core.repo.LocalRepoRegistry;
import org.subshare.gui.concurrent.SsTask;
import org.subshare.gui.localrepolist.LocalRepoListPane;
import org.subshare.gui.ls.LocalRepoRegistryLs;
import org.subshare.gui.maintree.LocalRepoMainTreeItem;
import org.subshare.gui.maintree.MainTreeItem;
import org.subshare.gui.maintree.ServerListMainTreeItem;

public class LocalRepoListMainTreeItem
extends MainTreeItem<String> {
    private static final Image icon = new Image(ServerListMainTreeItem.class.getResource("local-repo-list_16x16.png").toExternalForm());
    private LocalRepoRegistry localRepoRegistry;
    private PropertyChangeListener localReposPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            final LinkedHashSet localRepos = new LinkedHashSet((List)evt.getNewValue());
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    LocalRepoListMainTreeItem.this.addOrRemoveTreeItemsViewCallback(localRepos);
                }
            });
        }
    };

    public LocalRepoListMainTreeItem() {
        super("Local repositories");
        this.setGraphic((Node)new ImageView(icon));
        new Service<List<LocalRepo>>(){

            protected Task<List<LocalRepo>> createTask() {
                return new SsTask<List<LocalRepo>>(){

                    protected List<LocalRepo> call() throws Exception {
                        LocalRepoRegistry localRepoRegistry = LocalRepoListMainTreeItem.this.getLocalRepoRegistry();
                        return localRepoRegistry.getLocalRepos();
                    }

                    protected void succeeded() {
                        List localRepos;
                        try {
                            localRepos = (List)this.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                        LocalRepoListMainTreeItem.this.addTableItemsViewCallback(localRepos);
                        super.succeeded();
                    }
                };
            }
        }.start();
    }

    protected synchronized LocalRepoRegistry getLocalRepoRegistry() {
        if (this.localRepoRegistry == null) {
            this.localRepoRegistry = LocalRepoRegistryLs.getLocalRepoRegistry();
            PropertyChangeListenerUtil.addWeakPropertyChangeListener((Bean)this.localRepoRegistry, (PropertyBase)LocalRepoRegistry.PropertyEnum.localRepos, (PropertyChangeListener)this.localReposPropertyChangeListener);
        }
        return this.localRepoRegistry;
    }

    protected void addOrRemoveTreeItemsViewCallback(Set<LocalRepo> localRepos) {
        LocalRepoMainTreeItem lrmti;
        AssertUtil.assertNotNull(localRepos, (String)"localRepos");
        HashMap<Object, LocalRepoMainTreeItem> viewRepositoryId2LocalRepoMainTreeItem = new HashMap<Object, LocalRepoMainTreeItem>();
        for (TreeItem ti : this.getChildren()) {
            lrmti = (LocalRepoMainTreeItem)ti;
            viewRepositoryId2LocalRepoMainTreeItem.put(lrmti.getValueObject(), lrmti);
        }
        for (LocalRepo localRepo : localRepos) {
            if (viewRepositoryId2LocalRepoMainTreeItem.containsKey(localRepo)) continue;
            lrmti = new LocalRepoMainTreeItem(localRepo);
            viewRepositoryId2LocalRepoMainTreeItem.put(localRepo, lrmti);
            this.getChildren().add((Object)lrmti);
        }
        if (localRepos.size() < viewRepositoryId2LocalRepoMainTreeItem.size()) {
            for (LocalRepo localRepo : localRepos) {
                viewRepositoryId2LocalRepoMainTreeItem.remove(localRepo);
            }
            for (LocalRepoMainTreeItem lrmti2 : viewRepositoryId2LocalRepoMainTreeItem.values()) {
                this.getChildren().remove((Object)lrmti2);
            }
        }
    }

    private void addTableItemsViewCallback(Collection<LocalRepo> localRepos) {
        AssertUtil.assertNotNull(localRepos, (String)"localRepos");
        for (LocalRepo localRepo : localRepos) {
            this.getChildren().add((Object)new LocalRepoMainTreeItem(localRepo));
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    protected Parent createMainDetailContent() {
        return new LocalRepoListPane();
    }
}

