/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.util;

import co.codewizards.cloudstore.core.util.Util;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlatformUtil {
    private static final Logger logger = LoggerFactory.getLogger(PlatformUtil.class);
    private static final AtomicBoolean exiting = new AtomicBoolean();

    public static void runAndWait(Runnable runnable) throws co.codewizards.cloudstore.core.concurrent.ExecutionException {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
            return;
        }
        FutureTask<Object> future = new FutureTask<Object>(runnable, null);
        Platform.runLater(future);
        try {
            while (true) {
                if (exiting.get()) {
                    throw new co.codewizards.cloudstore.core.concurrent.ExecutionException("Not waiting, because 'exiting' flag is already true!");
                }
                try {
                    future.get(5L, TimeUnit.SECONDS);
                    return;
                }
                catch (TimeoutException x) {
                    Util.doNothing();
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new co.codewizards.cloudstore.core.concurrent.ExecutionException((Throwable)e);
        }
    }

    public static <T> T runAndWait(Callable<T> callable) throws co.codewizards.cloudstore.core.concurrent.ExecutionException {
        if (Platform.isFxApplicationThread()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new co.codewizards.cloudstore.core.concurrent.ExecutionException((Throwable)e);
            }
        }
        FutureTask<T> future = new FutureTask<T>(callable);
        Platform.runLater(future);
        try {
            while (true) {
                if (exiting.get()) {
                    throw new co.codewizards.cloudstore.core.concurrent.ExecutionException("Not waiting, because 'exiting' flag is already true!");
                }
                try {
                    return future.get(5L, TimeUnit.SECONDS);
                }
                catch (TimeoutException x) {
                    Util.doNothing();
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new co.codewizards.cloudstore.core.concurrent.ExecutionException((Throwable)e);
        }
    }

    public static void notifyExiting() {
        exiting.compareAndSet(false, true);
    }

    private PlatformUtil() {
    }

    public static void assertFxApplicationThread() {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException(String.format("Thread mismatch! This thread (%s) is not the Java FX application thread! UI methods must not be invoked on other threads!", Thread.currentThread().toString()));
        }
    }
}

