/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local;

import co.codewizards.cloudstore.core.config.Config;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.security.SecureRandom;
import org.subshare.core.crypto.KeyFactory;

public class FilePaddingLengthRandom {
    private final Config config;
    private static final int[] defaultLengthProbability = new int[]{700, 250, 50, 0, 0, 0};
    private int[] lengthProbability;
    private int lengthProbabilitySum;
    private static SecureRandom random = KeyFactory.secureRandom;

    public FilePaddingLengthRandom(File file) {
        this(ConfigImpl.getInstanceForFile((File)((File)AssertUtil.assertNotNull((Object)file, (String)"file"))));
    }

    public FilePaddingLengthRandom(Config config) {
        this.config = (Config)AssertUtil.assertNotNull((Object)config, (String)"config");
        this.populateLengthProbability();
    }

    private void populateLengthProbability() {
        this.lengthProbability = new int[LengthCategory.values().length];
        this.lengthProbabilitySum = 0;
        for (LengthCategory lengthCategory : LengthCategory.values()) {
            int probability;
            String key = lengthCategory.getConfigPropertyKey();
            this.lengthProbability[lengthCategory.ordinal()] = probability = this.config.getPropertyAsPositiveOrZeroInt(key, defaultLengthProbability[lengthCategory.ordinal()]);
            this.lengthProbabilitySum += probability;
        }
    }

    public long nextPaddingLength() {
        if (this.lengthProbabilitySum < 1) {
            return 0L;
        }
        LengthCategory lengthCategory = this.nextLengthCategory();
        long length = Math.abs(random.nextLong());
        length %= lengthCategory.getMaxLength() - lengthCategory.getMinLength();
        return length += lengthCategory.getMinLength();
    }

    private LengthCategory nextLengthCategory() {
        int p = random.nextInt(this.lengthProbabilitySum);
        for (int i = 0; i < this.lengthProbability.length; ++i) {
            if (p < this.lengthProbability[i]) {
                return LengthCategory.values()[i];
            }
            p -= this.lengthProbability[i];
        }
        throw new IllegalStateException("WTF?!");
    }

    static {
        if (defaultLengthProbability.length != LengthCategory.values().length) {
            throw new IllegalStateException(String.format("defaultLengthProbability.length != LengthCategory.values().length :: %d != %d", defaultLengthProbability.length, LengthCategory.values().length));
        }
    }

    public static enum LengthCategory {
        _100K(0L, 102400L),
        _1M(102400L, 0x100000L),
        _10M(0x100000L, 0xA00000L),
        _100M(0xA00000L, 0x6400000L),
        _1G(0x6400000L, 0x40000000L),
        _10G(0x40000000L, 0x280000000L);

        private long minLength;
        private long maxLength;

        private LengthCategory(long minLength, long maxLength) {
            this.minLength = minLength;
            this.maxLength = maxLength;
        }

        public long getMinLength() {
            return this.minLength;
        }

        public long getMaxLength() {
            return this.maxLength;
        }

        public String getCategoryId() {
            if (this.name().charAt(0) != '_') {
                throw new IllegalStateException("name does not start with '_'!");
            }
            return this.name().substring(1);
        }

        public String getConfigPropertyKey() {
            String key = String.format("filePaddingLengthProbability[%s]", this.getCategoryId());
            return key;
        }
    }
}

