/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.oio;

import co.codewizards.cloudstore.core.oio.FileFactory;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OioRegistry {
    private static final Logger logger = LoggerFactory.getLogger(OioRegistry.class);
    private final FileFactory fileFactory = this.getPrioritizedService(FileFactory.class);

    private OioRegistry() {
        logger.info("Preferred implementation '{}' for fileFactory", (Object)this.fileFactory.getClass().getSimpleName());
    }

    private <N extends FileFactory> N getPrioritizedService(Class<N> n) {
        Iterator<N> it = ServiceLoader.load(n).iterator();
        FileFactory highPrio = null;
        while (it.hasNext()) {
            FileFactory i = (FileFactory)it.next();
            if (highPrio == null) {
                highPrio = i;
                continue;
            }
            if (highPrio.getPriority() >= i.getPriority()) continue;
            highPrio = i;
        }
        if (highPrio == null) {
            throw new IllegalStateException("Could not get an implementation for interface: " + n.getName());
        }
        return (N)highPrio;
    }

    public static OioRegistry getInstance() {
        return OioProviderHolder.instance;
    }

    public FileFactory getFileFactory() {
        return this.fileFactory;
    }

    private static class OioProviderHolder {
        public static final OioRegistry instance = new OioRegistry();

        private OioProviderHolder() {
        }
    }
}

