/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.crypto;

import co.codewizards.cloudstore.core.config.Config;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.oio.File;
import org.subshare.core.crypto.CipherTransformation;
import org.subshare.core.sign.SignerTransformation;

public class CryptoConfigUtil {
    public static final String CONFIG_KEY_BACKDATING_MAX_PERMISSION_VALID_TO_AGE = "backdatingMaxPermissionValidToAge";
    public static final long CONFIG_DEFAULT_VALUE_BACKDATING_MAX_PERMISSION_VALID_TO_AGE = 259200000L;

    private CryptoConfigUtil() {
    }

    public static CipherTransformation getSymmetricCipherTransformation() {
        return (CipherTransformation)ConfigImpl.getInstance().getPropertyAsEnum("symmetricCipherTransformation", (Enum)CipherTransformation.CONFIG_DEFAULT_VALUE_SYMMETRIC);
    }

    public static CipherTransformation getAsymmetricCipherTransformation() {
        return (CipherTransformation)ConfigImpl.getInstance().getPropertyAsEnum("asymmetricCipherTransformation", (Enum)CipherTransformation.CONFIG_DEFAULT_VALUE_ASYMMETRIC);
    }

    public static SignerTransformation getSignerTransformation() {
        return (SignerTransformation)ConfigImpl.getInstance().getPropertyAsEnum("signerTransformation", (Enum)SignerTransformation.CONFIG_DEFAULT_VALUE);
    }

    public static long getBackdatingMaxPermissionValidToAge(File file) {
        Config config = file.isDirectory() ? ConfigImpl.getInstanceForDirectory((File)file) : ConfigImpl.getInstanceForFile((File)file);
        return config.getPropertyAsLong(CONFIG_KEY_BACKDATING_MAX_PERMISSION_VALID_TO_AGE, 259200000L);
    }
}

