/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.dto;

import co.codewizards.cloudstore.core.dto.NormalFileDto;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.subshare.core.dto.SignatureDto;
import org.subshare.core.dto.SsRepoFileDto;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signature;

@XmlRootElement
public class SsNormalFileDto
extends NormalFileDto
implements SsRepoFileDto {
    public static final String SIGNED_DATA_TYPE = "NormalFile";
    private String parentName;
    @XmlElement
    private SignatureDto signatureDto;
    private long lengthWithPadding = -1L;

    @Override
    public String getParentName() {
        return this.parentName;
    }

    @Override
    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    @Override
    public String getSignedDataType() {
        return SIGNED_DATA_TYPE;
    }

    @Override
    public int getSignedDataVersion() {
        return 0;
    }

    @Override
    public InputStream getSignedData(int signedDataVersion) {
        try {
            byte separatorIndex = 0;
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[9];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource(this.getName());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource(separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource(this.parentName);
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[3] = InputStreamSource.Helper.createInputStreamSource(separatorIndex);
            inputStreamSourceArray[4] = InputStreamSource.Helper.createInputStreamSource(this.getLength());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[5] = InputStreamSource.Helper.createInputStreamSource(separatorIndex);
            inputStreamSourceArray[6] = InputStreamSource.Helper.createInputStreamSource(this.getLengthWithPadding());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[7] = InputStreamSource.Helper.createInputStreamSource(separatorIndex);
            inputStreamSourceArray[8] = InputStreamSource.Helper.createInputStreamSource(this.getLastModified());
            return new MultiInputStream(inputStreamSourceArray);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    @Override
    @XmlTransient
    public Signature getSignature() {
        return this.signatureDto;
    }

    @Override
    public void setSignature(Signature signature) {
        this.signatureDto = SignatureDto.copyIfNeeded(signature);
    }

    public long getLengthWithPadding() {
        return this.lengthWithPadding;
    }

    public void setLengthWithPadding(long paddingLength) {
        this.lengthWithPadding = paddingLength;
    }

    protected String toString_getProperties() {
        return super.toString_getProperties() + ", lengthWithPadding=" + this.lengthWithPadding + ", parentName=" + this.parentName + ", signatureDto=" + this.signatureDto;
    }
}

